# Silica

## Организация интерфейса

В этом модуле мы изучим интерфейс ОС Аврора и  познакомимся с компонентами библиотеки Silica, а также узнаем, что нужно учитывать при стилизации приложения.

## Экран блокировки

Первая отличительная особеннность интерфейса ОС Аврора в том, что он изначально был спроектирован таким образом, чтобы управление осуществлялось только жестами. Распознаваемых жестов довольно много, однако привыкнуть к ним не так сложно. Silica включает в себя несколько компонентов, разработанных под различные жесты пользователя.

Вторая особенность, это многозадачность, благодаря которой вы можете увидеть все запущенные вами приложения на одном рабочем столе, переключаться между ними, а также управлять приложениями в свернутом виде. 

Внешним видом интерфейса управляют атмосферы. Кроме обоев, атмосферы могут изменять цвета, шрифты и звуки. 

Для запущенных приложений доступно все пространство экрана, благодаря чему сенсорные элементы могут размещаться в разных частях. 

## Домашний экран

Познакомимся подробнее с интерфейсом устройства с помощью эмулятора. Первое, что мы видим при запуске - это экран блокировки. На нем отображается время, дата и основная информация о статусе устройства - уровень заряда, подключение к сети и так далее. Кроме того, здесь могут отображаться уведомления. В настройках можно указать приложения для быстрого доступа. 

Разблокировать устройство можно свайпом слева направо. При желании можно установить пароль, тогда при свайпе появится клавиатура для его ввода. 

## События

После разблокировки мы видим домашний экран. В отличии от привычных нам иконок часто используемых приложений, здесь содержатся только запущенные приложения в свернутом виде, этот элемент называется обложкой. Отсюда вы можете быстро переключаться из одного приложения в другое или использовать встроенные действия обложки, позволяющие управлять приложением. Нажатие на обложку открывает приложение, а свернуть приложение и вернуться на домашний экран можно свайпом слева направо. 

Обложки приложения располагаются в том порядке, в котором приложения были открыты, и при повторном доступе к ним порядок не меняется. Когда количество открытых приложений превышает размеры экрана, домашняя страница растет вертикально.

Остановить приложение можно, вызвав значок закрытия долгим нажатием на него. Чтобы закрыть все приложения, после долго нажатия необходимо жестом сверху вниз вытянуть меню. 

## Панель приложений

Свайпом слева направо из домашнего экрана мы переключаемся на экран событий. Здесь можем увидеть уведомления, погоду и другую информацию. Здесь же можно установить календарь. 

## Верхнее меню

Чтобы получить доступ ко всем установленным приложениям, достаточно потянуть снизу экрана вверх. Это меню приложений, к которому есть доступ с любого экрана. Отсюда приложения запускаются и разворачиваются на весь экран. 

## Атмосфера

Помимо нижнего меню приложений есть также верхнее меню, тоже доступное с любого экрана. Открываем его жестом сверху вниз. Здесь мы получаем доступ к быстрому управлению устройством - смена атмосферы, настриваемые кнопки управления, из этого меню можно отключить, перезагрузить или заблокировать устройство. 

Атмосфера задает не только внешний вид экранов, но также вид  приложений, использующих стандартные компоненты интерфейса. Атмосферу можно выбрать из уже предложенных, либо создать свою собственную из любой картинки. 

## Qt Quick — технология быстрой разработки

Как мы уже обсуждали ранее, основные типы для создания пользовательских интерфейсов на основе QML содержаться в модуле Qt Quick. Для работы с сенсорными компонентами фреймворк Qt использует модуль Qt Quick Controls. Однако для разработки интерфейсов в ОС Аврора есть библиотека собственных компонентов Silica, учитывающая особенности этой операционной системы.

## Визуальные элементы Silica

Silica позволяет создавать пользовательские интерфейсы приложений, которые соответсвуют визуальному стилю ОС Аврора и изменяют его в зависимости от атмосферы, ведут себя в соответствии со стандартными приложениями и используют уникальные для ОС Аврора элементы, например вытягиваемые меню и обложки приложений.

Для разработки приложений ОС Аврора в qml документе необходимо импортировать модуль Qt Quick (версия от 2.0 до 2.6) и модуль Sailfish.Silica 1.0

## Невизуальные элементы Silica

Библиотека содержит как визуальные, так и невизуальные элементы, все доступные на данный момент компоненты можно посмотреть на слайде. 

Зеленым цветом отмечены элементы модуля Qt Quick, желтым - библиотеки Silica 

## ApplicationWindow — точка входа [1]

ApplicationWindow это верхнеуровневый компонент приложения, который является точкой входа в него. У каждого приложения может быть только один объект этого типа. 

## ApplicationWindow — точка входа [2]

ApplicationWindow позволяет указать первую загружаемую страницу приложения, управлять стеком страниц, устанавливает обложку приложения, задает фоновое изображение и управляет ориентацией приложения на экране. 

С помощью свойства allowedOrientations можно задать как определенную ориентацию - портретная, ландшафтная или их инвертированные версии, так и их маски или разрешить все доступные ориентации. Поскольку элементы интерфейса организованы иерархично, ориентации отдельных страниц будут зависеть от разрешенной ориентации элемента AplicationWindow. 

## Page — страница приложения [1]

Тип Page представляет собой контейнер для содержимого одного экрана приложения. Его свойства ширины и высоты автоматически подстраиваются под размеры контента. Ориентация отдельной страницы зависит от ориентации всего приложения, поэтому если в ApplicationWindow заданы все возможные ориентации, мы можем ограничить ориентацию отдельной страницы, но не наоборот. По умолчанию для страницы задана портретная ориентация. 

Помимо ориентации, мы можем управлять навигацией страницей, например, разрешить или запретить переход к следующим или предыдущим страницам, а также задать направление переключения - вертикальное или горизонтальное. 

Свойство статус содержит актуальный статус страницы, загружаемый в стеке страниц. На слайде пример кода, позволяющий отследить текущий статус страницы. 

## Page — страница приложения [2]

При нажатии на кнопку мы загружаем следующую страницу приложения. Во время перехода статус страницы Activating, а при загрузке статус меняется на Active. 

## PageHeader — заголовок страницы

Элемент PageHeader предоставляет стилизованный заголовок страницы. Он располагается в правом верхнем углу страницы. Значение title содержит отображаемый текст заголовка. Кроме этого можно указать описание страницы в свойстве description или добавить дополнительное содержимое, например, иконку с помощью свойства extraContent.

## PageStack — контроль навигации

Контроль за навигацией между страницами осуществляет элемент PageStack. Каждое приложение, состоящее из более одной страницы содержит единственный объект PageStack. Окно приложения отображает страницу, находящейся на вершине стека. 

Поместить и извлечь страницу можно с помощью привычных операций push, pop. С помощью свойств мы можем узнать глубину стека, какая страница находится в данный момент на вершине и статус стека при анимации перехода страниц. 

Кроме этого есть возможность прикрепить страницу с помощью метода pushAttached(), то есть загрузить ее, но не отобразить на экране. Прикрепленную страницу можно извлечь методом popAttached, а также можно перемещаться по стеку с помощью методов NavigateBack и NavigateForward. 

## Операции PageStack: push и pop

Давайте посмотрим на примере работу с методами стека. В первом случае у нас загружена страница с единственной кнопкой, нажав на нее, мы обращаемся к методу push элемента PageStack, загружаем в стек еще одну страницу и сразу же переходим на ее. При загрузке второй страницы значение глубины стека становится равно двум. Извлечь эту страницу из стека можно с помощью кнопки pop, а можно с помощью индикатора, появляющегося в левом верхнем углу. Он позволяет перейти на предыдущую страницу, извлекая тем самым, текущую страницу из стека. 

## Операции PageStack: pushAttached

В следующем примере мы использовали метод pushAttached, с его помощью мы не загружаем новую страницу на экран, а как бы готовим ее к загрузке. Обратите внимание, что после нажатия кнопки индикатор перехода теперь появился и в правом верхнем углу. Нажав на него мы перейдем на прикрепленную страницу методом NavigateForward, и она появится в стеке. 

Метод NavigateBack не закрывает страницу, то есть индикатор перехода на нее сохраняется, однако глубина стека в этом случае уменьшается, т.е. страница становится прикрепленной.

## Cover — обложка приложения [1]

Обложка приложения отображается на главном экране смартфона когда приложение свернуто и работает в фоновом режиме.

На обложке можно разместить важную информацию о статусе приложения, например, количество непрочитанных писем, миниатюры изображений из галереи. Кроме этого, на обложке могут размещаться несколько иконок действий для управление прилжением в свернутом режиме.

Тип ApplicationWindow содержит свойство cover, которое позволяет загрузить файл или описать обложку в типе  Cover.

Кроме того, обложка является контейнером для нескольких типов. Компонент CoverActionList предназначен для размещение элементов управления на обложке. CoverAction позволяет описать одно такое действие при касании к обложке. Касания пользователя активируют обработчик действий onTriggered.

Чаще всего на экране используют второй тип обложки - CoverBackground, эта обложка является полупрозрачной по умолчанию. Обложка типа Cover является прозрачной.

## Cover — обложка приложения [2]

Рассмотрим пример браузера, на обложке которого мы разместили метку с текстом заголовка текущей открытой страницы, а также два элемента CoverAction для навигации между web-страницами. При нажатии, обработчики сигналов переходят на следующую или предыдущую страницу в браузере. Обратите внимание, что и в свернутом виде заголовок текущей страницы изменяется в зависимости от действий пользователя.

## Label — вывод текста [1]

Label – QML-компонент для отображения стилизованного текста в ОС Аврора.
По умолчанию цвет текста и шрифт устанавливаются в соответствии с текущей атмосферой. 

Label унаследован от компонента Text, поэтому все его свойства, методы и сигналы так же доступны и для объектов этого типа.

Однако у Label есть и свое собственные свойства, с помощью которых можно подсветить текст, выделив его на странице, задать собственную цветовую палитру с помощью свойства palette. 

## Label — вывод текста [2]

Свойство truncationMode определяет какой эффект будет применен к тексту, если строка не помещается в элемент Label полностью.

- Значение None используется по умолчанию и в этом случае текст будет просто обрезан в конце элемента Label.
- Значение Elide преобразует не умещающийся текст в троеточие в конце строки.
- Значение Fade делает конец строки затухающим как показано на слайде. 

При разработке под ОС Аврора принято использовать значение Fade для однострочного текста и Elide для многострочного.

## LinkedLabel — форматируемый текст [1]

Тип LinkedLabel предоставляет текстовый абзац в стиле ОС Аврора со встроенным синтаксическим анализатором, который обнаруживает URL-адреса, номера телефонов и адреса электронной почты и выделяет их в качестве вставляемых ссылок. При нажатии на ссылку открывается приложение, установленное в качестве обработчика по умолчанию для типа ссылки, например, браузер, телефонная книга и другие.

Действия ссылок можно отключить, установив флаг defaultLinkActions в значение false, а добавить  собственную обработку ссылок можно, реализовав обработчик сигнала onLinkActivated.

Текст, заданный в свойстве plainText, будет обработан анализатором ссылок, а флаг shortenUrl помогает сократить url адрес в тексте, в частности, убрать название протокола.

## LinkedLabel — форматируемый текст [2]

Свойство linkColor устанавливает цвет для ссылки, по умолчанию используется цвет атмосферы, предназначенный для подсвеченных элементов. Подробнее о работе с цветами будем говорить в уроке, посвященному стилизации интерфейса приложений. 

## TextField — ввод однострочного текста [1]

Для ввода текста в ОС Аврора используются типы TextField и TextArea.

TextField — QML-тип для ввода и редактирования однострочного текста.
Помимо вводимого текста и стандартных методов работы с ним, TextField обладает свойством placeholderText, отображаемый в поле до ввода пользователем. В этом свойстве можно задать подсказку для пользователя, с началом ввода текст исчезнет.

Свойство label задает текст, который отображается под полем сразу после начала ввода пользователем. Запрет ввода текста устанавливается флагом readOnly, а кроме непосредственно ввода текста в данном компоненте мы можем задать специальную клавиатуру, служащую подсказкой для ввода, формат кнопки Enter и осуществить проверку ввода с помощью валидаторов. 

## TextField — ввод однострочного текста [2]

В данном примере мы задале поле для ввода числа от -10 до 10, эту подсказку мы описали в свойстве placeholderText, а в свойстве лейбл указали назначения поля. Для ввода чисел мы задали специальную клавиатуру, а валидатор ограничил нас в допустимом диапазоне. Также мы поработали над кнопкой ввода - запретили ее подсветку, назначили ей определенную иконку, а при клике на ней, выводим текст пользователя в консоль. 

## InputMethodHint — виртуальная клавиатура

Давайте подробнее рассмотрим перечень доступных клавиатур для ввода. 

- Qt.ImhDialableCharactersOnly –  предназначенна для ввода телефонного номера. 
- Qt.ImhDigitsOnly – позволяет вводить только целые числа.
- Qt.ImhEmailCharactersOnly – позволяет вводить только символы, допустимые в адресах электронной почты.
- Qt.ImhFormattedNumbersOnly – позволяет вводить только десятичные числа.
- Qt.ImhNoPredictiveText – отключает возможность предиктивного(интеллектуального) ввода.
- Qt.ImhUrlCharactersOnly – позволяет вводить только символы, допустимые в веб-адресах.
- Qt.ImhNoAutoUppercase – отключает автоматическое переключение в верхний регистр в начале предложения.

Допустимо и использование сразу нескольких установок свойства одновременно с помощью символа “|”.

## Validator — проверка ввода [1]

Валидатор используется для фильтрации введенного текста и предотвращения ввода недопустимого текста. Этот элемент проверяет, вводится ли пользователем в поле тот тип данных, который задан при создании этого поля.

Три типа валидаторов позволяют задать ввод целых или вещественных чисел и ввод согласно заданному регулярном выражению. 

## Validator — проверка ввода [2]

Числовые валидаторы задают границы доступимого диапазона, для вещественных чисел также задается количество цифр после запятой. Кроме этого задается локаль для отображения числа в нужном формате и необходимая нотация, по умолчанию используется экспоненциальная нотация. 

## TextArea — ввод многострочного текста [1]

TextArea — QML-тип для ввода и редактирования многострочного текста.
Компонент обладает практически теми же свойствами, что и TextField, однако имеет несколько важных отличий. 

Во-первых, для TextArea невозможно использования валидаторов и  заданных виртуальных клавиатур. Во-вторых, в отличие от TextFiled здесь присутствуют свойства для горизонтального  и вертикального выравнивания, а также для установки режима переноса текста на следующую строку. По умолчанию свойсто WrapMode принимает значение NoWrap.

Если у TextArea не заданы ширина и высота, то площадь будет изменяться в соответствии с введенным текстом, то есть, он будет выходить за пределы экрана или увеличиваться вниз. Поэтому рекомендуется установить значения для размера. 

## TextArea — ввод многострочного текста [2]

В примере мы описали два объекта textArea, в первом случае мы указали режим переноса по словам, во втором случае в свойстве текст мы заранее ввели то, что хотим увидеть на экране. Здесь мы не задавали режим переноса, однако в значении свойства мы добавили символы переноса каретки, которые были распознаны. 

## Button — кнопка

Перейдем теперь к элементам управления. Наиболее используемый элемент - это кнопка. Тип Button задает стилизованную кнопку с текстовой меткой.

Компонент Button наследует QML тип MouseArea поэтому любые свойства, методы и обработчики сигналов будут унаследованы. 

Размеры кнопки можно установить в свойстве preferredWidth. Не рекомендуется устанавливать ширину кнопки явно. Правильный подход в этом случае - воспользоваться размерами компонента Theme. О нем мы поговорим подробнее в уроке о стилизации. 

В примере мы описали простую кнопку среднего размера, выровненную посередине страницы. В свойстве текст можно задать нужную команду. Обработчик сигнала onClicked выводит в консоль уведомление о нажатии кнопки. 

## IconButton — кнопка в виде иконки

Эта кнопка позволяет задать иконку вместо текста. Отображается такая кнопка в виде круга. Свойство highlighted отражает подсвечена ли кнопка или нет. Свойство icon позволяет задать изображение для кнопки. Поскольку иконка представлена типом Image, мы можем работать со свойствами этого компонента.

В данном примере используется одна из встроенных иконок из Silica, здесь мы увеличили ее размер в два раза, однако лучше использовать для этого свойства типа Theme, чтобы получить возможность подстраивать размеры кнопки под различные размеры экрана.

## ValueButton — кнопка со значением

Тип ValueButton предоставляет интерактивный элемент управления со стилизованной меткой и значением. Данная кнопка позволяет отображать дополнительную информацию в своём теле. Вместо text  здесь представлены 3 свойства: label, value и description. Свойства label и value содержат текст кнопки и выбранное значение соответственно. Свойство description содержит описание кнопки. 

Обычно такая кнопка используется для отображения результата действия пользователя. Например, приведенный ниже код представляет собой счетчик нажатий, инкриминируя значение свойства value. 

## Switch — кнопка переключения 

Switch – QML-компонент который представляет собой переключатель с возможностью отображения иконки.

Switch унаследован от компонента MouseArea и наследует его свойства, методы и сигналы.
Но также обладает и собственными атрибутами.

Флаг checked определяет статус переключателя. Свойство busy указывает, находится ли переключатель в состоянии "занят" и должен мигать в этом состоянии. Обычно он применяется в ситуации, когда изменение какой-либо настройки не должно (или не может) происходить мгновенно, но нужно показать индикацию процесса выполнения изменений.

Кроме компонента Switch есть еще два вида переключателей. 

TextSwitch –  представляет собой переключатель с возможностью отображения текстовой метки.
В отличие от компонента Switch этот переключатель не имеет возможности отображать иконку.

Собственные свойства TextSwitch задают метку рядом с индикатором статуса и описание переключателя.

IconTextSwitch – QML-компонент предоставляющий переключатель с возможностью отображения и иконки, и текстовой метки.

## Примеры переключателей

В примере мы описали три вида переключателей.
Обратите внимание, что в случае IconTextSwitch иконка отображается справа. 

## Keypad — экранная клавиатура

Виртуальная клавиатура для набора телефонных номеров или цифровых паролей выводится с помощью компонента KeyPad. Такая клавиатура состоит из 12 клавиш в сетке 3*4. С помощью свойств данного типа можно отобразть или скрыть символы звездочка и решетка во флаге symbolsVisible, задать вывод буквенных символов под цифрами, а также настроить иконку для голосовой почты.

Клавиатура реагирует на различные нажатия пользователя и позволяет настроить обработчики соответствующих сигналов. 

Для вывода такой клавиатуры достаточно создать объект типа KeyPad, в нашем примере мы расположили ее снизу экрана. 

## TouchBlocker — перехват нажатий

TouchBlocker — тип, который перехватывает все события сенсорного экрана. Он может быть задействован в том случае, когда необходимо ограничить возможность пользователя взаимодействовать с элементами в конкретный момент времени или на конкретной странице.

Код, представленный на слайде, показывает создание списка, с которым пользователь не сможет взаимодействовать. Для этого в свойстве anchors.fill объекта TouchBlocker мы указываем id того элемента, взаимодействие с которым хотим ограничить. 

## Контейнеры

Организацию содержимого страницы обеспечивают контейнеры. 

Большинство этих контейнеров унаследовано от компонентов QtQuick и обладают всеми свойствами родителей, однако есть и собственные, например SlideShowView, DockedPanel и Drawer. 

## SilicaFlickable — общий контейнер [1]

Контейнер SilicaFlickable добавляет возможность прокрутки страницы, если ее содержимое превышает размеры экрана. Также этот контейнер позволяет добавлять на страницу элементы вытягиваемых меню. Методы ScrollToBottom и ScrollToTop позволяют быстро прокрутить содержимое к концу или началу страницы. С помощью quickScroll можно включить или отключить вертикальную область быстрой прокрутки.

Хорошим тоном считается использование декораторов прокрутки при использовании типов, которые поддерживают возможность прокручивания. Декораторы прокрутки представлены типами ScrollDecorator, VerticalScrollDecorator и HorizontalScrollDecorator. ScrollDecorator позволяет отображать и вертикальный и горизонтальный декораторы одновременно. 

## SilicaFlickable — общий контейнер [2]

В примере мы описали объект типа SilicaFlickable и внутрь него поместили контейнер Column и создали возможность прокрутки изображений. В этом случае добавляем вертикальный индикатор прокрутки. 

## SilicaListView — список элементов [1]

Организовать контент в виде списка возможно с помощью SilicaListView. Данный контейнер обладает свойстивом model, определяющим данные, которые будет отображать список, а также свойством delegate, определяющим внешний вид элементов списка.

## SilicaListView — список элементов [2]

Простейшим примером модели может быть компонент ListModel, являющийся контейнером для объектов типа ListElement. 

Для визуализации ползунка прокрутки также нужно использовать VerticalScrollDecorator

В примере мы описали модель списка из 100 элементов, каждый из которых состоит из текста Item и индекса элемента, начинающегося с единицы. Подробнее на моделях и делегатах мы остновимся в следующем модуле. 

## SilicaGridview — таблица [1]

SilicaGridView, как и  его родитель, позволяет отображать набор элементов в виде таблицы. Этот тип обладает свойствами модель и делегат, а также свойствами, позволящими настраивать размер ячеек.  К таблице можно применять как вертикальный, так и горизонтальный индикатор прокрутки. 

## SilicaGridview — таблица [2]

Пример также содержит в себе набор из 100 элементов, в виде их индекса. Эти элементы организованы в таблицу из 4 столбцов, и, соответственно 25 колонок. 

## SlideshowView — слайды по циклу [1]

SlideshowView – QML-компонент для отображения данных в виде слайдшоу. 

Перелистыванием элементов в слайдшоу управляет пользователь. 
Навигация по SlideshowView циклическая. После последнего элемента будет отображен первый.

SlideshowView так же как SilicaListView и SilicaGridView обладает свойствами model и delegate.

Свойства itemHeight и itemWidth определяют высоту и ширину элемента в слайдшоу. 

Кроме того, можно задать ориентацию переключения слайдов - вертикально или горизонтально. 

## SlideshowView — слайды по циклу [2]

Пример содержит в себе модель из 5 элементов. По умолчанию, переключение слайдов происходит горизонтально. 

## SilicaWebView — веб-страница [1]

Для отображения веб-страниц используется контейнер SilicaWebView.

SilicaWebView обладает свойством url, где указывается адрес веб страницы, которая может быть загружена, или которая загружена при клике внутри страницы. Данное свойство может быть пустым, если страница загружается из HTML-кода, а не по адресу.

Свойства title, loading и loadProgress — только для чтения. Они позволяют узнать информацию о загружаемой странице (ее заголовок) и о процессе загрузки (загружается ли она и каков прогресс загрузки).

## SilicaWebView — веб-страница [2]

Код на слайде показывает простейший пример создания веб браузера.

На странице описан контейнер SilicaWebView, а внизу страницы расположен объект типа TextField для ввода веб-адреса.

По нажатию на клавишу “Enter” на виртуальной клавиатуре произойдет изменение свойства url у SilicaWebView и будет загружена новая страница.

## MenuItem и MenuLabel — элементы меню

Меню позволяют выбирать и запускать действие из списка параметров. 

В Silica есть три типа меню - вытягиваемые сверху и снизу страницы и контекстное меню, применительно к списку элементов.

Для начала познакомимся с содержимым меню. Пункты меню описываются с помощью типа MenuItem и обладают свойствами, позволяющими задать текст и шрифт пункта меню, его цвет, а также горизонтальное выравнивание текста. MenuItem также обладает сигналом onClicked, необходимым для обработки нажатия на пункт меню.

MenuLabel представляет собой статичный пункт меню, который просто отображает некоторый текст. Такие пункты используются, например, в качестве заголовка или разделителя между интерактивными пунктами меню. Свойствами этого типа можно задать текст метки для описания назначения данного элемента, цвет меню и вертикальный отступ от границ экрана. 

## PullDownMenu — верхнее меню

Вытягиваемые меню вызываются с помощью свайп жеста, поэтому их можно использовать только внутри контейнеров, которые данный жест позволяют, а именно SilicaFlickable, SilicaListView, SilicaGridView и SilicaWebView.

Меню же, в свою очередь, являются контейнерами для типов MenuItem и MenuLabel. 

Настроить данные меню можно с помощью свойств, задающих отступы, а также цвет их фона и подсветки. Обратите внимание, что индикаторы вытягиваемых меню отображаются с помощью подсвеченных полос сверху или снизу. Цвет полос зависит от подсветки меню.

Флаг quickSelect позволяет включить функцию быстрого выбора, работает в случае меню с одним пунктом. При значении true, при любой прокрутке меню будет выбран его единственный пункт автоматически. 

Метод close() закрывает меню вручную. 

Пункты меню определяются не в порядке их появления на экране при свайп жесте, а в порядке их присутствия в самом меню, сверху вниз. То есть и в вытягиваемом меню и сверху и снизу, первый пункт будет выше остальных, как указано в примере. В реальных приложениях не стоит использовать слишком много пунктов меню и тем более MenuLabel компонентов.

## PushUpMenu — нижнее меню

В случае с PushUpMenu также следует внимательно отнестись к контенту страницы, поскольку данное меню будет доступно только в том случае, когда пользователь прокрутит до конца содержимого, даже если это список со 100 и более элементами.

Интересной особенностью взаимодействия с меню в ОС Аврора является то, что выбрать какой-либо пункт меню можно двумя способами. Можно просто сделать свайп вниз, пока меню не появится полностью. Тогда оно останется на экране и можно будет просто выбрать нужный пункт меню. А можно потянуть вниз не до конца и тогда по мере появления меню его пункты будут подсвечиваться, как на скриншоте снизу.

## ListItem и ContextMenu — элемент списка с меню [1]

Тип ListItem позволяет управлять размерами делегата, задавая нормальную высоту. Высота элемента будет увеличиваться при открытии контекстного меню, но высота содержимого не изменится.

Флаг highlighted подсвечивает содержимое, когда контекстное меню открыто. Также можно установить вызов меню с помощью нажатия и удержания элемента списка.

remorseAction() создаёт элемент, который позволяет отменить разрушающее действие, например, удаление.

ContextMenu – тип, предоставляющий всплывающее контекстное меню.

Содержимое этого меню описывается так же, как и для вытягиваемых, с помощью компонентов MenuItem и MenuLabel. Чаще всего данный тип используется для реализации контекстного меню элементов списка.

Для этого у компонента ListItem, который используется для описания делегатов списка, есть специальное свойство menu.

## ListItem и ContextMenu — элемент списка с меню [2]

Давайте посмотрим простейший пример по добавлению контекстного меню к элементам списка. В свойстве menu мы описали контекстное меню и создали интерактивный пункт меню, который меняет стиль шрифта метки на жирный. 

После того, как пункт меню будет выбран, контекстное меню будет закрыто автоматически.

## Dialog — страница для подтверждения

Диалоги широко используются приложениями для взаимодействия с пользователем.

По сути, Диалог - это обычная страница, в которой добавлена возможность подтверждать или отменять свои действия. В частности, они используются для ввода пользователем данных. Отличительной чертой диалогов является наличие кнопок “Отменить” и “Подтвердить” в шапке экрана. Вдобавок, диалоги обладают сигналами, которые вызываются при нажатии на эти кнопки.

Свойсто canAccept определяет, когда пользователь может подтвердить действия на странице, например при кооректном вводе всех данных анкеты. Если это свойство принимает значение false, кнопка принятия диалога не подсвечивается и не реагирует на нажатия.

Статус закрытия диалога передается в свойство result.

Метод open() используется для открытия диалога. По умолчанию он отобразит диалог поверх текущей страницы с анимацией перехода. Если первому параметру установить значение true, то диалог заменит текущую отображаемую страницу. Если второму параметру установить значение true, то диалог откроется без анимации.

Методы accept() и reject() инициируют подтверждение и отмену соответственно. Также они закрывают диалог. 
Метод close() закрывает диалог.

Действия пользователя испускают соответствующие сигналы. Обработчик onOpened() будет вызван при открытии диалога, его можно использовать при передаче начальных значений в диалог. 
onAccepted() и onRejected() будут вызваны при подтверждении и отмене пользователем диалога.
Сигнал onDone() полезен для разработчиков, будет перед закрытием диалога до вызова onAccepted() и onRejected().

## DialogHeader — заголовок диалога

Тип DialogHeader является необходимым элементом, если на экране диалога нужны кнопки принятия и отмены результата диалога. 

Заголовок диалога передается в свойстве title. Кроме этого в DialogHeader можно настроить текст кнопок с помощью свойств acceptText и cancelText. По умолчанию текст кнопок будет Cancel слева и Accept справа. Важно не забыть, что какой бы текст в  кнопке мы не указали, права кнопка всегда будет отвечать за принятие, а левая — за отмену.

С помощью extraContent в заголовок можно вставить дополнительный контекст.

## Пример диалога

Рассмотрим пример диалога, в котором пользователь задает заголовок. Обратите внимание, что на верхней панели указан текст только для кнопки подтверждения диалога. Если этот диалог является частью многостраничного приложения, нажатие левой кнопки все равно означает отмену диалога и извлечет его из стека страниц, вернув на предыдущую. 

## Вызов диалога со страницы

Для того, чтобы отобразить диалог, его необходимо поместить на стек, как обычную страницу. Вторым параметром передаётся объект со значениями свойств, которые необходимо проинициализировать в диалоге. Таким образом диалог в примере отобразится с уже заполненными полями. 

Диалог можно открывать по нажатию сенсорного элемента, например кнопки, как в данном примере. Здесь обработчику кнопки onClicked мы задаем переменную dialog, с помощью которой загружаем qml-файл с диалогом, а во втором аргументе передаем данные с текущей страницы, например свойству name типа Dialog мы присваиваем значение заголовка текущей страницы. 

Необходимо сохранить созданный экземпляр диалога для того, чтобы на него можно было устанавливать обработчики. В данном примере обработчик представляет собой функцию, которая подключается к сигналу accepted. Таким образом после принятия результата пользователем мы получаем данные из диалога, в нашем примере это значение заголовка страницы, с которой мы подключались к диалогу.

## Размеры элементов в Silica

Для создания приложения в едином стиле интерфейса ОС Аврора стоит не только использовать компоненты библиотеки Silica, но и устанавливать размеры элементов, шрифтов, отступов от границ, а также цвета в соответствии с общими рекомендациями.

Для этого предназначен компонент Theme. Он предоставляет информацию общего стиля для приложений и компонентов пользовательского интерфейса. Важно заметить, что это синглтон, к нему можно обращаться, но нельзя создать отдельный тип Theme.

Стандартные размеры элементов содержаться в свойствах, указанных на слайде. Размер элемента можно указать от очень маленького до гигантского. Не рекомендуется часто использовать как слишком маленькие, так и слишком большие размеры для элементов, содержащих текст. 

ExtraSmall - это размер стандартной кнопки, размер Small равен, например высоте стандартного элемента списка с одной строкой текста. Large размер используется в качестве высоты стандартного заголовка страницы, а размеры ExtraLarge и Huge подходят для элементов, содержащих изображения. 

## Размеры шрифтов в Silica

В приложениях для ОС Аврора стандартно используются два семейства шрифтов: одно для различных заголовков и одно для всех остальных надписей. Узнать нужное семейство шрифтов можно с помощью свойств fontFamilyHeading и fontFamily компонента Theme.

Аналогично размерам элементов можно присвоить стандартные значения размеру шрифтов. Для этого один из вариантов на слайде необходимо присвоить свойству font.pixelSize. 

Medium - стандартный размер шрифта, используемый в элементах ввода или вывода текста. Меньшие размеры предназанчены для второстепенной информации, например в описаниях элементов или метках. 

Большие размеры, в основном используются для заголовков, важных уведомлений или объявлений, к которым необходимо привлечь внимание. 

## Цвета в Silica

Помимо размеров при создании интерфейса можно использовать системные цвета. Это позволит стилизовать интерфейс приложения, а также заменять цвета в зависимости от смены атмосферы. Компонент Theme содержит несколько параметров, возвращающих стандартные цвета. 

Для текста и графических элементов используют primaryColor, чтобы подчеркнуть активные элементов и secondaryColor для менее значимых частей интерфейсов. 

Для того, чтобы выделить интерактивные элементы в нажатом состоянии используется highlightColor или более приглушенный secondaryHighlightColor. Активная подсветка фона достигается при значении highlightBackgroundColor, а highlightDimmerColor используется в случае, когда нужно подсветить элемент, но не отвлекать внимание от остальной части интерфейса. 

Настроить прозрачность выделяемого фона можно с помощью свойства rgba, в качестве аргументов выступают значения подсветки фона и значение прозрачности. 

С помощью colorScheme можно узнать цветовую схему. Её детали определяются текущей атмосферой ОС Аврора. Для цветовой схемы DarkOnLight текст и значки раскрашиваются темным цветом на светлом фоне. Для цветовой схемы LightOnDark содержимому подбирается светлые цвета на темном фоне.

## Отступы в Silica

Отступы являются важным аспектом разработки графического интерфейса приложений, особенно на мобильных платформах, где иногда возникают сложности с правильной компоновкой элементов. Слишком большой отступ между элементами отнимет ценное место на экране. Слишком маленький отступ, наоборот может привести к тому, что, пользователь может случайно нажать нежелательную кнопку, просто потому что она будет расположена слишком близко к нужной.

Компонент Theme предоставляет следующие параметры для получения размеров стандартных отступов:

- horizontalPageMargin — используется для установки расстояния между содержанием страницы и левым и правым краями экрана.

- paddingSmall — самое маленькое расстояние между элементами интерфейса. Часто используется в случаях, когда место на экране ограничено.

- paddingMedium — используется для установки расстояния между элементами интерфейса, которые связаны друг с другом по смыслу и поэтому визуально должны быть «вместе».

- paddingLarge — обычно используется для установки расстояния между элементами интерфейса.

## Иконки действий

Разберем более подробно иконки, которые используются в приложениях.

Аврора SDK включает в себя набор стилизованных иконок, которые можно использовать для создания цельного UI приложения. Эти иконки соответствуют определенным размерам— Small, Medium и Large.

## Размеры иконок

Иконки маленького размера не рекомендуется использовать как кликабельный элемент. Они используются в совокупности с текстом или в качестве индикации.

Theme.iconSizeExtraSmall — самый маленький размер, который используется, например, для значков в строке состояния;
Theme.iconSizeSmall — размер, который используется для маленьких значков, например, для значков CoverAction и значков на экране событий;
Theme.iconSizeSmallPlus — чуть больший вариант iconSizeSmall, который используется, например, для значков уведомлений;
Theme.iconSizeMedium — самый часто используемый размер (может быть применен, например, для значков внутри маленьких и средних элементов списка);
Theme.iconSizeLarge — большой размер, который используется, например, для значков на кнопках;
Theme.iconSizeExtraLarge — самый большой размер значков;
Theme.iconSizeLauncher — размер, который используется для значков в сетке приложений на домашнем экране.

## Масштабирование элементов

Размеры экранов устройств отличаются, поэтому необходимо масштабировать элементы интерфейса под конкретный размер текущего устройства.

Для масштабирования следует использовать элемент Theme.pixelRatio, который  хранит количество пикселей на экране устройства. В примере мы задали размер экрана с учетом свойства pixelRatio для корректного масштабирования.
В Silica для ОС Аврора 4 можно масштабировать элементы ещё и с помощью Theme.dp.

## Screen.sizeCategory — размеры экрана

Физические размеры экранов хранятся в свойстве SizeCategory типа Screen, размер Small используется для стандартного смартфона, а Large для стандартного планшета. 

В зависимости от размера экрана можно либо подобрать нужный размер элемента, как в примере мы выбираем размер шрифта для Label, либо загрузить нужную страницу, где элементы скомпонованы в подходящем порядке для конкретного размера экрана. 

## Palette — цветовая палитра

Тип Palette предоставляет значения для стандартных цветов.

Палитра обычно используется путём обращения к свойству palette у SilicaItem. Цвета по умолчанию соответствуют эквивалентным значениям из объекта Theme, но могут быть переопределены, если colorScheme или highlightColor палитры переопределяются. Любые производные цвета также будут переопределены.

## Модуль Silica Background

Настроить фон приложения и отдельных элементов можно с помощью модуля Silica Background.
Типы модуля Silica Background можно разделить на две большие категории:
Элементы Background, которые могут предоставить отдельные представления на большом общем полноэкранном фоне.
Элементы Wallpaper, которые предоставляют фоновое изображение, подходящее для прямого отображения или использования в качестве поставщика текстуры для другого элемента, такого как Background или ShaderEffect.

Модуль находится в стадии разработки и может быть изменён.

## Background

Все элементы Background расширяют тип Background, который использует экземпляр Material для рисования фона в пространстве экрана. Это означает, что при перемещении элемента или изменении его размера область, в которой он нарисован, будет перемещаться относительно экрана, а содержимое — нет.

Содержимое фона определяется свойством material, необязательными свойствами sourceItem и patternItem, и также дополнительными свойствами объекта QML, которые могут быть прочитаны шейдерами GLSL материалов.

Свойство fillMode определяет, каким образом элемент источника фона должен быть масштабирован для заполнения экрана.
Background.Strech Исходный элемент не будет масштабироваться.
Background.PreserveAspectWidth Исходный элемент будет масштабирован так, чтобы его ширина соответствовала ширине экрана. Это может привести к тому, что фон не будет отображаться в некоторых частях экрана, и его следует использовать только в портретной ориентации с исходными изображениями с таким же соотношением сторон или с высотой, большей, чем высота экрана.
Background.PreserveAspectSquare Наименьший размер sourceItem будет масштабирован по высоте экрана, чтобы экран был заполнен в обеих ориентациях.
Значение по умолчанию: Background.PreserveAspectSquare.

## Стандартные варианты фона

Тип ColorBackground предоставляет элемент фона, который отображает простой материал с цветом. color задаёт цвет фона.
Тип ThemeBackground предоставляет элемент фона, который отображается с использованием материала темы.
backgroundMaterial - это название фонового материала темы, используемого для отображения обоев и шаблона. По умолчанию оно соответствует текущему материалу системной темы.
Единственный текущий поддерживаемый материал - glass.
color - это накладываемый цвет, отображаемый как часть фона. Точное использование будет зависеть от выбранного материала фона.
Цвет по умолчанию будет получен из палитры фона и его цветовой схемы.
highlightColor - это цвет подсветки, который может быть включен в внешний вид фона.

## Material — материал шейдера

Материал предоставляет средства определения вершинного и фрагментного шейдера и комбинации входных переменных, которые могут эффективно использоваться несколькими фоновыми Background. Чтобы использовать Material, необходимо его назначить свойству material компонента Background.

Свойства vertexShader и fragmentShader позволяют использовать почти стандартные программы шейдеров GLSL для визуализации содержимого элемента Background. Они нестандартны в том смысле, что просят определить функцию backgroundMain() вместо main(). Оба шейдера имеют некоторые атрибуты, которые, как ожидается, будут определены в программах шейдера для передачи данных из элемента Background.

В фрагментном шейдере материала могут быть определены два специальных атрибута uniform, которые соответствуют данным текстуры свойств sourceItem и patternItem элемента Background. Это атрибуты sourceTexture и patternTexture.

Значения любых свойств QML в определении Background или Material будут использоваться для заполнения совместимого uniform в вершинном шейдере.

Кроме того, вершинный шейдер по умолчанию, если он используется, создаёт два различных атрибута, определяющих координаты текстуры для сэмплирования этих текстур: sourceCoord и patternCoord.

Фрагментный шейдер по умолчанию, который накладывает бледный объект patternItem на sourceItem, приведён в примере на слайде.

Следует обратить внимание, что если исходные элементы или элементы шаблона не используются материалом, можно безопасно опустить соответствующие атрибуты.

## Типы материалов

В модуле Background определены несколько типов материалов.
Синглтон Materials предоставляет набор стандартных разделяемых материалов Background.
BlurMaterial предоставляет материал, который показывает изображение и накладывает цвет.
GlassMaterial предоставляет материал, который отображает фоновый рисунок, узор и наложенный цвет в стиле стеклянной темы.

## Типы Wallpaper

Элементы Wallpaper — это поставщики текстур, которые обычно расширяют или Image, или FilteredImage и чаще всего используются в качестве sourceItem для Background, но также могут отображаться напрямую.

Элементы Wallpaper могут быть:
* простыми изображениями;
* изображениями, обработанными с использованием предоставленной темы или настраиваемого конвейера фильтрации;
* сценами QML, обработанными конвейером фильтрации изображений.

Тип FilteredImage позволяет применить серию эффектов фильтрации к исходному изображению или элементу поставщика текстуры для создания отфильтрованного изображения, которое затем может быть отображено или использовано в качестве поставщика текстуры для другого элемента.

filters - это список фильтров, применяемых к исходному изображению или элементу поставщика текстуры.
sourceItem - это элемент, который будет использоваться в качестве источника для отфильтрованного изображения. Если установлены и это свойство, и свойство source у Image, это свойство будет иметь приоритет.

Тип ImageWallpaper предоставляет квадратное обрезанное изображение, подходящее для использования в качестве обоев приложения.

Тип ThemeWallpaper предоставляет изображение обоев, к которому применен фильтр темы.
explicitFilters - это список фильтров, используемых вместо системного.
Следует использовать это свойство вместо привязки к свойству filters, так как привязка к свойству со списком в QML изменит элементы в списке вместо замены существующих элементов.

wallpaperFilter - название фильтра для обоев темы для применения к фоновому изображению. По умолчанию оно соответствует текущему фильтру системной темы.
Единственный текущий поддерживаемый фильтр - glassBlur.

Тип ThemeImageWallpaper предоставляет квадратное обрезанное и обработанное фильтром темы изображение, подходящее для использования в качестве обоев приложения.
imageUrl - это URL-адрес источника изображения обоев.

## Фильтры для FilteredImage

Синглтон Filters предоставляет набор стандартных разделяемых фильтров обоев.
ConvolutionFilter применяет ядро свёртки к FilteredImage. Фильтр свёртки обычно используется для применения эффекта размытия к изображению, хотя точный эффект будет зависеть от набора ядер.
Тип GlassBlur предоставляет фильтр, который размывает изображение для создания эффекта стеклянной темы.
RepeatFilter повторяет последовательность фильтров изображения фиксированное количество раз.
ResizeFilter изменяет размер вывода предыдущего шага фильтра (или источника ввода), поэтому все последующие фильтры применяются к изображению этого размера.
SequenceFilter собирает последовательность фильтров изображений в одно определение фильтра.
QML-тип ShaderFilter фильтрует изображение с помощью программы шейдера GLSL.

## Работа с вырезами

Системный вырез — это область на некоторых устройствах, которая обеспечивает место для камеры или датчиков на передней панели устройства.
В ОС Аврора доступны следующие варианты взаимодействия с механизмом системных вырезов:

* Выбрать режим отображения приложения. В этом случае все страницы приложения автоматически адаптируются под состояние устройства согласно с выбранным режимом.
* Напрямую получать значения безопасной зоны и компонентов, с которыми возможна коллизия. В этом случае приложение должно самостоятельно управлять корректным размещением своих компонентов на экране.

## safeZone — безопасная зона

По умолчанию страницы приложения располагаются в safeZone, прямоугольной области экрана, не содержащей коллизий. Это обеспечивает совместимость с приложениями, которые были написаны без учёта вырезов. Но при разработке нового приложения или адаптации существующего стоит учитывать, что приложение в safeZone может выглядеть не так естественно и красиво, как полноэкранные приложения.

ApplicationWindow также предоставляет свойство safeZone, содержащее обеъект типа Item , координаты и размеры которого совпадают с безопасной зоной отображения приложения. Его следует использовать для сценариев, когда необходимо работать с полным окном приложения.

## Выбор режима отображения

Настроить поведение можно с помощью свойства displayMode объекта типа ApplicationWindow . Различные режимы позволяют управлять видом отображения и размером окна приложения с учётом ориентации устройства:

ApplicationDisplayMode.FullPortrait
В портретном режиме страницы приложения занимают весь экран, в ландшафтном — с отступом на высоту выреза. Отступ закрашивается чёрным цветом.

ApplicationDisplayMode.FillScreen
Страницы приложения занимают весь экран.

ApplicationDisplayMode.SafeZone
Страницы приложения заполняют safeZone . Является режимом по умолчанию.

Для того, чтобы приложение, использующее API системных вырезов, могло функционировать и на устройствах, которые его не предоставляют, можно добавить проверки. Например, с помощью метода hasOwnProperty можно узнать, поддерживаются ли режимы отображения.

## Вырезы: SafeZoneRect.insets

При размещении элементов управления в полноэкранных приложениях требуется учитывать скоругления и вырезы экрана. Для этого служит объект SafeZoneRect.insets . Он предоставляет свойства top , left , right и bottom , которые содержат отступы от границ экрана до safeZone.

## Вырезы: SafeZoneRect.appinsets

Объект SafeZoneRect.appInsets аналогично SafeZoneRect.insets предоставляет свойства top , left , right и bottom , но их значения не зависят от ориентации устройства.

## Взаимодействие со строкой состояния

Строка состояния — это визуальный элемент, предназначенный для отображения наиболее необходимой системной информации и уведомлений. 
Высота строки состояния настраивается с помощью Theme . Его включение или отключение происходит через свойства ApplicationWindow.

ApplicationWindow предоставляет следующие свойства для управления строкой состояния:

statusbarForceVisible
Позволяет принудительно включить или отключить отображение строки состояния, если установлен displayMode FullPortrait или FillScreen . По умолчанию имеет значение false .
statusbarOpacity
Прозрачность фона строки состояния. по умолчанию имеет значение 0.0.
statusbarBackgroundColor
Цвет фона строки состояния. По умолчанию имеет цвет Theme.overlayBackground .
statusbarScheme
Определяет, какая цветовая схема выбрана для иконок строки состояния.
Пример настройки строки состояния приведён на слайде.

## Общие рекомендации

При разработке пользовательских интерфейсов следует придерживаться ряда рекомендаций для создания удобочитаемых и функциональных приложений. 

Мы выделили некоторые из них: 

- структура приложения должна быть простой для понимания и быстрой ориентации
- основная информация, которую важно указать, может выделяться позицией, цветом или размером 
- интерфейс пользователя желательно должен быть отзывчивым и использовать сенсорные элемента для взаимодействия
- для различных экранов используются различные макеты страниц
- для компонентов ввода следует указывать подсказки и описание назначения элемента
- и для страниц с объемным содержимым всегда указывать индикатор прокрутки. 

## Рекомендации для Silica

Кроме общих рекомендаций, также стоит выделить несколько моментов при работе с библиотекой Silica.

Обложки рекомендуется делать информативными, но не перегруженными элементами или иконками действий.

Для указания значений размеров, цветов, отступов следует пользоваться свойствами компонента Theme, на слайде указаны рекомендации для некоторых элементов. 

В вытягиваемых меню стоит указывать не более четырех опций для выбора, в противном случае такое меню займет больше половины экрана. 

Если вытягиваемое меню не доступно, этого элемента не должно быть в коде. Напомним, что индикатор присутствия меню - это подсвеченная полоса сверху или снизу. 

Диалоги не должны содержать дополнительных кнопок для подтверждения или отмены действия пользователя. 

Поддержка навигации ввода осуществляется с помощью свойств placeholderText и label

Для работы с клавиатурой рекомендуется описать действия EnterKey.
