# Тесты по теме «Сигналы, слоты, свойства»

Copyright&nbsp;©&nbsp;2016–2023 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Multiple choice

Какие из данных определений свойств не являются корректными?

---

*	`property int count: 0`
*	`property var myObject`
*	**`property string title = "The title"`**

## Text

Какое ключевое слово используется для объявления свойства?

---

property

## Single choice

Как обозначается свойство, которое может быть связано с другим свойством?

---

*	`int`
*	**`alias`**
*	`list<int>`
*	`default`

## Single choice

Чем являются методы QML-компонента?

---

*	Свойствами
*	Параметрами
*	**Функциями «JavaScript»**
*	QML-объектами


## Single choice

Какой QML-компонент позволяет устанавливать обработчики событий для другого компонента по id?

---

*	`Text`
*	**`Connections`**
*	`Connection`
*	`Binding`

## Text

Напишите название обработчика сигнала для свойства color:

---

onColorChanged

## Matching

Сопоставьте компоненты и их назначение

---

|                       |                                                      |
|-----------------------|------------------------------------------------------|
| `MultiPointTouchArea` | Отслеживание нескольких точек касания                |
| `MouseArea`           | Отслеживание событий мыши                            |
| `DropArea`            | Отслеживание событий перетаскивания других элементов |
| `PinchArea`           | Обработка двухпальцевых жестов                       |

## Single choice

Что означает значение `true` свойства `pinch.active` у `PinchArea`?

---

*	Компонент `PinchArea` активен
*	**Целевой элемент в текущий момент перетаскивается**

## Single choice

Можно ли ограничить жест стягивания по осям?

---

*	**Да**
*	Нет

## Multiple choice

Что НЕ может генерировать событие перетаскивания?

---

*	Перетаскивание элемента мышью
*	Событие касания
*	Событие анимации
*	Событие привязки
*	Событие отрисовки компонента
*	**Всё перечисленное потенциально может повлечь за собой событие перетаскивания**

## Text

С помощью какого свойства можно фильтровать события перетаскивания у DropArea?

---

keys

## Single choice

Что произойдёт, если во время операции перетаскивания изменить свойство Drag.imageSource?

---

*	**Эффекта не будет**
*	Изменится анимация перетаскивания
*	Изменится результат перетаскивания

## Single choice

Перекрывает ли активный компонент MultiPointTouchArea другие сенсорные области?

---

*	**Да**
*	Нет

## Single choice

Как можно ограничить количество отслеживаемых MultiPointTouchArea точек касания?

---

*	**Задать диапазон через свойства maximumTouchPoints и minimumTouchPoints**
*	Задать число отслеживаемых точек касания через свойство touchPoints

## Single choice

Когда испускается сигнал updated?

---

*	При изменении обрабатываемых точек касания
*	**При изменении текущих точек касания**

## Multiple choice

Какой компонент содержит координаты курсора?

---

*	**MouseArea**
*	**MouseEvent**

## Text

Какой сигнал MouseArea сообщает о событии долгого нажатия (без отпускания)?

---

pressAndHold
