# Операционные системы и подходы к разработке

Copyright&nbsp;©&nbsp;2016–2023 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

Начнём наш курс со знакомства с операционной системой.

## Мобильное устройство для пользователя

Мобильные устройства — ряд устройств, который включает в себя смартфоны, планшеты, электронные
книги, телефоны, КПК и нетбуки, главной особенностью которых является размер, а также количество
выполняемых ими функций.
Смартфоны — устройства, важной особенностью которых является размер и способность
к транспортированию, а также большой ряд функциональных возможностей.

*	Связь: телефон, сообщения.
*	Мультимедиа.
*	Дата / время: часы, будильники, напоминания, календарь.
*	Персональный цифровой помощник.
*	Игры.

Основной недостаток мобильных устройств — необходимость постоянного следить за уровнем заряда
и мощностью сигнала связи.

## Мобильная ОС для пользователя

Работоспособность мобильного устройства обеспечивает программное обеспечение, которое управляет
устройством, т.е. операционная система.

Сегодня основными мобильными операционными системами являются:

*	Android.
	Данная операционная система по праву считается самой популярной в мире среди аналогичных
	продуктов для различных устройств.
	Согласно официальной статистике, почти 85 процентов всех мировых телефонов, планшетов
	и смартфонов работают именно на Android.
*	IOS.
	Фирменная разработка компании Apple, которая работает только на устройствах,
	производимых этой же корпорацией.
	Пользовательский интерфейс iOS основан на концепции прямого взаимодействия с использованием
	жестов «мультитач».
	Элементы управления интерфейсом состоят из ползунков, переключателей и кнопок.
	Впервые операционная система была представлена в 2007 году.

ОС, которая будет изучаться в этом курсе, — Аврора, разрабатываемая компанией
"Открытая мобильная платформа".

*	Ориентированный на жесты UX, полная многозадачность.
*	Уважение к конфиденциальности данных.
*	B2B и B2G, функции MDM и российские ГОСТы.

У каждой операционной системы имеется сообщество разработчиков под эту ОС, откуда можно почерпнуть
немало практической информации.

## Мобильное устройство для разработчика

Разработчики мобильных приложений должны учитывать информацию о следующих особенностях ОС.

*	Технические характеристики устройств, на которых приложение будет запускаться.
	В частности, нередко приходится следить за потреблением энергии и/или доступными сетями,
	чтобы обеспечить корректную работу с данными и другие функции приложения.
*	Мультимедийные функции: аудио, видео: запись и вывод, радио.
*	Сетевые соединения: работа с удалёнными сервисами.
*	Доступные датчики: работа с системными датчиками устройства.

При создании приложения также необходимо определить целевую аудиторию, чтобы ориентировать своё
приложение именно на неё.
Для этого важно знать, какими бывают пользователи мобильных приложений, а также в чем заключаются
их интересы и потребности.

## Мобильная ОС для разработчика

Для разработки необходимо учитывать такие особенности платформ и мобильных приложений:

*	Архитектура целевых устройств.
*	UI / UX.
	У каждой мобильной платформы имеются рекомендации к интерфейсу, которые следует соблюдать,
	чтобы упростить использование своего приложения.
*	API. Он является открытым, в большинстве случаев хорошо документированным.
*	Инструменты разработки: среда, эмуляторы устройств.
*	Оформление документации своего приложения.
*	Инструменты публикации приложения.

Хорошим источником информации является сообщество разработчиков.

Android

*	Ядро Linux
*	Java байт-код в виртуальной машине, собственный API
*	Инфраструктура Google

iOS

*	Гибридное ядро XNU
*	POSIX-совместимые компоненты Darwin
*	Инфраструктура Apple

ОС Аврора

*	Полнофункциональный Linux
*	POSIX-совместимое пользовательское пространство
*	Независимая портативная инфраструктура

## Технологии разработки

Часто используемые средства разработки:

*	Android: Android Studio (языки Java, C/C++, Kotlin).
*	iOS: Xcode (языки Objective-C, Swift).
*	ОС Аврора: Аврора SDK (языки C/C++, QML, Python).

Также имеется несколько кроссплатформенных технологий, которые позволяют создавать приложения,
не привязываясь к конкретной ОС или адаптируя для ОС только часть приложения, например, внешний вид.

## Кроссплатформенные технологии

На слайде перечислены рразличные кроссплатформенные технологии.

*	WEB-технологии (JavaScript, HTML 5, CSS).
*	React Native.
*	jQuery Mobile.
*	PhoneGap.
*	Bootstrap.
	*	Общие WEB-технологии, низкий порог входа, быстрое развитие.
	*	Низкая производительность, некоторые ограничения API.
*	Xamarin (C#).
	*	Общие технологии .NET.
	*	Моно как еще одна виртуальная машина.
*	Qt (C++, QML, JavaScript) — изучается в нашем курсе.
	*	Эффективные собственные приложения с декларативным интерфейсом.

## ОС Аврора

ОС Аврора — это операционная система, предназначенная для смартфонов и планшетов, она основана
на Linux, это POSIX-овместимая ОС, сейчас поддерживаются 2 наиболее распространенные
архитектуры — arm и x86.

Операционная система была разработана таким образом, чтобы предоставлять удобную многозадачность
и это реализовано с помощью интерфейса пользователя который ориентирован под управление жестами,
сейчас эту тенденцию перенимают также Android и iOS.

Встроенная система защиты информации шифрует данные, которые отправляет и принимает пользователь.

Смартфоны и планшеты на ОС Аврора управляются через единый центр.
С его помощью можно настраивать корпоративные политики управления.

Также в ОС Аврора имеется сервис уведомлений.
Он предназначен для оперативной доставки информации в виде текстовых Push-сообщений на устройства.

## UI/UX ОС Аврора

Особенности пользовательского интерфейса ОС Аврора.

*	Управление жестами - приложения управляются с помощью набора жестов.
*	Автоматическая адаптация под светлую/тёмную тему и другие, определеямые атмосферами.
	Цветовая схема определяется текущей атмосферой ОС Аврора.
	Для светлой схемы Light (DarkOnLight) будут определены тёмный цвет шрифта и значков и светлый фон,
	для тёмной схемы Dark (LightOnDark) — светлые цвета содержимого и тёмный фон.
*	Персонализация внешнего вида приложений.
*	Адаптивные приложения для смартфонов и планшетов.
*	Быстрые действия с экрана задач.
*	Высокая скорость работы интерфейса.
*	Функциональные системные уведомления.

## История ОС Аврора

История ОС Аврора берет начало в нулевых годах.
С 2007 года компания Nokia занималась развитием ОС.
Помимо довольно популярной тогда ОС Symbian, Nokia также работала над Linux-системой для мобильных
устройств, которая называлась Maemo.
Примерно в то же время компания Intel развивала свою операционную систему Moblin.

В результате объединения  проектов в 2010 году появился проект MeeGo — разработка операционной
системы, которая могла бы охватить разные типы устройств, от десктопных до мобильных.
Параллельно с этим под управлением open-source сообщества развивался проект Mer.
Он предоставлял основу для построения операционных систем, большой фреймворк включающий ряд
библиотек, в том числе  Qt.

В 2011 году мобильное подразделение Nokia перешло под управление Microsoft, однако некоторые
сотрудники были заинтересованы в том, чтобы продолжить работу с Linux-системами и основали стартап
Jolla в Финляндии.
Сотрудники Jolla начали работу над своей операционной системой, вобравшей в себя многие наработки
проектов Maemo и Meego.
Новая система получила название Sailfish OS и была представлена в 2012 году.

В 2016 году в россии была основана компания Открытая мобильная платформа, которая стала партнером
Jolla по работе над Sailfish OS.
Был сформирован отдельный продукт Sailfish Mobile OS RUS, нацеленный на корпоративный рынок
и госкомпании России.
А в 2019 году операционная система получила название ОС Аврора.
Компания "Открытая мобильная платформа" стала полноправным владельцем исходного кода операционной
системы, а также обеспечила полный цикл разработки в РФ.

## Особенности ОС Аврора

Таким образом, ОС Аврора обладает рядом исторических особенностей.

В ее основе лежит полноценная Linux-система, и в режиме разработчика доступны все привычные утилиты.
Полная многозадачность по принципу десктопных систем позволяет пользователю запускать несколько
приложений и управлять ими в свернутом виде.

Для распространения приложений используется система пакетов rpm.
Пакеты подписываются и проверяются на соответствие требованиям ОС Аврора.

И с устройством, и с SDK можно взаимодействовать в режиме разработчика: через терминал,
в частности, с помощью ssh и другие команды bash.

Основные библиотеки для создания прикладного ПО представлены фреймворком Qt — удобным
как для создания интерфейсов, так и для доступа к различным API.
Графические интерфейсы приложений можно разрабатывать с помощью QML.

Приложения взаимодействуют между собой через интерфейсы D-Bus.

IDE для разработки основана на Qt Creator и во многом обладает его интерфейсом.

## Корпоративная мобильность с платформой Аврора

Одна из задач компании Открытая мобильная платформа состоит в том, чтобы предложить заказчикам
возможность создавать собственную инфраструктуру для управления парком мобильных устройств.

Важно уметь отслеживать статусы устройств, управлять набором доступных приложений
и обновлениями ОС, а также иметь возможность заблокировать устройство, например, в случае утери,
и безопасно удалить данные.

Это возможно благодаря сопутствующему продукту Аврора-центр — платформе управления мобильными
устройствами.
Она разворачивается на сервере и  предоставляет набор функций для управления устройствами, которыми
пользуются сотрудники, набором приложений и обновлениями ОС.

Система уведомлений Аврора предназначена для доставки push-сообщений на смартфоны и планшеты
под управлением мобильной ОС Аврора.
Для отправки безопасных push-сообщений на устройство организован push-сервер.

ОС Аврора внесена в реестр отечественного ПО, зарегистрирована в Роспатенте и обладет рядом
сертификатов ФСБ и ФСТЭК на соответствие требованиям профиля защиты операционных систем.
Также для защиты данных на ОС АВрора можно использовать сертифицированные VPN каналы.

## Устройства на ОС Аврора

ОС Аврора устанавливается на смартфоны и планшеты.

Продажа мобильных устройств осуществляется только корпоративным и государственным заказчикам.

Актуальный список устройств представлен на сайте auroraos.ru.

## Архитектура ОС Аврора

Архитектура операционной системы состоит из трех уровней.

На базовом уровне находятся ядро линукс, аппаратно зависимые компоненты и прошивка.
Уровень связующего ПО предназначен, как правило, для фреймворков.
В данном случае он включает в себя mer, который содержит цель для сборки кода и запуска ОС Аврора
и qml-приложений.
Цель  — это набор библиотек, заголовков для конкретной версии или архитектуры процессора.

Фреймворк Qt предоставляет основные библиотеки для разработки прикладного ПО.
Используется в качестве основной среды разработки приложений и предоставляет API для частого
использования других функций устройства.

Верхний уровень предназначен для приложений и графического интерфейса.

Основной домашний экран и область пользовательского интерфейса приложения управляются подсистемой
Lipstick, которая обрабатывает:

*	домашний экран и панель запуска приложений;
*	навигацию с помощью жестов в основном системном интерфейсе;
*	композицию приложений;
*	окна и уведомления на системном уровне и на уровне пользовательского пространства;
*	блокировку устройства;
*	и изменение внешнего вида интерфейса

ОС Аврора включает в себя большое количество связующих библиотек и фреймворков, многие из которых
используются приложениями.
Такие библиотеки и фреймворки написаны на языках C и C++.
Библиотеки, которые используются непосредственно в UI, включают в себя модули QML.
Это позволяет приложениям использовать их без дополнительных биндингов. 

Системные библиотеки включают в себя функции управления системой и устройством, в том числе:

*	обновление системы;
*	контроль устройств и обработка событий (например, событий, связанных с USB, зарядным
	устройством, разъемом для подключения наушников и тд);
*	управление режимом электропитания.

В ОС Аврора используется менеджер системы и сервисов systemd.
Данный подход сильно отличается от типичных скриптов инициализации SysV, но также является более
подходящим для мобильных систем в связи с запуском демонов по запросу.

Также используется дополнительный демон sensord, позволяющий записывать данные с датчиков
в циклические базы данных  для последующей визуализации.

Компоненты, организующие интерфейс пользователя находятся в составе бибилиотеки Silica.

## Аврора SDK

Аврора SDK — это набор инструментов разработчика для создания прикладного ПО.
IDE основана на Qt Creator.
Среда сборки распространяется внутри Virtual Box, что позволяет использовать одни и те же утилиты
независимо от хостовой ОС.
Начиная с версии 4, вместо Virtual Box можно использовать Docker.
Эмулятор поставляется с образом ОС. 

В IDE для разработки можно подключить внешние устройства, чтобы проверять работу приложения
на реальном смартфоне или планшете.
Установочные пакеты в IDE можно и нужно подписывать и валидировать.
Эти действия можно задать на этапе сборки прложения, а также использовать для них плагины.

Кроме того, в IDE интегрированы документация и примеры.

## Унификация сертифицированной и корпоративной версий ОС

В конце 2021 года вышла новая версия российской мобильной операционной системы Аврора 4.0,
существенно усовершенствованная по сравнению с предыдущей версией 3.2.3.

По сравнению с предыдущей версией ОС Аврора 4.0 гораздо более безопасна.
В частности, были унифицированы политики безопасности для двух вариантов исполнения — корпоративной
и сертифицированной версии ОС, в каждой из которых стали доступны основные механизмы безопасности:
подпись пакетов, валидация приложений, подпись модулей ядра, контроль целостности, шифрование
пользовательских данных, изоляция приложений.
В третьей версии были проблемы адаптации приложений с корпоративной версии на сертифицированную,
поскольку разработчики не учитывали ограничения сертифицированной.
Теперь можно гарантировать, что все приложения, написанные для ОС Аврора, могут использоваться
в проектах и с корпоративной, и с серифицированной версией.
Более того, Аврора-приложения могут устанавливаться на оба варианта исполнения ОС
без дополнительной пересборки в другой версии SDK.

На устройствах ОС Аврора 4 введён многопользовательский режим с поддержкой до 6 пользователей
и администратора.
Администратор обладает дополнительными привилегиями, в частности, может управлять аккаунтами
других пользователей, настраивать политики безопасности и т. п.
Данные всех пользователей полностью независимы друг от друга, так что на одном устройстве можно
организовать посменный режим работы с новыми настройками рабочего окружения для каждого пользователя.
Данные каждого пользователя полностью защищены от других, шифрование данных осуществляется прозрачно
для приложений: монтирование директории происходит при авторизации пользователя.
