# Инструменты разработки

Copyright&nbsp;©&nbsp;2016–2023 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Qt Creator

Qt Creator — кроссплатформенная среда разработки, используемая при работе с фреймворком Qt.
Данная IDE включает в себя все компоненты, присущие любой интегрированной среде разработки:
редактор кода, компилятор, отладчик.
Также поддерживает интеграцию с системами контроля версий: Mercurial, Git, Subversion, Bazaar, CVS.

## Режимы

Верхняя часть левой вертикальной панели содержит переключатель режимов Qt Creator.

## Начальный экран

При запуске Qt Creator отображается начальный экран, где есть возможность перейти к одному
из последних проектов, над которыми работали.
Здесь есть возможность открыть уже существующий проект или создать новый.
Слева находится колонка с такими пунктами как “Проекты”, “Примеры” и “Учебники”.
На слайде изображен раздел “Проекты”. “Примеры” и “Учебники” позволяет открыть учебные проекты,
предоставляемые самим SDK.

## Создание нового проекта

При создании нового проекта открывается диалоговое окно и предлагает выбрать шаблон для проекта.
Здесь мы видим 5 разделов.
Раздел “Application” позволяет выбрать шаблон для самого приложения (в нашем случае это приложение ОС Аврора).
Раздел “Библиотека” предлагает шаблоны для создания Qt-библиотеки (модуля для расширения
Qt-приложений, либо модуля для расширения самого Qt Creator).
Раздел “Other Project” позволяет создать абсолютно пустое приложение без автоматического
генерирования некоторых классов, необходимых по-умолчанию.
“Non-Qt Project” предлагает нам шаблоны для создания приложений, не использующих фреймворк Qt.
Это консольные C и C++ приложения.
А раздел “Import Project” позволяет перейти к импорту приложения с помощью одной из поддерживаемых
систем контроля версий: Mercurial, Git, Subversion, Bazaar, CVS.
Выберем “Application” -> “Приложение Qt Quick для ОС Аврора” и нажмем “Выбрать...”.

## Интерфейс редактора

Интерфейс рабочего окна Qt Creator поделен на несколько блоков.
Верхняя часть левой вертикальной панели содержит ряд из семи кнопок, позволяющих переключить
режим использования Qt Creator.
Нижняя часть левой вертикальной панели включает в себя элемент для выбора комплекта инструментов,
ниже располагаются кнопки запуска, отладки и сборки проекта, а также кнопки запуска Mer SDK и эмулятора.
Основную часть окна занимает встроенный редактор кода.
В боковой панели могут быть открыты несколько навигаторов (по умолчанию два: один – для навигации
по файлам проекта, второй – по уже открытым файлам).
В нижней части окна могут быть открыты (или изображаться в свернутом состоянии) дополнительные
панели: “Проблемы”, “Результаты поиска”, “Вывод приложения”, “Консоль сборки”, “Консоль QML/JS”.

## Режим отладки

Режим отладки похож на режим редактора.
В этом режиме лишь добавляются несколько панелей для анализа текущей работы кода.
На панели справа посмотреть текущие значения переменных, содержимое объектов и свойств
во время выполнения приложения.
Снизу же две панели:

*	левая показывает место в коде (имя функции, файла, номер строки), где в данный момент остановлено приложение;
*	правая показывает все установленные точки останова.

## Режим «Проекты»

Режим «Проекты» позволяет настраивать этапы очистки, сборки и запуска приложения.
Также здесь можно добавить комплекты для сборки приложения, если какой-нибудь из них
не был выбран на этапе создания проекта.
Это может быть необходимо в ситуации, когда помимо работы с эмулятором, требуется тестировать
приложение и на реальном устройстве.
Или наоборот.

## Слайд

Режим справки предоставляет доступ к обширной оффлайн документации по Qt и его библиотекам.
Здесь можно найти информацию по любому модулю фреймворка, QML компоненту или Qt-классу.
Также справку можно открывать не отрываясь от работы над кодом следующим образом.
Установить курсор на класс или компонент, для которого хотим получить справку.
Нажать “F1”. И справа от редактора кода появится панель, отображающая справку для выбранного
компонента или класса.

## Состав Аврора SDK

Аврора SDK основана на Qt Creator. Qt Creator — кроссплатформенная среда разработки, используемая
при работе с фреймворком Qt.
Эта IDE включает в себя все компоненты, присущие любой интегрированной среде разработки:
редактор кода, компилятор, отладчик.
Также она поддерживает интеграцию с системами контроля версий, валидацию и подпись пакетов.

Помимо IDE, в состав SDK входят:

*	Aurora OS Emulator (эмулятор) — виртуальная машина, которая позволяет выполнять приложения
	в окружении ОС Аврора аналогично работе на реальном устройстве.
*	Aurora OS Build Engine (среда сборки) — окружение, поставляемое как виртуальная машина
	или Docker-контейнер, которое обеспечивает среду для сборки приложений,
	не зависящую от домашней операционной системы.
*	Документация по архитектуре и API.
*	Примеры и шаблоны приложений.

Система сборки и эмулятор поставляются в виде образов виртуальных машин для VirtualBox.
Однако, сам VirtualBox в состав SDK не входит.
Поэтому перед установкой SDK, необходимо сначала установить VirtualBox версии не ниже чем 4.1.18.
Альтернативно, начиная с версии ОС Аврора 4, можно использовать Docker.
Аврора SDK доступен для Linux, Windows и macOS.
SDK поставляется в виде графического инсталлятора, поэтому установка не должна вызывать трудностей.

## Режимы IDE

При запуске Аврора IDE отображается начальный экран, где есть возможность перейти к одному
из последних проектов, над которыми вы работали.
Здесь есть возможность открыть уже существующий проект или создать новый.
Слева в IDE находится колонка с такими пунктами как Редактор, Проекты, Отладка и Справка.

В режиме редактора основную часть окна занимает встроенный редактор кода.

Режим отладки похож на режим редактора. В этом режиме лишь добавляются несколько панелей
для анализа текущей работы кода.

Режим «Проекты» позволяет настраивать этапы очистки, сборки и запуска приложения.
Также здесь можно добавить комплекты для сборки приложения, если какой-нибудь из них
не был выбран на этапе создания проекта.
Это может быть необходимо в ситуации, когда вы разрабатываете мобильное приложение и хотите
проверить его работу для устройств с разной архитектурой и версией ОС.

Режим справки предоставляет доступ к обширной оффлайн-документации.

## Начало работы с проектом

Создание или открытие проекта приложения.

*	Файлы проекта должны быть в директории, указанной при установке SDK, или в домашнем каталоге.
*	Приложение из базового шаблона.
*	Начало → Проекты → Новый проект.
*	Открытие существующего проекта Меню → Файл → Открыть файл или проект.

## Создание приложения

Для создания нового проекта из шаблона необходимо выполнить следующие действия:

1.	В основном окне Аврора IDE выбрать пункт меню «Файл» → «Создать файл или проект...».
2.	В открывшемся окне «Новый файл или проект» выбрать вкладку «Проекты» → «Приложение»
	и отметить «Приложение Qt Quick для ОС Аврора», после чего нажать кнопку «Выбрать...».
3.	В появившемся окне «Введение и размещение проекта» указать название вашей организации,
	имя проекта, директорию.
	Важно иметь в виду, что проект должен находиться или в домашней директории пользователя,
	или в альтернативной директории, указанной при установке Аврора SDK.
	Если отметить пункт «Размещение проекта по умолчанию», то указанная директория будет
	предлагаться для следующих создаваемых проектов.
4.	На следующих двух вкладках необходимо указать разрешения, которые необходимы вашему приложению.
	Это может быть доступ к директориям, к api для работы с данными и т.п.
5.	В качестве системы сборки можно оставить вариант по умолчанию — qmake.
6.	В открывшемся окне «Выбор комплекта» выбрать необходимые комплекты для сборки и нажать кнопку «Далее».
	Комплект arm7hl используется для мобильных устройств, i486 — для эмулятора.
	Позже набор комплектов можно изменить в настройках проекта.
7.	В следующем окне «Application Details» ввести необходимые данные о приложении и нажать кнопку «Далее».
8.	В появившемся окне «Управление проектом» выбрать необходимые данные и нажать кнопку «Завершить».
	Данное окно позволяет настроить взаимное положение проекта относительно других и подключить одну
	из систем контроля версий, доступных в операционной системе.
9.	В открывшемся редакторе исходного кода можно приступить к работе над проектом.

## Сборка проекта

Для сборки используется система Build Engine.
Доступны наборы для сборки под определённую архитектуру.
Для эмулятора возможно использовать только i486.
Типы сборки. Debug — для разработки, присутствет отладочный вывод и возможность
использовать отладчик.
Release — тип для сборки приложения, поставляющегося конечному пользователю.

## Запуск приложения

Перед установкой нужно указать, на какое устройство или эмулятор нужно устанавливать
собранный rpm-пакет.
Также на вкладке "Проекты" в разделе "Запуск" нужно настроить этап подписи:
указать ключ и сертификат.

Способы установки на устройство. Установить как RPM пакет — собирается RPM пакет,
содержащий скомпилированный исходный код и ресурсы, и устанавливается на устройство
с использованием RPM установщика.
Установить копированием — скомпилированный исходный код и ресурсы копируются на устройство.
Последний — самый быстрый метод.

После того, как выбраны все опции, можно запускать сборку.

## Директория проекта приложений

Структура проекта:

*	Файл .pro содержит описание структуры, подключаемые модули и другие конфигурационные настройки проекта.
*	Файл .pro.user — файл с локальными настройками. При распространении проекта его передавать не надо.
*	В каталоге src файлы с расширением .cpp содержит исходный код на C++, файлы
	.h — это заголовочные файлы на C++.
*	Файлы .qml в каталоге qml содержат исходный код на QML.
*	icons — иконки для значка приложения
*	rpm/<имя проекта>.spec — параметры сборки rpm-пакета
*	<имя проекта>.desktop — параметры запуска приложения
*	Файлы .ts в каталоге translations — это файлы переводов.

## Файл .desktop

В desktop-файле следует придерживаться следующей структуры.

Использование значения строки X-Nemo-Application-Type=silica-qt5 позволяет проверить,
что приложение использует модуль Silica, который позволяет ускорить запуск приложения.

В строке Icon следует указывать название пакета (оно же имя графического файла для значка).
В строке не требуется указывать абсолютный путь к файлу.

Строка Exec должна содержать команду для запуска.

Значение строки `Name` определяет название приложения на экране приложений ОС Аврора.
Значение не обязательно должно совпадать с названием пакета в установочном пакете и быть уникальным.
Таким образом, на экране приложений ОС Аврора может быть более одного приложения c одним названием.

Для локализации названия приложения используется конструкция Name[<двухбуквенный_код_языка>].
Например, Name[ru] позволяет задать название приложения для русскоязычного интерфейса.

## Управление правами приложения

Начиная с версии 4.0.1 в Аврора OS реализован механизм безопасного исполнения приложений
в песочнице (т.н. Изоляция).
Изоляция в Аврора OS основана на системе Firejail, которая, в свою очередь, основана на SUID,
Linux Namespaces и seccomp-bpf.
Система ограничений прав приложений применима только к приложениям, запускаемым в песочнице. 
В дальнейшем изоляция будет применяться ко всем запускаемым приложениям.
Права ("разрешения") необходимые для работы приложения указываются в видоизмененном .desktop-файле,
формат которого указан ниже.
Там же, в явном виде, указывается запуск приложения в секции X-Application.

Для запуска в песочнице Аврора OS приложение должно соответствовать определённым правилам,
которые сейчас будут разобраны.

## Секция X-Application

Рассмотрим требования к формату секции `[X-Application]` desktop-файла на примере.

| Параметр           | Описание                                                                       |
|--------------------|--------------------------------------------------------------------------------|
| `Permissions`      | Список идентификаторов требуемых прав со знаком "**;**" в качестве разделителя |
| `OrganizationName` | Название организации-разработчика                                              |
| `ApplicationName`  | Имя директории, выделенной для хранения данных приложения                      |

Разрешения предоставляют доступ к директориям, содержащим данные определённого типа,
интерфейсам D-Bus, определённым типам сокетов и приложений.
В настоящее время приложения должны определять все необходимые разрешения в desktop-файле,
и все они предоставляются в момент запуска.

## Доступные директории

Используйте правильные каталоги данных приложения

OrganizationName и ApplicationName используются для предоставления приложению прав
на запись в директории.

1.	$HOME/.local/share/\<Название организации\>/\<Имя приложения\>
2.	$HOME/.cache/\<Название организации\>/\<Имя приложения\>
3.	$HOME/.config/\<Название организации\>/\<Имя приложения\>

Для доступа к указанным выше каталогам из приложения используйте `Aurora::Application::Paths`.

1.	Данные приложения — Aurora::Application::Paths::writableLocation(Aurora::Application::Paths::AppDataLocation)
2.	Кеш приложения — Aurora::Application::Paths::writableLocation(Aurora::Application::Paths::CacheLocation)
3.	Конфигурация приложения — Aurora::Application::Paths::writableLocation(Aurora::Application::Paths::ConfigLocation)

Только эти каталоги могут использоваться для хранения данных приложения.

## Основной объект приложения Qt

Измените основной объект приложения Qt, установив организацию и имя приложения,
чтобы соответствовать объявлению, добавленному в файл рабочего стола.

## Разрешения для приложений [1]

Разрешения, необходимые для использования функциональности.

Функции мобильного устройства:

*	Технология Bluetooth: Bluetooth — Подключение и использование оборудования Bluetooth и NFC
*	Получение координат: Location — Использование GPS и определение местоположения
*	Технология NFC: NFC

Сеть:

*	Управление сетевыми подключениями: Internet — Передача данных и подключение к Интернету
*	Отображение WEB-контента: WebView
*	Передача данных: Internet

Мультимедиа:

*	Проигрывание и запись аудио и видео: Audio, Microphone.
*	Низкоуровневые функции работы аудио: Audio, Microphone.
*	Camera — Съемка фотографий и видео.
*	Audio — Воспроизведение звука, изменение конфигурации звука и отображение элементов
	управления звуком на экране блокировки.

## Разрешения для приложений [2]

Доступ к системным службам:

*	MediaIndexing — Получение списка файлов на устройстве.
	Если у вас есть доступ к каталогу данных, вы можете также использовать его.
*	PushNotifications — Push-уведомления.
*	SecureStorage — Безопасное хранение данных.

Помимо них, для профилей Extended, Antivirus и MDM также возможно использование разрешения
LogSecurityEvents (для записи в sdjd).

## Разрешения для приложений [3]

Для доступа к дополнительным директориям, которые могут быть доступны нескольким приложениям,
необходимо использовать следующие разрешения:

*	RemovableMedia
*	UserDirs
*	Documents — Доступ к директории документов
*	Downloads — Доступ к директории загрузок
*	Music — Доступ к директории Music, плейлистам и изображениям обложек
*	Pictures — Доступ к директории изображений и эскизам
*	PublicDir — Доступ к директории ~/Public
*	Videos — Доступ к директории видео и эскизам

UserDirs даёт доступ ко всем директориям, которые предоставляются при использовании следующих разрешений:
Documents, Downloads, Music, Pictures, PublicDir, Videos.

## Установочные пакеты

ПО для ОС Аврора распространяется в виде rpm-файлов.

RPM-файл содержит:

*	Исполнительный файл приложения
*	Иконки и desktop-файлы
*	Подключаемые библиотеки
*	Ресурсы
*	Зависимости
*	Скрипты установки и удаления
*	Подписи

## Сборка и запуск проекта

В pro-файле и spec-файле хранятся настройка конфигурации приложения.

Основные этапы сборки и запуска проекта:

1.	Сборка rpm на основе spec-файла.
2.	Подпись rpm-пакета.
3.	Валидация rpm-пакета.
	В том числе валидируется подпись.
4.	Установка rpm-пакета на устройство или эмулятор.

## Файл проекта для ОС Аврора

Инструмент qmake помогает упростить процесс сборки для проектов, разрабатываемых
для разных платформ.
Он автоматизирует генерацию Make-файлов, так что для создания каждого Makefile требуется всего
несколько строк информации.
Вы можете использовать qmake для любого программного проекта, независимо от того, написан ли
он на Qt или нет.

Часто используемые переменные:

*	TARGET — название исполняемого файла и директории;
*	CONFIG Общие параметры конфигурации проекта;
*	auroraapp — для Аврора ОС;
*	auroraapp_i18n — активация переводов;
*	TRANSLATIONS — файлы переводов;
*	DISTFILES — QML и другие файлы для проекта;
*	AURORAAPP_ICONS — разрешения иконок приложения.	

## Тип проекта и библиотеки

Переменная TEMPLATE используется для определения типа проекта, который будет построен.
Если это не объявлено в файле проекта, qmake предполагает, что должно быть создано приложение,
и будет генерировать соответствующий Makefile (или эквивалентный файл) для этой цели.

На слайде представлены типы доступных проектов и описаны файлы, которые qmake будет
генерировать для каждого из них:

*	app (default) Makefile для создания приложения;
*	lib Makefile для создания библиотеки;
*	aux Makefile, который не должен ничего строить.
	Используйте его, если компилятор не должен вызываться для создания цели, например,
	потому что ваш проект написан на интерпретируемом языке.
*	subdirs Makefile, содержащий правила для подкаталогов, заданных с помощью переменной SUBDIRS.
	Каждый подкаталог должен содержать свой собственный файл проекта.

Когда используется шаблон subdirs, qmake генерирует Makefile для изучения каждого указанного
подкаталога, обрабатывает любой файл проекта, который он там находит, и запускает инструмент
создания платформы на вновь созданный Makefile.
Переменная SUBDIRS используется для хранения списка всех подкаталогов, подлежащих обработке.

Если вы используете другие библиотеки в своем проекте, вам необходимо указать их в файле проекта.

Пути, которые qmake ищет для библиотек и специфических библиотек для сопоставления, могут быть
добавлены в список значений в переменной LIBS.
Вы можете указать пути к библиотекам или использовать нотацию в стиле Unix для указания
библиотек и путей.

Пути, содержащие заголовочные файлы, также могут быть указаны аналогичным образом
с помощью переменной INCLUDEPATH.

## Дополнительные возможности qmake

С помощью qmake вы можете использовать константы, например, специфичные для платформы.

Можно указать параметры сборки и дополнительные файлы для установки.

## Подписание установочных пакетов

Установочные пакеты приложений для ОС Аврора должны быть подписаны электронными подписями,
позволяющими идентифицировать разработчиков и избежать попадания на мобильные устройства
нежелательных приложений.

Для подписания пакета необходимы:

*	Закрытый ключ подписывающей стороны (`key.pem`).
*	Сертификат подписывающей стороны (`cert.pem`).

## Выпуск сертификата

Разработчики не могут использовать самостоятельно созданные сертификаты для подписания пакетов.
Чтобы получить сертификат, разработчик должен сначала сгенерировать CSR
(запрос на сертификат для подписания пакетов).
Генерация сертификата осуществляется с помощью утилиты OpenSSL.

Полученный файл запроса (но не файлы ключей) необходимо передать полномочному представителю
компании ООО «Открытая мобильная платформа», отправив письмом на dev-support@omp.ru.

Сгенерированный файл `cert.pem` будет отправлен разработчику.

## Публичные ключевые пары

Публичные ключевые пары будут сгенерированы для того, чтобы разработчики партнёров
могли их использовать для разработки и отладки.
Эти ключи не смогут работать в реальных устройствах, находящихся в эксплуатации,
т.к. они будут добавлены в чёрные списки.
Передаваемые партнёрам персональные ключи являются приватными и использовать их должны только
сотрудники, уполномоченные подписывать релизы приложений.

## Подпись приложений в IDE

Функция подписания приложения перед его установкой на устройство управляется
из Aurora IDE, для этого необходимо:

1.	Переключиться в режим «Проекты» и открыть настройки запуска необходимого комплекта для сборки.
2.	Выбрать метод запуска. Подписание пакетов приложения доступно только для следующих методов:

	*	Build RPM Package For Manual Deployment;
	*	Deploy As RPM Package.

3.	Включить подписание RPM-пакета нажатием кнопки "Включить"
4.	Раскрыть вкладку «RPM Sign» нажатием кнопки `Подробнее` и указать:

	*	путь и имя файла ключа;
	*	путь и имя файла сертификата.

## Программа-валидатор rpm-файлов

Валидатор проверяет установочные RPM-пакеты для ОС Аврора на соответствие требованиям.

Валидатор RPM-пакетов можно запустить в:

*	среде сборки
*	Aurora IDE

Валидатор также всегда вызывается во время установки пакетов
в ОС Аврора.

Указанный профиль безопасности должен соответствовать сертификату разработчика приложения.
Используемый профиль ограничивает список разрешенных зависимостей (библиотек, модулей Qt и QML),
допустимых путей для размещения файлов.
Предусмотрено 4 профиля безопасности, **Regular**, **Extended**, **MDM**	и **Antivirus**.
Extended, MDM и Antivirus являются расширениями Regular, для них предусмотрен расширенный
список разрешенных зависимостей.

## Валидатор в Аврора IDE

Валидатор RPM-пакетов также можно запускать после сборки и подписи пакета в Aurora IDE
для сертифицированной версии ОС:

1.	Переключиться в режим «Проекты» и открыть настройки запуска необходимого комплекта для сборки.
2.	Выбрать метод запуска.
3.	Удостовериться, что в этапах запуска есть «**RPM Validation**: Проверки RPM пакета».
	В противном случае добавить добавить этап в выпадающем меню «Установка, добавить этап» ниже
4.	Выбрать нужный профиль валидации в выпадающем списке «Profiles».
5.	В случае необходимости добавить ключи в поле «Аргументы».
6.	Запустить сборку и установку приложения.
	В консоли сборки будет отображён отладочный лог валидатора и результат.

## Проверяемые требования

Скрипт вполняет проверку пакета приложения на соответствие базовым требованиям:

*	Проверка имен пакетов
*	Проверка имени файла, пути и разрешений
*	Размер и формат иконок
*	Импорт QML, разделяемые библиотеки и зависимости RPM
*	Очень простой статический анализ возможных проблем с кодом

Успешная проверка означает, что пакет в порядке, однако она не гарантирует,
что пакет или приложение будут установлены.

Однако отказ в проверке означает, что пакет НЕ будет установлен, поэтому необходимо
исправить все ошибки проверки.

## Общие требования к rpm-пакетам

Общие требования

*	Файлы установочного пакета должны быть размещены в определённых директориях.
	В том числе при установке приложения файлы не должны создаваться в домашней
	директории пользователя.
*	Файлы не должны содержать абсолютные пути импорта модулей QML.
*	Установочный пакет не должен содержать файлы систем управления версиями.
*	Файлы и директории в установочном пакете должны оставаться под контролем менеджера пакетов RPM,
	им нельзя присвоить права доступа chmod 666 или chmod 777.
	Изменение или удаление файлов извне не имеет смысла,
	данные восстановятся после обновления или переустановки пакета.
*	В исполняемых файлах запрещено использовать флаги доступа
	**Set User/Group ID Upon Execution (suid/sgid)**,
	поскольку не допускается запуск приложения от пользователя root.
*	Размер файла установочного пакета не должен превышать 200 мегабайт.
	Это требование Аврора центр.
	Приложения с оффлайн картами вполне могут превышать этот размер.

## Установочный пакет и пути

Установочный пакет следует именовать следующим образом — 
<название_пакета>-<версия>-<релиз>.<архитектура>.rpm, где:

*	<название_пакета> — имя пакета,
	которое является основным именем для остальных файлов в установочном пакете.
*	<версия> указывается в .spec/.yaml файле для сборки приложения в строке Version.
*	<релиз> указывается в .spec/.yaml файле для сборки приложения в строке Release.
*	<архитектура> может быть armv7hl или i486.

Пути к файлам

Файлы должны быть размещены в следующих директориях RPM-пакета:

*	/usr/bin/<название_пакета> — исполняемый файл;
*	/usr/share/applications/<название_пакета>.desktop — файл в формате .desktop;
*	/usr/share/icons/hicolor/<размер>/apps/<название_пакета>.png — файлы значка приложения;
*	/usr/share/<название_пакета>/*	— прочие файлы
	(данные приложения, собственные разделяемые библиотеки, импорт собственных QML-файлов и т.д.).

## Имя приложения

*	В именах приложения и проекта не допускаются тире.
*	Рекомендуется для имён использовать нотацию CamelCase.
*	Имя приложения должно иметь формат <OrganizationName>.<ApplicationName>.

## Файл .spec

Версия установочного пакета указывается в строке Version в spec-файле.
Для указания версии следует придерживаться принципов семантического версионирования в формате
**X.Y** или **X.Y.Z**.

**Примечание**	— версия приложения для Аврора Маркет может состоять только из цифр,
разделенных точками.
Длина строки версии — от 1 до 20 символов.
Во время загрузки приложения в Аврора Маркет
версия нового релиза должна быть выше ранее загруженного релиза.
Увеличить номер версии можно с сохранением предыдущего формата релиза
или с добавлением минорной версии.

Релиз установочного пакета указывается в строке Release в .spec-файле.
В строке релиза допускается использовать только числа, символ точки и подчеркивания.

Зависимости для приложения указываются в строке Requires в .spec-файле.

## Данные, конфигурация и кэш

Файлы с данными можно устанавливать в /usr/share/<название_пакета>.
Если пользователю требуется отключить системные данные, то можно использовать флаг
в $XDG_*_HOME/<название_пакета>.
Отключение системных данных не освободит место, но в случае сокрытия или ошибки
при загрузке данных уменьшится время запуска и отзывчивость приложений.

Большой объем данных не рекомендуется размещать в RPM-пакете для установки
в /usr/share/<название_пакета> из-за ограниченных ресурсов целевых устройств.
RPM-пакет будет конкурировать за свободное дисковое пространство с другими приложениями
и может потерять возможность установиться или обновиться из-за нехватки свободного места.

В установочном пакете рекомендуется размещать только скомпилированный код приложения,
QML-файлы интерфейса пользовтеля, файлы значков, файлы переводов и сопутствующие системные файлы.

## Модули QML

Поставляемые в пакете модули QML рекомендуется называть с префиксом, соответствующим названию
пакета — например, MyAppName или MyAppName.ModuleName.

Собственные и сторонние модули QML, поставляемые в установочном пакете, следует размещать
в директории /usr/share/<название_пакета>/qml.

## Значок приложения

Изображения значка приложения должны быть в формате .png и называться в соответствии
с установочным пакетом (строка Icon в .desktop-файле).

С приложением должны поставляться изображения значка следующих размеров:

*	86 × 86;
*	108 × 108;
*	128 × 128;
*	172 × 172.

Изображения именно этих размеров требуются для отображения на различных устройствах
с разными размерами и разрешениями экрана.
Другие размеры не поддерживаются.

Рекомендуемая структура размещения файлов значка имеет следующий вид.

## Разделяемые библиотеки

Разрешенные для использования в приложении разделяемые библиотеки приведены в разделе
Допустимые зависимости приложений ОС Аврора.
Следует обратить внимание на библиотеки с пометкой **(deprecated)**, в текущих версиях ОС Аврора
их использование допускается, но соответствующие компоненты более не развиваются и станут
недоступными в одной из ближайших версий ОС.

Собственные и сторонние разделяемые библиотеки, поставляемые в установочном пакете,
следует размещать в директории /usr/share/<название_пакета>/lib.

## Использование модулей Qt

Модуль QtWidgets запрещен для использования, так как не оптимизирован для интерфейса пользователя
ОС Аврора (выполнение программного кода будет намного медленнее, чем рендеринг с использованием
Qt Quick и OpenGL ES).

Альтернатива использованию модуля QtOpenGL.

Модуль QtOpenGL также запрещен для использования (из-за обширных зависимостей от модуля QtWidgets),
вместо него рекомендуется использовать ряд классов допустимого модуля Qt GUI.
В большинстве случаев использование Qt GUI означает переименование классов
из QGL*	→ QOpenGL*	и удаление ссылки на QtOpenGL.
В некоторых случаях требуются изменения API, но они не должны быть слишком сложными.

D-Bus API доступны для использования, если к ним есть права доступа из приложения
без необходимости повышения привилегий.

Запрещено поставлять в RPM-пакете файлы в формате .service, активирующие шину D-Bus.

## Platform SDK

Aurora Platform SDK устанавливается в домашнюю директорию текущего пользователя.
Platform SDK рекомендуется использовать, когда нужно разрабатывать проект для ОС Аврора,
а IDE, основанная на QtCreator, при этом не нужна.
Преимущества такого подхода:

*	можно собирать проекты из рабочего пространства Aurora Application SDK;
*	нет необходимости настраивать профиль Git для работы;
*	нет проблем, связанных с правами доступа к файлам проектов.
