// SPDX-FileCopyrightText: 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import QtQuick 2.6
import Sailfish.Silica 1.0

Page {
    id: page

    PageHeader { title: qsTr("Switches") }
    Column {
        anchors.centerIn: parent
        spacing: Theme.paddingLarge

        Switch {
            anchors.horizontalCenter: parent.horizontalCenter
            icon.source: "image://theme/icon-m-speaker-mute"
            onCheckedChanged: console.log("Stwitch toggled")
        }
        TextSwitch {
            width: page.width
            text: checked ? qsTr("Active") : qsTr("Inactive")
            description: qsTr("Switch with text label")
        }
        IconTextSwitch {
            width: page.width
            icon.source: "image://theme/icon-m-speaker-mute"
            text: checked ? qsTr("Active") : qsTr("Inactive")
            description: qsTr("Switch with text label and icon")
        }
    }
}
