// SPDX-FileCopyrightText: 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import QtQuick 2.6
import Sailfish.Silica 1.0

Page {
    PageHeader { title: qsTr("Label") }
    Column {
        anchors.centerIn: parent
        width: parent.width - 2 * Theme.horizontalPageMargin

        Label {
            width: parent.width
            text: qsTr("Text that should not be elided or faded out")
            font.pixelSize: Theme.fontSizeExtraLarge
        }
        Label {
            width: parent.width
            text: qsTr("Text that should be elided off the right end")
            truncationMode: TruncationMode.Elide
            font.pixelSize: Theme.fontSizeExtraLarge
        }
        Label {
            width: parent.width
            text:
                qsTr("Text that should be faded out rather than elided")
            truncationMode: TruncationMode.Fade
            font.pixelSize: Theme.fontSizeExtraLarge
        }
    }
}
