// SPDX-FileCopyrightText: 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import QtQuick 2.6
import Sailfish.Silica 1.0

Page {
    SilicaFlickable {
        id: flickable
        anchors.fill: parent
        contentWidth: column.width; contentHeight: column.height

        Column {
            id: column
            width: flickable.width

            PageHeader { title: qsTr("SilicaFlickable") }
            Image {
                source: "../graphics/logo_qt_2016.svg"
                width: sourceSize.width
                height: flickable.height * 1.5
                anchors.horizontalCenter: parent.horizontalCenter
                fillMode: Image.TileVertically
            }
        }
        VerticalScrollDecorator { }
    }
}
