// SPDX-FileCopyrightText: 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import QtQuick 2.6
import Sailfish.Silica 1.0

Page {
    PageHeader { id: header }
    Button {
        text: qsTr("Set header")
        anchors.centerIn: parent
        onClicked: {
            var dialog =
                pageStack.push(Qt.resolvedUrl("../dialogs/HeaderInputDialog.qml"),
                    {"name": header.title});
            dialog.accepted.connect(function() {
                header.title = dialog.name;
            });
        }
    }
}
