// SPDX-FileCopyrightText: 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

var cache = [];

function binomialCoefficient(row, column) {
    if (!cache[row])
        cache[row] = [];
    if (cache[row][column] !== undefined)
        return cache[row][column];
    console.log(row, column);
    var result = row < column
                 ? 0
                 : column === 0 || column === row
                   ? 1
                   : binomialCoefficient(row - 1, column - 1) +
                     binomialCoefficient(row - 1, column);
    cache[row][column] = result;
    return result;
}

WorkerScript.onMessage = function(message) {
    var result = binomialCoefficient(message.row, message.column);
    WorkerScript.sendMessage({
        row: message.row,
        column: message.column,
        result: result
    });
}
