# Тесты по теме «Silica»

Copyright&nbsp;©&nbsp;2016–2023 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Single choice

С помощью какого из свойств можно установить доступные странице ориентации экрана?

---

*	orientationTransitions
*	 defaultOrientationTransition
*	 orientation
*	 **allowedOrientations**

## Matching

Сопоставьте модули и их функциональность:

---

|         |                                                                       |
|---------|-----------------------------------------------------------------------|
| QtQML   | общеязыковая литература                                               |
| QtQuick | основные типы для создания пользовательского интерфейса               |
| Silica  | основные типы для создания пользовательского интерфейса для ОС Аврора |

## Text

С помощью какого QML-типа можно инкапсулировать другие типы?

---

Component

## Single choice

Можно ли комбинировать в значении свойства orientation набор ориентаций интерфейса для конкретной страницы?

---

*	**да**
*	нет

## Text

На стеке есть одна страница.
С помощью метода pushAttached() прикрепляем новую страницу и переходим на неё.
Затем с помощью метода push() помещаем ещё одну страницу сверху.
Какова будет глубина стека страниц?

---

3

## Multiple choice

Какие действия инициирует метод pushAttached()?

---

*	переход на новую страницу
*	переход на следующую страницу
*	**добавление правого индикатора перехода**
добавление левого индикатора перехода
*	переход на предыдущую станицу
*	**создание новой станицы**

## Text

Какой размер шрифта из набора Theme рекомендуется выбрать для стандартного заголовка?

---

fontSizeLarge

## Single choice

Каким цветом из набора Theme рекомендуется выделять выбранные элементы?

---

*	primaryColor
*	secondaryColor
*	**highlightColor**

## Single choice

Можно ли изменить цвет системной иконки?

---

*	**да**
*	нет

## Matching

Сопоставьте компоненты и свойства, которые можно использовать для масштабирования интерфейса для разных экранов:

---

|        |              |
|--------|--------------|
| Theme  | pixelRatio   |
| Screen | sizeCategory |

## Single choice

Сколько элементов рекомендуется помещать в вытягиваемое меню?

---

*	**не больше 4**
*	не больше 5
*	от 2 до 6
*	от 1 до 3

## Multiple choice

Для чего рекомендуется использовать иконки размера Theme.iconSizeSmall?

---

*	**часть текста страницы**
*	**индикаторы**
*	кнопки, если на странице расположено большое число элеменов интерфейса

## Multiple choice

Что можно задать с помошью компонента Theme?

---

*	**отступы между элементами**
*	**размеры элементов**
*	картинки для миниатюр/иконок
*	скругление углов элементов

## Single choice

Какие методы PageStack позволяют передать странице параметры?

---

*	**push**
*	pop
*	navigateForward
*	navigateBack

## Single choice

Сколько компонентов PageStack может быть в приложении для ОС Аврора?

---

*	не менее одного
*	**ровно один**
*	число не ограничено
*	0 или 1

## Single choice

Сколько обложек может быть у приложения?

---

*	**одна, заданная в начале работы приложения**
*	несколько, в процессе работы они могут меняться

## Single choice

Какой фон по умолчанию будет иметь Cover?

---

*	белый
*	иконка приложения
*	полупрозрачный
*	**прозрачный** 

## Single choice

Что собой представляет CoverBackground?

---

*	**полупрозрачный по умолчанию Cover**
*	Cover с логотипом ОС Аврора на фоне

## Text

Какой компонент управляет стеком диалогов?

---

pageStack

## Single choice

Можно ли работать с диалогом как с прикрепленной страницей?

---

*	**да**
*	нет

## Multiple choice

```js
var formDialog = pageStack.push(Qt.resolvedUrl("FormDialog.qml"), record);
```

Как получить данные, введенные пользователем, из formDialog?

---

*	**в обработчике сигнала accepted обратиться к свойствам диалога**
*	**в обработчике сигнала done обратиться к свойствам диалога**
*	обратиться к свойствам диалога сразу после его создания

## Single choice

Как можно назначить правую кнопку из DialogHeader обработчиком сигнала rejected, а левую *	accepted?

---

*	**это сделать нельзя**
*	назначить revertButtons = true
*	указать на кнопке соответствующий текст
*	прямо назначить кнопкам обработчики accepted и rejected

## Matching

Сопоставьте значения truncationMode у Label и их эффекты:

---

|       |               |
|-------|---------------|
| None  | текст обрезан |
| Elide | многоточие    |
| Fade  | затухание     |

## Multiple choice

Текст каких типов может распознать LinkedLabel?

---

*	**url**
*	**номер телефона**
*	**электронная почта**
*	адрес
*	имя и фамилия
*	дата рождения

## Single choice

Где отображается текст, указанный в placeholderText у TextField?

---

*	**в поле ввода, когда оно пусто**
*	в поле ввода, это введённый пользователем текст
*	над полем ввода
*	под полем ввода

## Single choice

Можно ли изменить расположение placeholderText у TextField?

---

*	да
*	**нет**

## Matching

Сопоставьте значения inputMethodHints и их функциональность:

---

|                              |                             |
|------------------------------|-----------------------------|
| Qt.ImhDialableCharactersOnly | телефонный номер            |
| Qt.ImhDigitsOnly             | целые числа                 |
| Qt.ImhFormattedNumbersOnly   | десятичные числа            |
| Qt.ImhNoPredictiveText       | без интеллектуального ввода |

## Single choice

В каком случае ввод будет отклонен, если для поля настроен DoubleValidator?

---

*	**введено не Double**
*	Double не находится в заданном валидатором диапазоне
*	ввод пуст

## Single choice

Можно ли назначить валидатор для TextArea?

---

*	да
*	**нет**

## Matching

Сопоставьте свойства Button и цвета, которые они настраивают:

---

|                          |                            |
|--------------------------|----------------------------|
| color                    | цвета кнопки и текста      |
| highlightBackgroundColor | цвет фона нажатой кнопки   |
| highlightColor           | цвет текста нажатой кнопки |

## Single choice

Какую форму имеет IconButton?

---

*	**круг**
*	квадрат
*	прямоугольник
*	квадрат со скругленными углами

## Matching

Сопоставьте свойства ValueButton и их назначение:

---

|             |                                                       |
|-------------|-------------------------------------------------------|
| description | дополнительный текст о функциональности кнопки        |
| label       | основной текст на кнопке                              |
| value       | второй по значимости текст, описание выбранных данных |

## Single choice

Для чего рекомендуется назначать свойству busy у Switch значение true?

---

*	**чтобы показать индикацию процесса, если изменение настройки требует времени**
*	чтобы включить переключатель
*	чтобы показать, что переключатель нельзя использовать из-за значений других настроек

## Single choice

Можно ли на компоненте IconTextSwitch указать дополнительное описание о функциональности?

---

*	**да, в свойстве description**
*	нет, на самом компоненте нельзя отобразить текст

## Text

С помощью какого свойства можно получить текущее состояние переключателя?

---

*	checked

## Multiple choice

Какие нативные типы меню имеются в Silica?

---

*	**верхнее**
*	**нижнее**
*	боковое
*	**контекстное**

## Single choice

Какие компоненты может содержать меню?

---

*	MenuItem
*	MenuLabel
*	собственный компонент
*	**все перечисленные**

## Single choice

Чем отличаются MenuItem и MenuLabel?

---

*	MenuItem *	абстрактный компонент, MenuLabel *	интерактивный пункт
*	**MenuItem *	интерактивный пункт, MenuLabel *	информационный, который не может быть нажат**

## Single choice

Как нужно настроить элемент, чтобы его контекстное меню не обрезалось?

---

*	настройка не нужна, меню будет расположено в правильной позиции автоматически
*	**необходимо задать размеры элемента в зависимости от размеров меню**

## Single choice

Какое свойство рекомендуется использовать, чтобы у ListItem
и его содержимого высота была корректной при открытии и закрытии контекстного меню?

---

*	height у ListItem
*	height у элементов, вложенных в ListItem
*	**contentHeight у ListItem**

## Single choice

Как можно закрыть контекстное меню у ListItem?

---

*	установить menuOpen = false
*	**вызвать метод closeMenu()**

## Single choice

Что нужно сделать, чтобы в прокручиваемом элементе `SilicaFlickable` появилась полоса прокрутки?

---

*	 **Добавить `VerticalScrollDecorator` внутрь тела `SilicaFlickable`**
*	 Ничего, она есть изначально
*	 Добавить `VerticalScrollDecorator` вне тела `SilicaFlickable`

## Matching

Сопоставьте контейнеры и их назначение:

---

|                                 |                           |
|---------------------------------|---------------------------|
| SilicaFlickable                 | компонент с прокруткой    |
| SilicaListView                  | список элементов          |
| SilicaGridView                  | сетка из элементов        |
| SilicaWebView                   | отображение веб-страниц   |
| SlideshowView                   | организация слайдшоу      |

## Single choice

Чем SilicaFlickable отличается от Flickable?

---

*	**в SilicaFlicable можно добавить меню**
*	в Flicable можно добавить меню
*	ничем, кроме внешнего вида SilicaFlickable в стиле ОС Аврора

## Single choice

Зачем нужен компонент SectionHeader?

---

*	**указать заголовок секции сгруппированных элементов**
*	указать заголовок контейнера

## Text

С помощью какого свойства задаётся шаблон элемента при отображении списка, сетки или слайдшоу?

---

delegate

## Text

С помощью какого свойства производится деление списка на секции?

---

section

## Single choice

В каком порядке происходит заполнение ячеек в SilicaGridView по умолчанию?

---

*	сверху вниз
*	в произвольном порядке
*	**слева направо**

## Single choice

Какая страница будет отображена после последней страницы в SlideshowView?

---

*	**первая**
*	предпоследняя
*	слайдшоу остановится

## Single choice

Можно ли изменить свойство loading у SilicaWebView?

---

*	**нет**
*	да

## Single choice

Можно ли задать дату в DatePicker, используя свойства day, month, year?

---

*	**нет**
*	да

## Single choice

Как у DatePicker отобразить названия дней недели?

---

*	**установить daysVisible = true**
*	установить weeksVisible = true
*	они отображены по умолчанию
*	это нельзя сделать средствами компонента

## Single choice

Можно ли у TimePicker задать время, используя свойства hour и minute?

---

*	**да**
*	нет

## Single choice

Как отобразить на элементе TimePicker выбранное время в текстовом виде?

---

*	оно отображается автоматически
*	нужно установить timeVisible = true
*	**TimePicker не отображает такой формат, нужно создать свой элемент**

## Matching

Сопоставьте экраны и их функциональность:

---

|                                 |                           |
|---------------------------------|---------------------------|
| Экран блокировки                | предотвращение случайного использования |
| Домашний экран                  | свёрнутые приложения      |
| Экран событий                   | уведомления, быстрые события |
| Меню приложений                 | установленные приложения |

## Multiple choice

Что настраивает атмосфера?

---

*	**Фоновое изображение**
*	**Цвет элементов**
*	Поведение кнопок
*	Значение жестов
