# Фреймворк Qt и технология Qt Quick

Copyright&nbsp;©&nbsp;2016–2023 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Кроссплатформенный фреймворк Qt

Qt — кроссплатформенный фреймворк для разработки программного обеспечения на языке программирования C++.

Qt позволяет запускать написанное с его помощью программное обеспечение в большинстве современных
операционных систем путём простой компиляции программы для каждой системы без изменения исходного кода.
Включает в себя все основные классы, которые могут потребоваться при разработке прикладного
программного обеспечения, начиная от элементов графического интерфейса и заканчивая классами
для работы с сетью, базами данных и XML.
Является полностью объектно-ориентированным, расширяемым и поддерживающим технику компонентного программирования.

## История Qt

Первый выпуск библиотеки Qt состоялся в мае 1995 года.
Первоначально она разрабатывалась Хаавардом Нордом (главный управляющий Trolltech)
и Эриком Чамбенгом (президент компании Trolltech).

В 1991 году Хаавард написал первые несколько классов, из которых потом и появилась Qt.
Эрик занялся разработкой общего дизайна библиотеки.
На следующий год Эрику пришла в голову идея реализации "сигналов и слотов" — простой,
но очень мощной парадигмы программирования графического интерфейса.
Хаавард подхватил идею и воплотил ее в код. К 1993 году они завершили разработку первого
графического ядра и приступили к созданию визуальных компонентов (widgets).
В конце года Хаавард предложил Эрику открыть совместное дело и выпустить "лучшую в мире библиотеку
реализации графического интерфейса на C++".

В апреле 1995 года, благодаря содействию профессора, у которого обучался Хаавард,
Норвежская компания Metis заключила с ними контракт на разработку программного обеспечения на базе Qt.

Первый выпуск Qt/Embedded состоялся в 2000 году. 
Она была разработана для работы в устройствах под управлением Embedded Linux и предоставляла
свою оконную подсистему — легковесную замену X11.
И Qt/Embedded, и Qt/X11 предлагались под широко используемой лицензией GNU General Public License
(GPL), так же как и под коммерческими лицензиями.

В 2001 году вышла Qt 3.
Теперь эта библиотека может работать под управлением Windows, Unix, Linux, Embedded Linux и Mac OS X.
В ее состав вошли 42 новых класса, а общий объем кода перевалил за 500 000 строк.

Летом 2005 года была выпушена Qt 4.0.
Имея около 500 классов и более 9000 функций, Qt 4 оказалась больше и богаче любой предыдущей версии;
она была разбита на несколько библиотек, чтобы разработчики могли использовать только нужные им части Qt.

*	2008, 17 июня — Nokia приобретает Trolltech.
*	2009, 14 января — выпуск Qt 4.5 с опцией LGPL.
*	2010, 23 июня — выпуск Nokia Qt SDK 1.0 с поддержкой S60 и Maemo.
*	2011, март — продажи Nokia Qt и услуги Digia для поддержки мобильных платформ.
*	2012, Audust — Digia приобретает Qt от Nokia.
*	2012, октябрь — выпуск Qt 5.0 с ускоренной графикой, большая роль QML и JS.
*	2014, сентябрь — Digia создает компанию Qt.
*	2016, май — Компания Qt независима от Digia, Qt 5 перешла к открытому управлению.

## Модули Qt

Библиотека разделена на несколько модулей, вот некоторые из них (для пятой версии):

*	QtCore – классы ядра библиотеки, используемые другими модулями;
*	QtGui – компоненты графического интерфейса;
*	QtWidgets– классы виджетов для создания граф. интерфейса пользователя.
*	QtMultimedia – классы, поддерживающие функциональность аудио, видео, радио и камеры;
*	QtNetwork – набор классов для сетевого программирования;
*	QtOpenGL – набор классов для работы с OpenGL;
*	QtSql – набор классов для работы с БД с использованием языка SQL.
*	QtScript – классы для работы с Qt Scripts (специальным скриптовым языком Qt, похожем наJavaScript);
*	QtXml – модуль для работы с XML, поддерживается SAX и DOM модели работы;
*	QtWebKit – модуль с элементами веб-браузера;
*	Qt Quick– модуль, предоставляющий декларативный фреймворк для создания динамичных,
	настраиваемых пользовательских интерфейсов.

## Qt API для мобильных устройств

Qt предоставляет API для разнообразной функцональности:

*	Элементы интерфейса пользователя;
*	Файловая система, базы данных;
*	Геолокация и карты;
*	Сеть, телефония;
*	Мультимедиа;
*	Датчики;
*	Календарь, контакты, сообщения, будильники;
*	D-Bus, взаимодействие между приложениями.

## Концепции Qt

Рассмотрим основные концепции Qt и устройство фреймворка.
ui/ux ориентирован на платформу, под которую разрабатывается ПО.
При этом общая бизнес-логика приложения остается единой, благодаря чему достигается кроссплатформенность.

Сигналы и слоты используются для коммуникации между объектами в Qt.
Механизм сигналов и слотов является центральной функцией в Qt.
Этот механизм позволяет наглядно описывать связи между различными объектами.
Также это удобный способ уведомить объекты о каком-то событии и отслеживать изменения значений свойств объекта.

Ещё одна отличительная особенность Qt — использование метаобъектного компилятора — предварительной
системы обработки исходного кода.
Его мы обсудим подробнее, когда будем говорить об объектной модели Qt.

## Мобильные приложенияс GUI

Архитектура GUI-приложений подразумевает следующие подходы.

Декларативное описание UI с помощью QML.

*	Стандартный модуль QtQuick для создания интерфейсов.
*	Специфичный модуль Silica для адаптации интерфейса под ОС Аврора.
*	Доступ к некоторым API через QML.
*	«Лёгкая» логика на JavaScript.

Запуск с помощью исполняемого кода на C++.

*	Основной файл QML встраивается в QQuickView в main.cpp.
*	Доступ к библиотекам и Qt-модулям через C++.
*	Низкоуровневый доступ к API устройства.
*	«Тяжёлые» вычисления, которые следует оптимизировать.

## Расширение C++ классов

Qt предоставляет макросы для расширения C++-классов.

## Qt Quick — технология быстрой разработки

Qt Quick — модуль Qt, предоставляющий фреймворк для создания приложений на языке QML.
Предоставляет язык программирования QML для описания интерфейсов и его библиотеки, а также
описывает логику преобразования интерфейсов на QML в классы С++.
Помимо этого, предоставляет API, позволяющий разработчикам создавать  собственные типы как на стороне
QML (QML API),  так и на стороне С++ (C++ API).

QML (Qt Meta Language or Qt Modeling Language) предназначен для описания пользовательских интерфейсов
с точки зрения соотношения визуальных типов, их взаимодействия друг с другом.
QML имеет легкочитаемый JSON-подобный синтаксис с поддержкой императивного кода на языке JavaScript
и динамическим связыванием свойств.
С помощью QML можно описывать как визуальные, так и невизуальные типы.

В то время как Qt QML-модуль предоставляет QML-движок и общеязыковую инфраструктуру, модуль
Qt Quick предоставляет все основные типы, необходимые для создания пользовательских интерфейсов с QML.
Он предоставляет полотно и включает в себя типы для создания и анимации визуальных компонентов,
получения пользовательского ввода, создания моделей данных и представлений и создания замедленного объекта.
Модуль Qt Quick предоставляет как QML API, который предоставляет типы QML для создания
пользовательских интерфейсов с языком QML, так и C++ API для расширения приложений на QML кодом на C++.

## Модели и представления

Для организации графических приложений используются архитектуры модель-представление-контроллер
и модель-представление-делегат.

## Что даёт опыт использования Qt

Знания:

*	Императивный (C++) и декларативный (QML) подходы к разработке.
*	Мета-объектная парадигма и её реализация в Qt.
*	Понимание контейнеров и действий с ними.
*	Многопоточность в Qt.
*	MVC, MVD - архитектуры для организации графических интерфейсов.
*	События.
*	Очередь событий.
*	Обработчики событий.
*	Сигналы и слоты как альтернатива обработчикам.

Практические навыки:

*	Написание кода на QML, C++ и JS.
*	Проектирование ПО, выбор и реализация архитектуры.
*	Гибридная связка (декларативное + императивное программирование).
*	Модели-представления, организация графических интерфейсов.
*	Работа с API и разнообразными данными.
*	Мультимедиа.
*	Сети.
*	БД для десктопных и мобильных приложений.
*	Файлы.
*	Датчики.
*	Картография.

### Qt для мобильных платформ

Qt позволяет разрабатывать для различных мобильных платформ.
На слайде перечислены источники информации о мобильной разработке на Qt.
