# Тесты по теме «Основы QML»

Copyright&nbsp;©&nbsp;2016–2023 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Single choice

Как можно создать угловой градиент?

---

*	Использовать свойство Gradient.angle
*	Использовать Gradient и задать поворот на 90 градусов
*	**Использовать готовое изображение**

## Multiple choice

Какие из данных определений свойств не являются корректными?

---

*	`property int count: 0`
*	 `property var myObject`
*	 **`property string title = "The title"`**

## Multiple choice

Какое значение нужно присвоить свойству color объекта Rectangle, чтобы получить прямоугольник зелёного цвета?

---

*	**`green`**
*	**`"#00FF00"`**

## Multiple choice

С помощью какого свойства можно изменить размер шрифта текста?

---

*	**`font.pointSize`**
*	**`font.pixelSize`**


## Multiple choice

Какие из свойст якорей привязываются к якорям других элементов?

---

*	 `anchors.margins`
*	 `anchors.centerIn`
*	 `anchors.fill`
*	 **`anchors.top`**
*	 **`anchors.horizontalCenter`**

## Order

Есть три перекрывающих друг друга прямоугольника разных цветов, которым соответствует следующий код:

```qml
Item {
	Rectangle {
	x: 0; y: 0; width: 100; height: 100
	color: "red"
	}
	Rectangle {
		x: 50; y: 25; width: 100; height: 100
		color: "green"
		Rectangle {
			x: -25; y: 25; width: 100; height: 100
			color: "blue"
			z: -1
		}
	}
}
```

В каком порядке будут отрисованы прямоугольники?

---

*	Красный
*	Синий
*	Зелёный

## Order

Есть три перекрывающих друг друга прямоугольника разных цветов, которым соответствует следующий код:

```qml
Item {
	Rectangle {
		x: 0; y: 0; width: 100; height: 100
		color: "red"
		z: 10
		Rectangle {
			x: 50; y: 25; width: 100; height: 100
			color: "green"
		}
	}
	Rectangle {
		x: 25; y: 50; width: 100; height: 100
		color: "blue"
	}
}
```

В каком порядке будут отрисованы прямоугольники?

---

*	Зелёный
*	Красный
*	Синий

## Matching

Сопоставьте QML-компоненты и их функциональность.

---

|         |                          |
|---------|--------------------------|
| `Grid`  | Контейнер-сетка          |
| `Image` | Внешний вид изображения  |
| `Row`   | Горизонтальный контейнер |

## Multiple choice

Сколько параметров сетки нужно указать у Grid?

---

*	**Параметры можно не указывать, по умолчанию будут 4 столбца**
*	**Можно указать только columns, число строк будет рассчитано автоматически**
*	**Можно указать только rows, число столбцов будет рассчитано автоматически**
*	Обязательно нужно указать и columns, и rows
