# Тесты по теме «Инструменты разработки»

Copyright&nbsp;©&nbsp;2016–2023 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Multiple choice

Выберите утверждения, справедливые для ОС Аврора.

---

*	**Инфраструктура может быть развернута внутри отдельной компании**
*	**POSIX-совместимый дистрибутив Linux**
*	Использует инфраструктуру Google
*	Выполняет байт-код Java, предоставляя нативный API

## Single choice

Какой демон используется в качестве менеджера системы и сервисов ОС Аврора?

---

*	**systemd**
*	SysV
*	Upstart
*	init.d

## Multiple choice

На какие устройства можно установить ОС Аврора?

---

*	Компьютеры
*	Другие портативные устройства
*	**Смартфоны**
*	**Планшеты**

## Matching

Установите соответствие между элементами и уровнями архитектуры ОС Аврора.

---

|                                 |                           |
|---------------------------------|---------------------------|
| Базовый уровень                 | Hardware Adaptation Layer |
| Промежуточный уровень           | libhybrus                 |
| Уровень интерфейса и приложений | Lipstick                  |

## Multiple choice

Какие архитектуры поддерживает ОС Аврора?

---

*	Эльбрус-3
*	**x86**
*	**ARM**
*	powerPC

## Multiple choice

Какие функции предоставляет панель управления?

---

*	**Отслеживание статуса устройств**
*	**Удаление приложений**
*	**Управление обновлениями операционной системы**
*	**Удаление данных**

## Single choice

Сколько аккаунтов пользователей может быть на устройстве ОС Аврора?

---

*	1
*	2: администратор и пользователь
*	**7: администратор и 6 пользователей**
*	Количество не ограничено

## Multiple choice

Какие команды отвечают за установку и сборку пакетов в Build Engine?

---

*	sb
*	**sb2**
*	**mb2**
*	mb

## Multiple choice

Что содержит RPM пакет?

---

*	**Ресурсы**
*	**Скрипты для установки и удаления программы**
*	**Исполнительный файл приложения**
*	**Зависимости**
*	**Библиотеки**

## Single choice

Что содержится в .pro файле?

---

*	**Описание структуры и подключаемые модули**
*	Файлы переводов
*	Параметры сборки rpm-пакета
*	Исходный код
*	Параметры запуска приложения

## Multiple choice

Что требуется, чтобы разрабатывать приложения для ОС Аврора с помощью Qt?

---

*	Qt SDK
*	**Аврора SDK**
*	**Virtual Box**

## Single choice

Какой комплект архитектуры необходимо выбрать для установки приложения на эмулятор?

---

*	**x86**
*	ARM

## Multiple choice

Для чего используется qmake?

---

*	**Cборка проектов**
*	**Настройка конфигурации сборки проекта**
*	Запуск приложения на устройстве
*	Загрузка бинарных файлов проекта на эмулятор

## Matching

К каким переменным qmake относятся указанные функции?

---

|                                   |                |
|-----------------------------------|----------------|
| Модули Qt, используемые в проекте | `QT`           |
| Файлы ресурсов                    | `RESOURCES`    |
| Файлы с исходным кодом на C++     | `SOURCES`      |
| Заголовочные файлы C++            | `HEADERS`      |
| Файлы перевода                    | `TRANSLATIONS` |
| Файлы QML                         | `DISTFILES`    |

## Single choice

В переменной `SOURCES` уже хранится значение `app.cpp`.

Выполняется код:

```
 SOURCES = main.cpp mainwindow.cpp \
       paintwidget.cpp
```

Что будет находиться в переменной `SOURCES`?

---

*	Невозможно определить
*	Четыре ссылки на cpp-файлы
*	Две ссылки на cpp-файлы
*	**Три ссылки на cpp-файлы**
*	Одна ссылка на cpp-файл

## Matching

К каким компонентам проекта приложения, как правило, относятся указанные функции?

---

|                                                             |                             |
|-------------------------------------------------------------|-----------------------------|
| Файлы для сборки rpm-пакета                                 | Директория rpm              |
| Файлы с исходным кодом на C++                               | Директория src              |
| Параметры запуска приложения                                | Файл с расширением desktop  |
| Файлы с исходным кодом на QML                               | Директория qml              |
| Описание структуры и модулей проекта                        | Файл с расширением pro      |
| Файлы переводов                                             | Директория translations     |
| Локальные настройки SDK, которые не нужно никому передавать | Файл с расширением pro.user |

## Single choice

Какие значения может принимать переменная TEMPLATE в .pro файле?

---

*	app, desktop, mobile
*	app, qt4, qt5
*	**app, lib, subdirs**
*	app, debug, release

## Multiple choice

Что может содержаться в pro-файле приложения?

---

*	**Собственные переменные и функции qmake**
*	**Информация о конфигурации**
*	**Код подключения библиотек**
*	текстовое описание приложения

## Text

Какое разрешение нужно использовать, чтобы получить доступ к стандартной директории с изображениями?

---

Pictures

## Single choice

Какое имя установочного пакета является допустимым?

---

*	**ru.auroraos.myapp-0.1-1.armv7hl.rpm**
*	ru.auroraos.myapp-0.1-1.arm.rpm
*	ru.auroraos.myapp.rpm
*	myapp-0.1.armv7hl.rpm

*	Upstart
*	init.d
