// SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: CC-BY-4.0

import QtQuick 2.0
import Sailfish.Silica 1.0
import Nemo.Thumbnailer 1.0

Page {
    id: page
    allowedOrientations: Orientation.All
    property url image: "logo.png"
    SilicaFlickable {
        anchors.fill: parent
        contentHeight: column.height
        Column {
            id: column
            width: page.width
            spacing: Theme.paddingLarge
            PageHeader {
                title: qsTr("Thumbnailer Example")
            }
            Image {
                source: "image://nemoThumbnail/" + image
                width: 100
                height: 100
                sourceSize.width: width
                sourceSize.height: height
                anchors.horizontalCenter: parent.horizontalCenter
            }
            Thumbnail {
                id: thumbnail
                source: image
                width: 100
                height: 200
                sourceSize.width: width
                sourceSize.height: height
                fillMode: Thumbnail.PreserveAspectCrop
                onStatusChanged: statusLabel.text = "Thumbnail status: " + status
                anchors.horizontalCenter: parent.horizontalCenter
            }

            Label {
                id: statusLabel
            }
        }
    }
}

