// SPDX-FileCopyrightText: 2023–2025 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import QtQuick 2.6
import Sailfish.Silica 1.0

Page {
    PageHeader { title: qsTr("Input Fields") }
    Column {
        anchors.centerIn: parent
        width: parent.width
        
        TextField {
            width: parent.width
            placeholderText: qsTr("Fill the field")
            label: qsTr("Text Field")
            inputMethodHints: Qt.ImhFormattedNumbersOnly
            validator: DoubleValidator { bottom: -10; top: 10; decimals: 2 }
            EnterKey.enabled: !errorHighlight
            EnterKey.iconSource: "image://theme/icon-m-enter-next"
            EnterKey.onClicked: textArea.focus = true
        }
        TextArea {
            width: parent.width
            label: qsTr("Multi-line text")
            placeholderText: qsTr("Input something and press Enter")
            wrapMode: TextEdit.WordWrap
        }
        PasswordField {
            width: parent.width
            placeholderText: qsTr("Enter the password")
            label: qsTr("Password Field")
            showEchoModeToggle: true
            EnterKey.iconSource: "image://theme/icon-m-enter-accept"
        }
        SearchField {
            width: parent.width
            placeholderText: qsTr("What do you want?")
        }
    }
}
