// SPDX-FileCopyrightText: 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import QtQuick 2.0
import Sailfish.Silica 1.0

Page {
    objectName: "mainPage"
    allowedOrientations: Orientation.All
    SilicaListView {
        header: PageHeader { title: qsTr("Main Page") }
        anchors.fill: parent
        delegate: ListItem {
            Label {
                anchors.verticalCenter: parent.verticalCenter
                x: Theme.horizontalPageMargin
                color: highlighted ? Theme.highlightColor : Theme.primaryColor
                text: model.name
            }
            onClicked: {
                pageStack.push(Qt.resolvedUrl(model.page + ".qml"))
                applicationWindow.currentPageName = model.name
            }
        }
        section {
            property: "category"
            criteria: ViewSection.FullString
            delegate: SectionHeader { text: section }
        }
        model: ListModel {
            ListElement {
                name: qsTr("Label")
                page: "LabelPage"
                category: "Controls"
            }
            ListElement {
                name: qsTr("Text Input")
                page: "TextInputPage"
                category: "Controls"
            }
            ListElement {
                name: qsTr("Buttons")
                page: "ButtonsPage"
                category: "Controls"
            }
            ListElement {
                name: qsTr("Switches")
                page: "SwitchesPage"
                category: "Controls"
            }
            ListElement {
                name: qsTr("PageStack")
                page: "PageStackPage"
                category: "Stack"
            }
            ListElement {
                name: qsTr("SilicaFlickable")
                page: "FlickablePage"
                category: "Views"
            }
            ListElement {
                name: qsTr("SilicaListView")
                page: "ListViewPage"
                category: "Views"
            }
            ListElement {
                name: qsTr("SilicaGridView")
                page: "GridViewPage"
                category: "Views"
            }
            ListElement {
                name: qsTr("SlideshowView")
                page: "SlideshowViewPage"
                category: "Views"
            }
            ListElement {
                name: qsTr("Panels")
                page: "PanelPage"
                category: "Views"
            }
            ListElement {
                name: qsTr("PullDownMenu & PushUpMenu")
                page: "PulleyMenuPage"
                category: "Menus"
            }
            ListElement {
                name: qsTr("ContextMenu")
                page: "ContextMenuPage"
                category: "Menus"
            }
            ListElement {
                name: qsTr("Dialog")
                page: "DialogPage"
                category: "Dialogs"
            }
        }
        VerticalScrollDecorator { }
    }
}
