// SPDX-FileCopyrightText: 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import QtQuick 2.6
import Sailfish.Silica 1.0

Page {
    SilicaListView {
        header: PageHeader { title: qsTr("SilicaListView") }
        anchors.fill: parent
        delegate: ListItem {
            Label {
                text: qsTr("Item %1").arg(model.index + 1)
                anchors.verticalCenter: parent.verticalCenter
                x: Theme.horizontalPageMargin
                color: highlighted ? Theme.highlightColor : Theme.primaryColor
            }
        }
        model: 100

        VerticalScrollDecorator { }
    }
}
