// SPDX-FileCopyrightText: 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import QtQuick 2.6
import Sailfish.Silica 1.0

Dialog {
    property string name

    DialogHeader {
        acceptText: qsTr("Set header")
        cancelText: qsTr("Don't change")
    }
    TextField {
        id: nameField
        anchors.centerIn: parent
        width: parent.width
        placeholderText: qsTr("Enter page name")
        label: qsTr("Page name")
        text: name
    }

    onDone: if (result == DialogResult.Accepted) name = nameField.text
}
