// SPDX-FileCopyrightText: 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import QtQuick 2.0
import Sailfish.Silica 1.0
import "../components"

Page {
    objectName: "mainPage"
    allowedOrientations: Orientation.All

    PageHeader {
        id: pageHeader
        objectName: "pageHeader"
        title: qsTr("Planets")
    }

    Grid {
        id: layout
        objectName: "layout"
        columns: 2
        anchors.fill: parent
        anchors.topMargin: pageHeader.height

        Repeater {
            model: ListModel {
                ListElement { name: "Меркурий"; surfaceColor: "gray" }
                ListElement { name: "Венера"; surfaceColor: "yellow" }
                ListElement { name: "Земля"; surfaceColor: "blue" }
                ListElement { name: "Марс"; surfaceColor: "orange" }
                ListElement { name: "Юпитер"; surfaceColor: "orange" }
                ListElement { name: "Сатурн"; surfaceColor: "yellow" }
                ListElement { name: "Уран"; surfaceColor: "lightBlue" }
                ListElement { name: "Нептун"; surfaceColor: "lightBlue" }
            }

            PlanetItem {
                planetName: name
                planetColor: surfaceColor
                width: layout.width / layout.columns
            }
        }
    }
}
