// SPDX-FileCopyrightText: 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import QtQuick 2.0
import Sailfish.Silica 1.0

Item {
    id: root
    objectName: "PlanetItem"

    property alias planetName: text.text
    property alias planetColor: planetCircle.color

    height: width / 3

    Rectangle {
        id: planetCircle
        objectName: "planetCircle"
        width: parent.height * 0.8
        height: width
        radius: width / 2
        anchors {
            left: parent.left
            leftMargin: width / 8
            verticalCenter: parent.verticalCenter
        }
    }

    Label {
        id: text
        objectName: "text"
        anchors {
            left: planetCircle.right
            leftMargin: planetCircle.width / 8
            verticalCenter: parent.verticalCenter
        }
    }
}
