// SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import QtQuick 2.0
import Sailfish.Silica 1.0

Page {
    objectName: "mainPage"
    allowedOrientations: Orientation.All

    PageHeader {
        objectName: "pageHeader"
        title: qsTr("Pinch Image")
    }

    Image {
        id: image
        objectName: "image"
        source: Qt.resolvedUrl("../images/aurora.svg")
        fillMode: Image.PreserveAspectFit
        anchors { fill: parent; margins: parent.height / 10 }
        property real initialScale: 1.0
        property real initialX: 0
        property real initialY: 0

        PinchArea {
            anchors.fill: parent
            onPinchStarted: {
                image.initialScale = image.scale
                image.initialX = image.x
                image.initialY = image.y
            }
            onPinchUpdated: {
                image.scale = image.initialScale * pinch.scale
                image.x = image.initialX + (pinch.center.x - pinch.startCenter.x) * image.scale
                image.y = image.initialY + (pinch.center.y - pinch.startCenter.y) * image.scale
            }
        }
    }
}
