// SPDX-FileCopyrightText: 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import QtQuick 2.0

Item {
    id: root

    property real fontSize: width / 16

    function requestResult() {
        resultText.text = "Loading...";
        worker.sendMessage({
            row: rowEdit.value,
            column: columnEdit.value
        });
    }

    WorkerScript {
        id: worker
        source: "js/worker.js"

        onMessage: {
            if (messageObject.row === rowEdit.value
                    && messageObject.column === columnEdit.value) {
                if (!messageObject.result)
                    resultText.text = "Column must be <= Row and both must be positive or zero";
                else
                    resultText.text = messageObject.result;
            }
        }
    }

    Column {
        objectName: "layout"
        width: parent.width

        Text {
            id: resultText
            objectName: "resultText"
            height: root.height / 2
            width: parent.width
            wrapMode: Text.WordWrap
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            font.pixelSize: fontSize
        }

        Row {
            objectName: "inputLayout"
            anchors.horizontalCenter: parent.horizontalCenter

            Text {
                id: rowLabel
                objectName: "rowLabel"
                text: "Row: "
                font.pixelSize: fontSize
            }

            TextEdit {
                id: rowEdit
                objectName: "rowEdit"

                property int value: Number(text)

                text: "0"
                width: (root.width) / 5
                font.pixelSize: fontSize

                onValueChanged: {
                    console.log("row changed: " + value);
                    requestResult();
                }
            }

            Text {
                id: columnLabel
                objectName: "columnLabel"
                text: "Column: "
                font.pixelSize: fontSize
            }

            TextEdit {
                id: columnEdit
                objectName: "columnEdit"

                property int value: Number(text)

                text: "0"
                width: (root.width) / 5
                font.pixelSize: fontSize

                onValueChanged: {
                    console.log("column changed: " + value);
                    requestResult();
                }
            }
        }
    }
}
