// SPDX-FileCopyrightText: 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import QtQuick 2.0
import Sailfish.Silica 1.0

Page {
    objectName: "mainPage"
    allowedOrientations: Orientation.All

    function requestResult() {
        resultText.text = "Loading...";
        worker.sendMessage({
                               row: rowEdit.value,
                               column: columnEdit.value
                           });
    }

    WorkerScript {
        id: worker
        source: "../js/worker.js"

        onMessage: {
            if (messageObject.row === rowEdit.value
                    && messageObject.column === columnEdit.value) {
                if (!messageObject.result)
                    resultText.text = "Column must be <= Row and both must be positive or zero";
                else
                    resultText.text = messageObject.result;
            }
        }
    }

    Column {
        objectName: "layout"
        width: parent.width

        PageHeader {
            objectName: "pageHeader"
            title: qsTr("WorkerScript example")
        }

        Label {
            id: resultText
            objectName: "resultText"
            width: parent.width
            wrapMode: Text.WordWrap
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            font.pixelSize: Theme.fontSizeLarge
        }

        Row {
            objectName: "inputLayout"
            anchors.horizontalCenter: parent.horizontalCenter

            Label {
                id: rowLabel
                objectName: "rowLabel"
                text: "Row: "
                font.pixelSize: Theme.fontSizeLarge
            }

            TextField {
                id: rowEdit
                objectName: "rowEdit"

                property int value: Number(text)

                text: "0"
                width: (root.width) / 5
                font.pixelSize: Theme.fontSizeLarge
                inputMethodHints: Qt.ImhDigitsOnly

                onValueChanged: {
                    console.log("row changed: " + value);
                    requestResult();
                }
            }

            Label {
                id: columnLabel
                objectName: "columnLabel"
                text: "Column: "
                font.pixelSize: Theme.fontSizeLarge
            }

            TextField {
                id: columnEdit
                objectName: "columnEdit"

                property int value: Number(text)

                text: "0"
                width: (root.width) / 5
                font.pixelSize: Theme.fontSizeLarge
                inputMethodHints: Qt.ImhDigitsOnly

                onValueChanged: {
                    console.log("column changed: " + value);
                    requestResult();
                }
            }
        }
    }
}
