// SPDX-FileCopyrightText: 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import QtQuick 2.0
import Sailfish.Silica 1.0
import Nemo.Notifications 1.0

Page {
    objectName: "MainPage"
    allowedOrientations: Orientation.All

    Notification {
        id: notification
        objectName: "notification"
        category: "x-nemo.example"
        appName: "Example App"
        summary: "Notification summary"
        body: "Notification body"
        previewSummary: "Notification preview summary"
        previewBody: "Notification preview body"
        itemCount: 5
        timestamp: "2013-02-20 18:21:00"

        onClicked: console.log("Notification clicked")
        onClosed: console.log("Notification closed, reason: " + reason)
    }

    PageHeader {
        objectName: "header"
        title: "Notifications"
    }

    Column {
        id: layout
        objectName: "layout"
        spacing: Theme.paddingLarge
        anchors {
            left: parent.left
            right: parent.right
            verticalCenter: parent.verticalCenter
        }

        Label {
            objectName: "idLabel"
            text: "Notification ID %1".arg(notification.replacesId)
            anchors { left: parent.left; right: parent.right; margins: Theme.horizontalPageMargin }
            color: Theme.highlightColor
        }

        Button {
            objectName: "publishButton"
            text: "Publish notification"
            anchors { horizontalCenter: parent.horizontalCenter }
            onClicked: notification.publish()
        }
    }
}
