// SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: CC-BY-4.0

import QtQuick 2.6
import Sailfish.Silica 1.0
import QtMultimedia 5.6
import Multimedia 1.0
import "../assets"

Page {
    property string filePath: StandardPaths.documents + "/" + Qt.application.name + ".wav"

    AudioRecorder {
        id: audioRecorder
        outputLocation: filePath
        // ToDo: handle stop to reload audioPlayer
    }
    Audio {
        id: audioPlayer
        source: filePath
        autoLoad: true
    }
    Column {
        anchors.fill: parent
        spacing: Theme.paddingLarge

        PageHeader { title: qsTr("Dictaphone") }
        ValueDisplay {
            id: recordInfo
            label: qsTr("Recorded duration")
            // ToDo: set text property to show recorded duration in seconds
            width: parent.width
        }
        Slider {
            id: playInfo
            label: qsTr("Player position")
            width: parent.width
            // ToDo: set value, minimumValue, maximumValue and valueText properties
            enabled: false
            down: true
            handleVisible: false
        }
    }
    Row {
        id: buttonsRow
        anchors {
            horizontalCenter: parent.horizontalCenter
            bottom: parent.bottom
            bottomMargin: Theme.paddingLarge
        }
        spacing: Theme.paddingLarge

        // ToDo: add button to start recording
        // ToDo: add button to pause recording
        // ToDo: add button to stop recording
        // ToDo: add button to start playing
        // ToDo: add button to pause playing
        // ToDo: add button to stop playing

        // ToDo: control buttons visibility
    }
}
