// SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: CC-BY-4.0

import QtQuick 2.0
import QtMultimedia 5.6
import QtQuick.Controls 2.4

Item {
    width: 640
    height: 480
    Flickable {
        anchors.fill: parent

        Video {
            id: player
            anchors.fill: parent
            source: "soundeffects/Aurora_Tun_Loop.mp4"
            onPositionChanged: positionSlider.value = position

            MouseArea {
                anchors.fill: parent
                onClicked: {
                    if (player.playbackState === MediaPlayer.PlayingState)
                        player.pause();
                    else
                        player.play();
                }
            }
        }
        Button {
            text: "Start"
            onClicked: {
                if (player.playbackState === MediaPlayer.PlayingState)
                    player.pause();
                else
                    player.play();
            }
        }
        Slider {
            id: positionSlider
            anchors {
                left: parent.left;
                right: parent.right
                bottom: parent.bottom
                bottomMargin: 30
            }
            from: 0
            to: player.duration || 1
            onMoved: player.seek(value)
        }
    }
}
