// SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: CC-BY-4.0

import QtQuick 2.0
import Sailfish.Silica 1.0

Page {
    objectName: "mainPage"
    allowedOrientations: Orientation.All

    SilicaListView {
        id: sensorsListView
        anchors.fill: parent
        header: PageHeader { title: qsTr("Multimedia") }
        delegate: ListItem {
            onClicked: pageStack.push(Qt.resolvedUrl('./%1Page.qml'.arg(model.page)));

            Label {
                text: model.name
                anchors {
                    verticalCenter: parent.verticalCenter
                    left: parent.left
                    right: parent.right
                    margins: Theme.horizontalPageMargin
                }
                color: highlighted ? Theme.highlightColor : Theme.primaryColor
            }
        }
        model:  ListModel {
            ListElement {
                name: qsTr("Sound Effect")
                page: "SoundEffect"
            }
            ListElement {
                name: qsTr("Video player")
                page: "VideoPlayer"
            }
            ListElement {
                name: qsTr("Playlist")
                page: "Playlist"
            }
            ListElement {
                name: qsTr("Dictaphone")
                page: "Dictaphone"
            }
            ListElement {
                name: qsTr("Photo Camera")
                page: "PhotoCamera"
            }
        }
    }
}
