// SPDX-FileCopyrightText: Copyright 2023-2025 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: CC-BY-4.0

import QtQuick 2.0
import Sailfish.Silica 1.0

Page {
    objectName: "mainPage"
    allowedOrientations: Orientation.All

    Label {
        id: answer
    }

    SilicaFlickable {
        id: flickable
        anchors.bottom: parent.bottom
        anchors.top: answer.bottom
        anchors.horizontalCenter: parent.horizontalCenter
        width: 320
        ListView {
            id: view
            anchors.fill: parent
            delegate: Label {
                width: view.width
                horizontalAlignment: Text.AlignHCenter
                text: modelData.title
            }
        }

        function requestPhotos() {
            var xhr = new XMLHttpRequest();
            xhr.responseType = 'json';
            xhr.onreadystatechange = function() {
                if (xhr.readyState === XMLHttpRequest.HEADERS_RECEIVED) {
                    print('HEADERS_RECEIVED')
                } else if(xhr.readyState === XMLHttpRequest.DONE) {
                    print('DONE')
                    var json = JSON.parse(xhr.responseText)
                    view.model = json;
                    print(json[0].title)
                }
            }
            xhr.open("GET", "https://jsonplaceholder.typicode.com/photos");
            xhr.send();
        }
        function requestUser() {
            var xhr = new XMLHttpRequest();
            xhr.responseType = 'json';
            xhr.onreadystatechange = function() {
                if(xhr.readyState === XMLHttpRequest.DONE) {
                    print('DONE')
                    var json = JSON.parse(xhr.responseText)
                    answer.text = "id = %1, timestamp %2".arg(json.id).arg(json.createdAt);
                    print(xhr.responseText)
                }
            }
            xhr.open("POST", "https://reqres.in/api/users");
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            xhr.setRequestHeader("x-api-key","reqres-free-v1");
            var body = 'name=' + encodeURIComponent("morpheus") +
                    '&job=' + encodeURIComponent("leader");
            xhr.send(body);
        }

        Component.onCompleted: {
            requestPhotos();
            requestUser();
        }
    }
}
