// SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause
import QtQuick 2.0
import Sailfish.Silica 1.0
import Aurora.Controls 1.0

Page {
    allowedOrientations: Orientation.All
    SplitView {
        id: splitView

        anchors.fill: parent
        splitter: Rectangle {
            color: Theme.rgba(Theme.highlightColor, Theme.opacityLow)
            width: 2
        }

        Component.onCompleted: splitView.push(mainView)
    }

    Component {
        id: mainView

        Item {
            id: root

            Column {
                width: parent.width
                spacing: Theme.paddingLarge

                PageHeader { title: qsTr("Страница %1".arg(root.SplitView.index + 1)) }

                Button {
                    text: qsTr("Следующая страница")
                    anchors.horizontalCenter: parent.horizontalCenter
                    onClicked: splitView.push(mainView)
                }

                Button {
                    text: qsTr("Предыдущая страница")
                    anchors.horizontalCenter: parent.horizontalCenter
                    onClicked: splitView.pop()
                }
            }
        }
    }
}
