// SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <edu@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause
import QtQuick 2.0
import Sailfish.Silica 1.0
import Aurora.Controls 1.0

Page {
    allowedOrientations: Orientation.All
    Button {
        onClicked: popup.open()

        anchors.centerIn: parent
        text: qsTr("Выбрать")

        PopupMenu {
            id: popup

            PopupSubMenuItem {
                text: qsTr("Редактировать")
                icon.source: "image://theme/icon-m-edit"

                PopupMenuItem { text: qsTr("Копировать") }
                PopupMenuItem { text: qsTr("Вырезать") }
                PopupMenuDividerItem {}
                PopupMenuItem { text: qsTr("Вставить") }
            }

            PopupMenuDividerItem {}

            PopupMenuItem {
                text: qsTr("Печать документа")
                hint: qsTr("Выберите принтер и распечатайте документ")
                icon.source: "image://theme/icon-m-print"
            }

            PopupMenuDividerItem {}

            PopupMenuItem {
                text: qsTr("Удаление документа")
                hint: qsTr("Удаление текущего документа")
                icon.source: "image://theme/icon-m-delete"
            }
        }
    }
}
