# WebRTC

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Общение в реальном времени без плагинов

Библиотека WebRTC обеспечивает передачу аудио и видео данных (звонков) между браузерами. Стандарт WebRTC определяет набор ECMAScript API, позволяющих обмениваться медиа и произвольными данными с другим браузером или устройством, поддерживающим соответствующий набор протоколов реального времени.

Возможности WebRTC:

*	Получение потокового аудио, видео или других данных.
*	Получение информации о сети, такую ​​как IP-адреса и порты, и обмен ею с другими клиентами WebRTC (известными как одноранговые), чтобы разрешить соединение, даже через NAT и брандмауэры.
*	Координация передачи сигналов для сообщения об ошибках и запуска или закрытия сеансов.
*	Обмен информацией о мультимедиа и клиентских возможностях, таких как разрешение и кодеки.
*	Общение с помощью потокового аудио, видео или данных.

## Архитектура WebRTC

WebRTC в том виде, в котором он реализован в настоящее время, поддерживает только обмен данными типа один-к-одному, но может использоваться в более сложных сетевых сценариях: например, с несколькими одноранговыми узлами, каждый из которых связывается друг с другом напрямую, одноранговым или через многоточечный блок управления (MCU).

RTCPeerConnection — это компонент WebRTC, который обеспечивает стабильную и эффективную передачу потоковых данных между узлами.
На слайде приведена диаграмма архитектуры WebRTC, показывающая роль RTCPeerConnection.
Кодеки и протоколы, используемые WebRTC, выполняют работу, чтобы сделать возможной связь в режиме реального времени, даже в ненадежных сетях.

## WebRTC в ОС Аврора

Для использования WebRTC в проекте её следует подключить по имени libwebrtc в конфигурационном файле, а также в spec-файле:
BuildRequires: pkgconfig(libwebrtc).

Далее библиотеку можно подключать в C++-код, указывая необходимые классы и их модули. Например:
#include "media/engine/webrtc_media_engine.h".

Для ОС Аврора доступен пример WebRTC.
Приложение на C++ демонстрирует аудио/видеовызовы WebRTC.
