# Захват видео в StreamCamera

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Библиотека StreamCamera

StreamCamera — это библиотека на основе плагинов для доступа к необработанным видеоданным с камеры и аппаратных кодировщиков и декодеров. У неё очень ограниченный интерфейс, и её следует рассматривать как дополнение к приложениям для видеоконференций.

Пример работы со StreamCamera в ОС Аврора: https://developer.auroraos.ru/demos/stream-camera.

## Классы StreamCamera

В библиотеке имеется пространство имён Aurora::StreamCamera.

Классы StreamCamera:

Camera — камера
CameraListener — обратные вызовы для камеры
CameraManager — управление камерой
CodecManager — управление кодеком
GraphicBuffer — дескриптор графического буфера
VideoDecoder — видеодекодер
VideoDecoderListener — обратные вызовы для видеодекодера
VideoEncoder — видеокодер
VideoEncoderListener — обратные вызовы для видеокодера
VideoOutputQt5 — привязка к Qt5/QML VideoOutput

## Пример использования CameraListener

В примере реализуется класс CameraListener.
onCameraFrame() вызывается при захвате графического буфера.
Метод вызывается в другом потоке. Время, затрачиваемое на эту функцию, должно быть сведено к минимуму.

## Пример использования CameraManager

CameraManager — диспетчер камеры.
С его помощью подгружается информация о доступной камере и создаётся объект камеры.

Структура CameraInfo содержит информацию о камере.
Данная информация позволяет создать объект класса Camera.

## ScreenGrab

Библиотека ScreenGrab API обеспечивает захват экрана в виде статических картинок.
Для использования ScreenGrab API было добавлено новое значение в перечисления CameraFacing: CameraFacing::Screen.
На данный момент захват экрана возможен только через StreamCamera API.

У приложения должно быть разрешение ScreenCapture, иначе такие записи не будут отображаться в списке.

Пример работы со ScreenGrab API в ОС Аврора: https://developer.auroraos.ru/demos/screen-grab.
