# Захват видео в QtMultimedia

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## CameraRecorder — запись видео с камеры

CameraRecorder позволяет записывать потоки с камеры в файлы, а также настраивать параметры записи и метаданные для видео.

Не следует создавать его отдельно, вместо этого следует использовать свойство videoRecorder объекта Camera.

Существует множество различных настроек для каждого этапа процесса записи (аудио, видео и выходные форматы), а также управление отключением звука и местом сохранения выходного файла.

Свойства:

*	actualLocation : string — фактическое местоположение последнего сохранённого медиаконтента. Фактическое местоположение обычно доступно после начала записи и сбрасывается при установке нового местоположения или начале новой записи.
*	outputLocation : string — целевое местоположение медиаконтента. Если местоположение пусто, регистратор использует системное местоположение и схему именования файлов.
*	audioChannels : int — количество аудиоканалов, которые будут кодироваться при записи видео (1 — моно, 2 — стерео).
*	duration : int — длительность (в миллисекундах) последней записи.
*	resolution : size — размеры видеокадра, используемые для захвата видео.
*	audioCodec : string — аудиокодек, используемый для записи видео. Обычно это aac или amr-wb.
*	errorCode : enumeration — код последней ошибки.

Методы:

record()
Начинает запись.
setMetadata(key, value)
Задаёт метаданные для следующего записываемого видео, при этом заданный ключ связывается со значением.
stop()
Останавливает запись.

## Пример настройки записи камеры

На слайде приведён пример настройки записи камеры.

audioEncodingMode — тип метода кодирования, используемый при записи звука.
ConstantBitRateEncoding — при кодировании будет использоваться постоянный битрейт, качество будет регулироваться в зависимости от размера файла. Это подходит для оптимизации пространства.

audioBitRate содержит битрейт звука (в битах в секунду), используемый при записи видео.

mediaContainer содержит медиаконтейнер, используемый для записи видео. Обычно это mp4.
