# Процесс перевода

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Основы Qt Linguist

Qt предоставляет отличную поддержку для перевода приложений Qt C ++ и Qt Quick на локальные языки.
Можно использовать инструмент lupdate для синхронизации исходного кода и переводов и инструмент
lrelease для создания файлов перевода во время выполнения для использования выпущенным приложением.
Использовать инструмент Qt Linguist можно для перевода текста в приложениях.
Не требуется знание компьютера, кроме возможности запуска программы и использования текстового
редактора или текстового процессора.
Можно создавать приложения Qt, которые могут использовать переведенный текст.
Для перевода также необходимо определить контекст, в котором появляются фразы.

## Обзор процесса перевода

Большая часть текста, который должен быть переведен в приложении, состоит из отдельных слов
или коротких фраз.
Обычно они отображаются в виде заголовков окон, пунктов меню, всплывающих подсказок и меток
для кнопок, флажков и переключателей.
Фразы вводятся в исходный код разработчиком на их родном языке с использованием простого,
но специального синтаксиса, чтобы определить, что фразы требуют перевода.
Инструменты Qt предоставляют контекстную информацию для каждой фразы, чтобы помочь переводчику,
и разработчик может добавлять дополнительную контекстную информацию к фразам, когда это необходимо.

Сначала генерируется набор файлов перевода, которые создаются из исходных файлов, они передаются переводчику.
Переводчик открывает файлы перевода с помощью Qt Linguist, вводит их переводы и сохраняет результаты
обратно в файлы перевода.
Затем нужно сгенерировать быстрые компактные версии этих файлов перевода, готовые для использования приложением.
Инструменты предназначены для использования в повторяющихся циклах по мере изменения и развития
приложений, сохраняя существующие переводы и позволяя легко определить, какие новые переводы требуются.
Qt Linguist также предоставляет словарь фраз, чтобы помочь обеспечить согласованные переводы между
несколькими приложениями и проектами.

## Отдельные трудности перевода

Переводчики и разработчики должны решить ряд вопросов из-за тонкостей и сложностей человеческого языка:

*	Отдельная фраза может нуждаться в переводе в несколько различных форм в зависимости от контекста.
	Например, open на английском языке может стать öffnen, «открытый файл» или aufbauen, 
	«открытое подключение к Интернету» на немецком языке.
*	Фразы, которые содержат переменные, например, «25 выбранных файлов будут обрабатываться
	63 секунды», где два числа вставляются программно во время выполнения, возможно, потребуется
	перефразировать, потому что на другом языке порядок слов и, следовательно, размещение
	переменных могут измениться.

Инструменты перевода Qt предоставляют ясные и простые решения этих проблем.

## Координация разработки и перевода

Для координации разработки и перевода предусмотрены два инструмента: lupdate и lrelease.
Эти инструменты могут обрабатывать файлы проекта qmake или работать напрямую с файловой системой.

## Создание файлов перевода

Файлы перевода состоят из всего видимого пользователем текста и переводов этого текста.

Для создания файлов перевода:

1.	Запустите lupdate, чтобы сгенерировать первый набор файлов источника перевода (TS) со всем
	видимым пользователем текстом, но без переводов.
2.	Передайте файлы TS переводчику, который добавляет переводы с помощью Qt Linguist.
	Qt Linguist заботится о любом измененном или удаленном исходном тексте.
3.	Запустите lupdate, чтобы включить любой новый текст, добавленный в приложение.
	lupdate синхронизирует видимый пользователем текст из приложения с переводами.
	Это не разрушает никакие данные.
4.	Чтобы выпустить приложение, запустите lrelease, чтобы прочитать файлы TS и создать файлы QM,
	используемые приложением во время выполнения.

Чтобы lupdate работал успешно, он должен знать, какие файлы перевода создавать.
Файлы перечислены в файле проекта .pro Qt приложения.

## Использование lupdate

Использование: lupdate myproject.pro

Инструмент командной строки lupdate находит переводимые строки в указанных файлах исходного кода,
заголовка и интерфейса Qt Designer, а также создает или обновляет файлы перевода .ts.
Файлы для обработки и файлы для обновления могут быть заданы в командной строке или предоставлены
в файле .pro, указанном в качестве аргумента командной строки.
Разработчик создает файл .pro.

Созданные файлы перевода передаются переводчику, который использует Qt Linguist для чтения файлов
и вставки переводов.
Компании, которые имеют своих собственных переводчиков, могут посчитать полезным регулярно
запускать lupdate, возможно, ежемесячно, по мере разработки приложения.
Это приведет к довольно низкому объему переводческой работы, равномерно распределенному по жизни
проекта, и позволит переводчикам одновременно поддерживать несколько проектов.

Компании, нанимающие переводчиков по мере необходимости, могут предпочесть запускать lupdate
всего несколько раз в течение жизненного цикла приложения.
Первый раз может быть перед первым этапом тестирования.
Это обеспечит переводчику существенный единичный блок работы, и любые ошибки, которые обнаружит
переводчик, могут быть легко включены с найденными на начальном этапе тестирования.
Второй и любой последующий прогон lupdate, вероятно, будет иметь место во время финальной бета-фазы.

## Формат файла TS

Формат файла TS - это простой читаемый человеком формат XML, который при необходимости
может использоваться с системами контроля версий. 

lupdate также может обрабатывать файлы формата Localization Interchange File Format (XLIFF); 
Файлы в этом формате обычно имеют имена файлов, заканчивающиеся суффиксом .xlf.
XLIFF (англ. XML Localization Interchange File Format) — расширяемый платформенно-независимый
стандарт обмена локализуемыми данными и сопутствующей информацией, основанный на языке разметки XML.
Это позволяет использовать инструменты и службы перевода, работающие с этим форматом.

Минимальная поддерживаемая версия для файлов формата XLIFF - 1.1.
Файлы версии XLIFF 1.0 не поддерживаются.

## Использование lrelease

Использование: lrelease myproject.pro.

Инструмент командной строки lrelease создает файлы QM из файлов TS.
Формат файла QM - это компактный двоичный формат, используемый локализованным приложением.
Это обеспечивает чрезвычайно быстрый поиск переводов.
Процессы TS файлов lrelease могут быть указаны в командной строке или предоставлены косвенно
в файле проекта Qt .pro.
Этот инструмент запускается при каждом выпуске приложения, от начальной тестовой версии
до финальной версии выпуска.
Если файлы QM не созданы, например, из-за того, что перед выполнением какого-либо перевода
требуется альфа-релиз, приложение будет отлично работать с использованием текста, размещенного
разработчиками в исходных файлах.
Как только файлы QM станут доступны, приложение обнаружит их и автоматически использует.

## Переводы для lrelease

Инструмент lrelease включает только переводы, помеченные как «готовые».
В противном случае используется оригинальный текст.

И lupdate, и lrelease могут использоваться с исходными файлами перевода TS, которые являются неполными.
Пропущенные переводы будут заменены фразами на родном языке во время выполнения.

## Руководство по Qt Linguist: Разработка

Поддержка нескольких языков чрезвычайно проста в приложениях Qt и добавляет небольшие накладные
расходы на рабочую нагрузку разработчика.
Qt минимизирует затраты производительности при использовании переводов, переводя фразы для каждого
окна или страницы по мере их создания.
В большинстве приложений главное окно создается только один раз.
Диалоги часто создаются один раз, а затем показываются и скрываются по мере необходимости.
Как только начальный перевод выполнен, затрат на перевод больше не будет.
Только те страницы, которые созданы, уничтожены и впоследствии созданы заново,
будут также заново тратить ресурсы на перевод.

## Указание источников перевода

Чтобы использовать lupdate и lrelease, правильно напишите файл проекта .pro Qt.
Должна быть запись в разделе TRANSLATIONS файла проекта для каждого языка, который является
дополнительным к родному языку.

Использование локали в имени файла перевода полезно для определения того, какой язык
загружать во время выполнения.

Инструмент lupdate извлекает строки пользовательского интерфейса из вашего приложения.
Он читает файл .pro приложения, чтобы определить, какие исходные файлы содержат текст для перевода.
Это означает, что ваши исходные файлы должны быть перечислены в записи SOURCES или HEADERS
в файле .pro или в файлах ресурсов, перечисленных в записи RESOURCE.
Если ваших файлов нет в списке, текст в них не будет найден.

## Указание источников перевода в pro-файле

Пример файла .pro с четырьмя исходными файлами перевода.

## Общие правила

Разработайте свое приложение так, чтобы оно могло быть адаптировано к различным языкам
и регионам без технических изменений.
Qt пытается сделать интернационализацию максимально безболезненной для вас.
Все элементы управления вводом и методы рисования текста в Qt предлагают встроенную поддержку
для всех поддерживаемых языков.
Но вам все равно нужно помнить следующее при написании исходного кода для вашего приложения:

*	Сделайте так, чтобы ваше приложение искало и загрузило соответствующий файл перевода.
*	Отметьте тексты, видимые пользователем, в качестве целей для перевода.
*	Укажите контекст для текста, который нужно перевести.
*	Избавьтесь от неопределенностей в идентичных текстах.
*	Используйте пронумерованные аргументы (% n) в качестве заполнителей для параметров,
	которые заменяются текстом или числами во время выполнения.
*	Интернационализируйте числа, даты, время и валюты.
*	Отметьте текстовые строки данных вне функций перевода.

Вы можете разрабатывать приложения, которые используют источники C ++ и QML в одном приложении
и даже иметь строки пользовательского интерфейса в обоих источниках.
Инструменты создают один объединенный файл перевода, и строки доступны из C ++ и QML.

Каждый фрагмент текста, требующий перевода, требует контекста, чтобы помочь переводчику определить,
где в программе появляется текст.
В случае нескольких идентичных текстов, которые требуют разных переводов, переводчик также требует
некоторой информации для устранения неоднозначности исходных текстов.
Пометка текста для перевода автоматически приведет к тому, что имя класса будет использоваться
в качестве базовой контекстной информации.
В некоторых случаях разработчику может потребоваться добавить дополнительную информацию,
чтобы помочь переводчику.

## Развертывание переводов

Файлы .qm, необходимые для приложения, должны быть размещены в месте, где их может найти код
загрузчика с помощью QTranslator.
Как правило, это делается путем указания пути относительно QCoreApplication::applicationDirPath().

Обычно для приложения существуют файлы .qm, и, если используется версия Qt, которая не установлена
​​в системе, необходимо также развернуть файлы Qt .qm.

Однако нет необходимости всегда развертывать все файлы Qt 5 .qm.
Мы рекомендуем объединить файлы .qm модулей, необходимых для одного файла, совпадающего с именем
файла мета-каталога, используя инструмент lconvert на этапе развертывания.
