# Theme

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Размеры элементов в Silica

Для создания приложения в едином стиле интерфейса ОС Аврора стоит не только использовать компоненты
библиотеки Silica, но и устанавливать размеры элементов, шрифтов, отступов от границ, а также цвета
в соответствии с общими рекомендациями.

Для этого предназначен компонент Theme.
Он предоставляет информацию общего стиля для приложений и компонентов пользовательского интерфейса.
Важно заметить, что это синглтон, к нему можно обращаться, но нельзя создать отдельный тип Theme.

Стандартные размеры элементов содержаться в свойствах, указанных на слайде.
Размер элемента можно указать от очень маленького до гигантского.
Не рекомендуется часто использовать как слишком маленькие, так и слишком большие размеры
для элементов, содержащих текст. 

ExtraSmall - это размер стандартной кнопки, размер Small равен, например высоте стандартного
элемента списка с одной строкой текста.
Large размер используется в качестве высоты стандартного заголовка страницы, а размеры ExtraLarge
и Huge подходят для элементов, содержащих изображения. 

## Размеры шрифтов в Silica

В приложениях для ОС Аврора стандартно используются два семейства шрифтов:
одно для различных заголовков и одно для всех остальных надписей.
Узнать нужное семейство шрифтов можно с помощью свойств fontFamilyHeading и fontFamily компонента Theme.

Аналогично размерам элементов можно присвоить стандартные значения размеру шрифтов.
Для этого один из вариантов на слайде необходимо присвоить свойству font.pixelSize. 

Medium - стандартный размер шрифта, используемый в элементах ввода или вывода текста.
Меньшие размеры предназанчены для второстепенной информации, например в описаниях элементов или метках. 

Большие размеры, в основном используются для заголовков, важных уведомлений или объявлений,
к которым необходимо привлечь внимание. 

## Цвета в Silica

Помимо размеров при создании интерфейса можно использовать системные цвета.
Это позволит стилизовать интерфейс приложения, а также заменять цвета в зависимости
от смены атмосферы.
Компонент Theme содержит несколько параметров, возвращающих стандартные цвета. 

Для текста и графических элементов используют primaryColor, чтобы подчеркнуть активные элементов
и secondaryColor для менее значимых частей интерфейсов. 

Для того, чтобы выделить интерактивные элементы в нажатом состоянии используется highlightColor
или более приглушенный secondaryHighlightColor.
Активная подсветка фона достигается при значении highlightBackgroundColor, а highlightDimmerColor
используется в случае, когда нужно подсветить элемент, но не отвлекать внимание
от остальной части интерфейса.

Настроить прозрачность выделяемого фона можно с помощью свойства rgba, в качестве аргументов
выступают значения подсветки фона и значение прозрачности. 

С помощью colorScheme можно узнать цветовую схему.
Её детали определяются текущей атмосферой ОС Аврора.
Для цветовой схемы DarkOnLight текст и значки раскрашиваются темным цветом на светлом фоне.
Для цветовой схемы LightOnDark содержимому подбирается светлые цвета на темном фоне.

## Отступы в Silica

Отступы являются важным аспектом разработки графического интерфейса приложений,
особенно на мобильных платформах, где иногда возникают сложности с правильной компоновкой
элементов.
Слишком большой отступ между элементами отнимет ценное место на экране.
Слишком маленький отступ, наоборот может привести к тому, что, пользователь может случайно
нажать нежелательную кнопку, просто потому что она будет расположена слишком близко к нужной.

Компонент Theme предоставляет следующие параметры для получения размеров стандартных отступов:

*	horizontalPageMargin — используется для установки расстояния между содержанием страницы
	и левым и правым краями экрана.
*	paddingSmall — самое маленькое расстояние между элементами интерфейса.
	Часто используется в случаях, когда место на экране ограничено.
*	paddingMedium — используется для установки расстояния между элементами интерфейса,
	которые связаны друг с другом по смыслу и поэтому визуально должны быть «вместе».
*	paddingLarge — обычно используется для установки расстояния между элементами интерфейса.

## Иконки действий

Разберем более подробно иконки, которые используются в приложениях.

Аврора SDK включает в себя набор стилизованных иконок, которые можно использовать для создания
цельного UI приложения.
Эти иконки соответствуют определенным размерам— Small, Medium и Large.

## Размеры иконок

Иконки маленького размера не рекомендуется использовать как кликабельный элемент.
Они используются в совокупности с текстом или в качестве индикации.

*	Theme.iconSizeExtraSmall — самый маленький размер, который используется, например,
	для значков в строке состояния;
*	Theme.iconSizeSmall — размер, который используется для маленьких значков, например,
	для значков CoverAction и значков на экране событий;
*	Theme.iconSizeSmallPlus — чуть больший вариант iconSizeSmall, который используется, например,
	для значков уведомлений;
*	Theme.iconSizeMedium — самый часто используемый размер (может быть применен, например,
	для значков внутри маленьких и средних элементов списка);
*	Theme.iconSizeLarge — большой размер, который используется, например, для значков на кнопках;
*	Theme.iconSizeExtraLarge — самый большой размер значков;
*	Theme.iconSizeLauncher — размер, который используется для значков в сетке приложений
	на домашнем экране.
