# Навигация

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## ApplicationWindow — точка входа [1]

ApplicationWindow - это верхнеуровневый компонент приложения, который является точкой входа в него.
У каждого приложения может быть только один объект этого типа. 

## ApplicationWindow — точка входа [2]

ApplicationWindow позволяет указать первую загружаемую страницу приложения, управлять стеком
страниц, устанавливает обложку приложения, задает фоновое изображение и управляет ориентацией
приложения на экране. 

С помощью свойства allowedOrientations можно задать как определенную ориентацию - портретная,
ландшафтная или их инвертированные версии, так и их маски или разрешить все доступные ориентации.
Поскольку элементы интерфейса организованы иерархично, ориентации отдельных страниц будут зависеть
от разрешенной ориентации элемента AplicationWindow. 

## Page — страница приложения [1]

Тип Page представляет собой контейнер для содержимого одного экрана приложения.
Его свойства ширины и высоты автоматически подстраиваются под размеры контента.
Ориентация отдельной страницы зависит от ориентации всего приложения, поэтому если
в ApplicationWindow заданы все возможные ориентации, мы можем ограничить ориентацию отдельной
страницы, но не наоборот.
По умолчанию для страницы задана портретная ориентация. 

Помимо ориентации, мы можем управлять навигацией страницей, например, разрешить или запретить
переход к следующим или предыдущим страницам, а также задать направление переключения: вертикальное
или горизонтальное. 

Свойство статус содержит актуальный статус страницы, загружаемый в стеке страниц.
На слайде пример кода, позволяющий отследить текущий статус страницы. 

## Page — страница приложения [2]

При нажатии на кнопку мы загружаем следующую страницу приложения.
Во время перехода статус страницы Activating, а при загрузке статус меняется на Active. 

## Заголовок страницы

Элемент PageHeader предоставляет стилизованный заголовок страницы.
Он располагается в правом верхнем углу страницы.
Значение title содержит отображаемый текст заголовка.

## Примеры PageHeader

Кроме этого можно указать описание страницы в свойстве description или добавить дополнительное
содержимое, например, иконку с помощью свойства extraContent.

## PageStack — контроль навигации

Контроль за навигацией между страницами осуществляет элемент PageStack.
Каждое приложение, состоящее из более одной страницы содержит единственный объект PageStack.
Окно приложения отображает страницу, находящейся на вершине стека. 

Поместить и извлечь страницу можно с помощью привычных операций push, pop.
С помощью свойств мы можем узнать глубину стека, какая страница находится в данный момент
на вершине и статус стека при анимации перехода страниц. 

Кроме этого есть возможность прикрепить страницу с помощью метода pushAttached(), то есть загрузить
ее, но не отобразить на экране.
Прикрепленную страницу можно извлечь методом popAttached, а также можно перемещаться по стеку
с помощью методов NavigateBack и NavigateForward. 

## Операции PageStack: push и pop

Давайте посмотрим на примере работу с методами стека.
В первом случае у нас загружена страница с единственной кнопкой, нажав на нее, мы обращаемся
к методу push элемента PageStack, загружаем в стек еще одну страницу и сразу же переходим на ее.
При загрузке второй страницы значение глубины стека становится равно двум.
Извлечь эту страницу из стека можно с помощью кнопки pop, а можно с помощью индикатора,
появляющегося в левом верхнем углу.
Он позволяет перейти на предыдущую страницу, извлекая тем самым, текущую страницу из стека. 

## Прикреплённые страницы

В следующем примере мы использовали метод pushAttached, с его помощью мы не загружаем новую
страницу на экран, а как бы готовим ее к загрузке.
Обратите внимание, что после нажатия кнопки индикатор перехода теперь появился и в правом верхнем
углу.
Нажав на него мы перейдем на прикрепленную страницу методом NavigateForward, и она появится в стеке. 

Метод NavigateBack не закрывает страницу, то есть индикатор перехода на нее сохраняется, однако
глубина стека в этом случае уменьшается, т.е. страница становится прикрепленной.

## Компоненты и объекты в стеке

В стек страниц можно добавлять как компоненты, так и объекты.

Например, новую страницу можно создать на основе имени файла и отправить на стек.
Эта операция каждый раз будет создавать новый объект.

Или можно один раз создать объект, обернув его в Component.
Тогда каждый раз при вызове push будет переиспользоваться существующий объект и его данные.
