# Масштабирование и вырезы

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Масштабирование элементов

Размеры экранов устройств отличаются, поэтому необходимо масштабировать элементы интерфейса
под конкретный размер текущего устройства.

Для масштабирования следует использовать элемент Theme.pixelRatio, который хранит количество
пикселей на экране устройства.
В примере мы задали размер экрана с учетом свойства pixelRatio для корректного масштабирования.
В Silica можно масштабировать элементы ещё и с помощью Theme.dp.

## Screen.sizeCategory — размеры экрана

Физические размеры экранов хранятся в свойстве SizeCategory типа Screen, размер Small используется
для стандартного смартфона, а Large для стандартного планшета. 

В зависимости от размера экрана можно либо подобрать нужный размер элемента, как в примере
мы выбираем размер шрифта для Label, либо загрузить нужную страницу, где элементы скомпонованы
в подходящем порядке для конкретного размера экрана. 

## Работа с вырезами

Системный вырез — это область на некоторых устройствах, которая обеспечивает место для камеры
или датчиков на передней панели устройства.
В ОС Аврора доступны следующие варианты взаимодействия с механизмом системных вырезов:

*	Выбрать режим отображения приложения.
	В этом случае все страницы приложения автоматически адаптируются под состояние устройства
	согласно с выбранным режимом.
*	Напрямую получать значения безопасной зоны и компонентов, с которыми возможна коллизия.
	В этом случае приложение должно самостоятельно управлять корректным размещением своих
	компонентов на экране.

## safeZone — безопасная зона

По умолчанию страницы приложения располагаются в safeZone, прямоугольной области экрана,
не содержащей коллизий.
Это обеспечивает совместимость с приложениями, которые были написаны без учёта вырезов.
Но при разработке нового приложения или адаптации существующего стоит учитывать, что приложение
в safeZone может выглядеть не так естественно и красиво, как полноэкранные приложения.

ApplicationWindow также предоставляет свойство safeZone, содержащее обеъект типа Item,
координаты и размеры которого совпадают с безопасной зоной отображения приложения.
Его следует использовать для сценариев, когда необходимо работать с полным окном приложения.

## Выбор режима отображения

Настроить поведение можно с помощью свойства displayMode объекта типа ApplicationWindow.
Различные режимы позволяют управлять видом отображения и размером окна приложения
с учётом ориентации устройства:

ApplicationDisplayMode.FullPortrait
В портретном режиме страницы приложения занимают весь экран, в ландшафтном — с отступом на высоту выреза. Отступ закрашивается чёрным цветом.

ApplicationDisplayMode.FillScreen
Страницы приложения занимают весь экран.

ApplicationDisplayMode.SafeZone
Страницы приложения заполняют safeZone.
Является режимом по умолчанию.

## Вырезы: SafeZoneRect.insets

При размещении элементов управления в полноэкранных приложениях требуется учитывать скругления
и вырезы экрана.
Для этого служит объект SafeZoneRect.insets.
Он предоставляет свойства top, left, right и bottom, которые содержат отступы от границ экрана
до safeZone.

## Вырезы: SafeZoneRect.appinsets

Объект SafeZoneRect.appInsets аналогично SafeZoneRect.insets предоставляет свойства top, left,
right и bottom, но их значения не зависят от ориентации устройства.

## Взаимодействие со строкой состояния

Строка состояния — это визуальный элемент, предназначенный для отображения наиболее необходимой
системной информации и уведомлений. 
Высота строки состояния настраивается с помощью Theme.
Его включение или отключение происходит через свойства ApplicationWindow.

ApplicationWindow предоставляет следующие свойства для управления строкой состояния:

*	statusbarForceVisible позволяет принудительно включить или отключить отображение строки
	состояния, если установлен displayMode FullPortrait или FillScreen.
	По умолчанию имеет значение false .
*	statusbarOpacity- прозрачность фона строки состояния.
	По умолчанию имеет значение 0.0.
*	statusbarBackgroundColor - цвет фона строки состояния.
	По умолчанию имеет цвет Theme.overlayBackground .
*	statusbarScheme определяет, какая цветовая схема выбрана для иконок строки состояния.

Пример настройки строки состояния приведён на слайде.
