# Диалоги

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Dialog — страница подтверждения

Диалоги широко используются приложениями для взаимодействия с пользователем.

По сути, диалог - это обычная страница, в которой добавлена возможность подтверждать
или отменять свои действия.
В частности, они используются для ввода пользователем данных.
Отличительной чертой диалогов является наличие кнопок “Отменить” и “Подтвердить” в шапке экрана.
Вдобавок, диалоги обладают сигналами, которые вызываются при нажатии на эти кнопки.

Свойсто canAccept определяет, когда пользователь может подтвердить действия на странице,
например при корректном вводе всех данных анкеты.
Если это свойство принимает значение false, кнопка принятия диалога не подсвечивается
и не реагирует на нажатия.

Статус закрытия диалога передается в свойство result.

Метод open() используется для открытия диалога.
По умолчанию он отобразит диалог поверх текущей страницы с анимацией перехода.
Если первому параметру установить значение true, то диалог заменит текущую отображаемую страницу.
Если второму параметру установить значение true, то диалог откроется без анимации.

Методы accept() и reject() инициируют подтверждение и отмену соответственно.
Также они закрывают диалог. 
Метод close() закрывает диалог.

Действия пользователя испускают соответствующие сигналы.
Обработчик onOpened() будет вызван при открытии диалога, его можно использовать
при передаче начальных значений в диалог. 
onAccepted() и onRejected() будут вызваны при подтверждении и отмене пользователем диалога.
Сигнал onDone() полезен для разработчиков, будет перед закрытием диалога до вызова
onAccepted() и onRejected().

## DialogHeader — заголовок диалога

Тип DialogHeader является необходимым элементом, если на экране диалога нужны кнопки принятия
и отмены результата диалога. 

Заголовок диалога передается в свойстве title.
Кроме этого в DialogHeader можно настроить текст кнопок с помощью свойств acceptText и cancelText.
По умолчанию текст кнопок будет Cancel слева и Accept справа.
Важно не забыть, что какой бы текст в  кнопке мы не указали, права кнопка всегда будет отвечать
за принятие, а левая — за отмену.

С помощью extraContent в заголовок можно вставить дополнительный контекст.

## Пример диалога

Рассмотрим пример диалога, в котором пользователь задает заголовок.
Обратите внимание, что на верхней панели указан текст только для кнопки подтверждения диалога.
Если этот диалог является частью многостраничного приложения, нажатие левой кнопки все равно
означает отмену диалога и извлечет его из стека страниц, вернув на предыдущую. 

## Вызов диалога со страницы

Для того, чтобы отобразить диалог, его необходимо поместить на стек, как обычную страницу.
Вторым параметром передаётся объект со значениями свойств, которые необходимо проинициализировать
в диалоге.
Таким образом диалог в примере отобразится с уже заполненными полями. 

Диалог можно открывать по нажатию сенсорного элемента, например кнопки, как в данном примере.
Здесь обработчику кнопки onClicked мы задаем переменную dialog, с помощью которой загружаем
qml-файл с диалогом, а во втором аргументе передаем данные с текущей страницы, например свойству
name типа Dialog мы присваиваем значение заголовка текущей страницы. 

Необходимо сохранить созданный экземпляр диалога для того, чтобы на него можно было устанавливать
обработчики.
В данном примере обработчик представляет собой функцию, которая подключается к сигналу accepted.
Таким образом после принятия результата пользователем мы получаем данные из диалога, в нашем
примере это значение заголовка страницы, с которой мы подключались к диалогу.

## Выбор даты

DatePickerDialog представляет Dialog с интегрированным DatePicker, чтобы позволить пользователю
выбирать дату с помощью сетки календаря.

В диалоге над сеткой календаря отображается выбранная дата.
Если пользователь подтверждает выбор даты, свойства year, month, day и dateText задаются
в соответствии с выбранной датой, в противном случае эти значения остаются неизменными.

Если свойство date не задано либо задано как undefined, то при открытии диалога отобразится
страница выбора года.

DatePickerDialog предоставляет удобный для пользователя способ запроса значения даты
через интерфейс диалогового типа.
Если требуется, чтобы интерфейс имел вид сетки календаря без диалогового контейнера, то следует использовать DatePicker.

## Пример выбора даты

На слайде приведён простой пример диалога для выбора даты, открытого с помощью PageStack::push().

## Выбор времени

TimePickerDialog представляет Dialog с интегрированным TimePicker, чтобы позволить пользователю
выбирать время с помощью интерфейса циферблата.

В диалоге показывается выбранное время в центре циферблата.
Если пользователь подтверждает выбор времени, свойства hour, minute и timeText задаются
в соответствии с выбранным временем, в противном случае эти значения остаются неизменными.

hourMode : enumeration управляет диапазоном допустимых значений для свойства hour.
Данное свойство может принимать значение одного из следующих типов:

*	DateTime.DefaultHours — используется 24-часовой либо 12-часовой формат исчисления времени в зависимости от системных настроек устройства. Значение по умолчанию;
*	DateTime.TwentyFourHours — 24-часовой формат. Диапазон допустимых значений для свойства hour составляет 0–23;
*	DateTime.TwelveHours — 12-часовой формат. Диапазон допустимых значений для свойства hour составляет 0–12.

TimePickerDialog предоставляет удобный для пользователя способ запроса значения времени
через интерфейс диалогового типа.
Если требуется, чтобы интерфейс был в виде циферблата без диалогового контейнера, то следует
использовать TimePicker.

## Пример выбора времени

На слайде приведён простой пример диалога для выбора времени, открытого с помощью PageStack::push().

## Выбор цвета

ColorPickerDialog представляет Dialog с интегрированным ColorPicker для выбора цвета.
При выборе цвета в палитре цветов диалог будет принят автоматически.

color : color содержит значение цвета, выбранное пользователем.
По умолчанию данное значение равно null.

colors : var содержит массив значений цвета, отображаемых для пользователя.
По умолчанию массив содержит стандартный набор цветов в стиле ОС Аврора.

## Пример выбора цвета

На слайде приведён простой пример диалога для выбора цвета, открытого с помощью PageStack::push().
