# Repeater и делегат

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Repeater — дупликатор элементов

Тип Repeater используется для создания большого количества похожих элементов.
Как и у других типов представлений, у Repeater есть модель и делегат.
Элемент Repeater обычно заключен в контейнер, такой как строка или столбец, чтобы визуально
позиционировать несколько элементов делегата

Он работает с моделью данных итеративно, как цикл for.
В простейшем случае модель представляет собой просто число, обозначающее количество циклов.
Модель Repeater может быть любой из поддерживаемых моделей данных.
Так же, как и делегаты для других представлений, делегат Repeater может получить доступ
к своему индексу, а также данные модели.

Свойства:

*	count : int - Это свойство содержит количество элементов в модели.
	Количество элементов в модели, о которых сообщается в счетчике, может отличаться
	от количества созданных делегатов, если Repeater находится в процессе создания экземпляров
	делегатов или неправильно настроен.
*	delegate : Component - делегат;
*	model : any - модель.

Сигналы:

*	itemAdded(int index, Item item) - Этот сигнал испускается, когда элемент добавляется в Repeater.
	Параметр index содержит индекс, в который элемент был вставлен в Repeater, а параметр item
	содержит элемент, который был добавлен.
*	itemRemoved(int index, Item item) - сигнал испускается, когда элемент удаляется.

Метод:

*	Item itemAt(index) - Возвращает элемент, созданный с заданным индексом,
	или null, если по индексу нет элемента.
 
## Пример заполнения таблицы

На слайде изображён пример использования Repeater для заполнения таблицы числами от 0 до 79.
 
## Model-View-Delegate

Шаблон проектирования MVC (Model-View-Controller) предполагает разделение данных приложения, 
пользовательского интерфейса и управляющей логики на три отдельных компонента:
Модель, Представление и Контроллер – таким образом, что модификация каждого компонента
может осуществляться независимо.

MVC позволяет снизить сложность и упростить архитектуру программ с графическим интерфейсом
при помощи того самого разделения ответственности.

*	Модель отвечает за данные и обеспечивает доступ к ним.
*	Представление отвечает за отображение данных, полученных из модели.
*	Контролер отвечает за взаимодействие с пользователем.
	Может изменять данные в модели.

В идеале эти модули должны быть независимы друг от друга и позволять вносить изменения
или даже полностью заменить какой-либо модуль без переделки остальных.
Это бывает необходимо при разработке разных версий одного и того же приложения.
Например, есть десктопная и мобильная версии одного и того же приложения.
Их Модель (ядро программы) должна быть одной и той же, поскольку приложения работают
с одними и теми же данными, а вот Представление у приложений должно отличаться.

Схема взаимодействия модулей представлена на слайде.
Предполагается, что пользователь может отдавать команды Контроллеру посредством Вида,
Контроллер обновляет данные Модели, Модель оповещает Контроллер о том, что необходимо
обновить Вид и Контроллер обновляет его.

Одним из основных предназначений Qt является разработка графических интерфейсов пользователя,
поэтому в нем без MVC тоже не обошлось и Qt включает в себя свою вариацию – Model-View шаблон.
Основной идеей является разделение данных и отображения.
Здесь Модель отвечает за данные и доступ к ним. В Qt за отображение элементов и получение ввода
от пользователя нередко отвечают одни и те же элементы, поэтому вполне логична идея объединить
Вид и Контроллер.
Но для того, чтобы из-за такого объединения не терять гибкость, было введено понятие делегата.
Делегат позволяет определять, как данные будут отображаться и как пользователь может их изменять.
Вид же, по сути, теперь является контейнером для экземпляров делегата.

Представление в MVC отображает данные. Оно определяет, как будут выглядеть данные и,
в конечном итоге, что увидит пользователь.

У представления в QML есть три задачи:

*	создавать экземпляры делегата для каждого элемента в модели;
*	расположить эти элементы требуемым образом;
*	обеспечить навигацию по элементам.

## Делегат

Для визуального представления элемента списка представлениям необходим делегат.
Представление визуализирует каждый элемент списка в соответствии с шаблоном, заданным делегатом.
Делегатом может выступать любой визуальный элемент.

Доступ к элементам модели осуществляется через свойство index, а также через свойства элемента.
К уникальным именам свойств можно обращаться напрямую.
Пример полностью определённого свойства: model.color.
Так можно избежать конфликта имён свойств в модели и делегате.

Модели без именованных свойств будут получать данные через modelData, по этому же имени
можно обращаться к данным из делегата.
