# Qt&nbsp;Quick Controls&nbsp;2

Copyright&nbsp;©&nbsp;2016–2023 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## ApplicationWindow — окно приложения

ApplicationWindow — это окно, которое позволяет добавлять в себя строку меню, заголовок
и нижний колонтитул.

Вы можете объявить ApplicationWindow как корневой элемент вашего приложения и запустить его
с помощью QQmlApplicationEngine.
Таким образом, вы можете управлять свойствами, внешним видом и макетом окна из QML.

## ApplicationWindow: прикреплённые свойства

Можно ссылаться на идентификатор корневого элемента приложения в любом месте его
дочерних объектов QML.
Хотя этот подход подходит для многих приложений и вариантов использования, для общего компонента QML
он может быть неприемлемым, поскольку создает зависимость от окружающей среды.

ApplicationWindow предоставляет набор прикрепленных свойств, которые можно использовать для доступа
к окну и его строительным блокам из мест, где нет прямого доступа к окну, без создания зависимости
от определенного идентификатора окна.
Компонент QML, который использует прикрепленные свойства ApplicationWindow, работает в любом окне
независимо от его идентификатора.
Прикрепленные свойства:

*	activeFocusControl : Control — элемент, на который сейчас направлен фокус;
*	contentItem : Item — элемент с содержимым окна;
*	footer : Item — нижний колонтитул;
*	header : Item — заголовок/верхний колонтитул;
*	menuBar : Item — меню;
*	window : ApplicationWindow — окно приложения.

## Page — страница

Страница — это контейнерный элемент управления, который позволяет добавлять на страницу элементы
заголовка и нижнего колонтитула.

## Frame — компоновка элементов

Frame используется для компоновки логической группы элементов управления вместе в визуальном фрейме.
Frame не предоставляет свой собственный макет, но требует, чтобы вы разместили его содержимое,
например, путем создания RowLayout или ColumnLayout.
Элементы, объявленные как дочерние элементы Frame, автоматически добавляются в contentItem.
Элементы, созданные динамически, должны быть явно связаны с contentItem.
Если во фрейме используется только один элемент, он изменит размер в соответствии с неявным
размером его элемента.
Это делает его особенно подходящим для использования вместе с элементами модуля layouts.

## Label — вывод текста

Label – QML-компонент для отображения стилизованного текста. 

Label унаследован от компонента Text, поэтому все его свойства, методы и сигналы
так же доступны и для объектов Label.

## TextField — ввод текста

TextField — однострочный текстовый редактор.
TextField расширяет TextInput функциональностью placeholderText и добавляет оформление.

На слайде перечислены варианты оформления.

*	Текстовое поле в нормальном состоянии.
*	Текстовое поле с активным фокусом.
*	Отключенное текстовое поле

## TextArea — многострочный ввод

TextArea — многострочный текстовый редактор.
TextArea расширяет TextEdit функциональностью placeholderText и добавляет оформление.

TextArea не прокручивается сам по себе.
Особенно на платформах с ограниченным размером экрана, часто предпочтительно сделать
прокручиваемыми целые страницы приложения.
На такой прокручиваемой странице непрокручиваемая TextArea может вести себя лучше,
чем вложенные прокручиваемые элементы управления.
Однако обратите внимание, что в таком случае фоновое оформление TextArea прокручивается
вместе с остальным прокручиваемым содержимым.

Если вы хотите сделать прокручиваемый объект TextArea, например, когда он охватывает всю страницу
приложения, его можно поместить в ScrollView.

TextArea, помещаемое в ScrollView, выполняет следующие действия:

*	Устанавливает размер контента автоматически;
*	Гарантирует, что фоновое оформление остается на месте;
*	Обрезает содержимое.

## ComboBox — список для выбора

ComboBox используется для выбора значения из выпадающего списка из нескольких строк.
Добавить новые значения невозможно, и можно выбрать только одну опцию.
Он предоставляет список параметров пользователю таким образом, чтобы он занимал минимальное количество места на экране.
Рекомендации:

*	Если число значений очень велико, рассмотрите возможность применения фильтра.
*	Если список очень ограничен, подумайте об использовании RadioButton.
	Преимущество заключается в том, что пользователь может видеть все параметры одновременно.
*	Выберите как значение по умолчанию, значение, которое будет выбираться чаще всего.

ComboBox заполняется моделью данных.
Модель данных обычно представляет собой массив JavaScript, ListModel или целое число,
но также поддерживаются другие типы моделей данных.

## Редактируемый ComboBox

ComboBox можно сделать редактируемым.
Редактируемое поле со списком автоматически заполняет свой текст на основе того,
что доступно в модели.
В примере демонстрируется добавление содержимого в редактируемое поле со списком путем реакции
на принятый сигнал.

## Slider — выбор значения

Slider используется для выбора значения путем перемещения точки по дорожке.
В примере настраиваются значения from, value и to.

Свойство position выражается в виде доли от размера элемента в диапазоне 0,0 — 1,0.
Свойство visualPosition такое же, за исключением того, что оно обращено в приложении справа налево.
visualPosition полезно для позиционирования точки при стилизации Slider.
В приведенном примере значение visualPosition будет 0,24 в приложении слева направо и 0,76
в приложении справа налево.

## RangeSlider — выбор диапазона

RangeSlider используется для выбора диапазона, заданного двумя значениями, путем перемещения
двух маркеров вдоль дорожки.
В примере устанавливаются пользовательские значения from и to, а также устанавливаются начальные
позиции первого и второго маркеров.

Чтобы выполнить действие при изменении значения для определенного дескриптора, используйте синтаксис first.onMoved.

Свойства first.position и second.position выражаются в долях от размера элемента управления в диапазоне 0,0 — 1,0.
Свойства first.visualPosition и second.visualPosition аналогичны, за исключением того, что они считаются справа налево.
visualPosition полезно для позиционирования маркеров при стилизации RangeSlider.
В приведенном выше примере first.visualPosition будет 0,24 в приложении слева направо и 0,76 в приложении справа налево.

## Dial — выбор поворотом

Dial поворачивается путем нажатия и перетаскивания, а точка указывает на значение циферблата.
Для приложений, где важен быстрый ввод, режим кругового ввода полезен, так как нажатие на циферблат
переместит его прямо в это положение.

Для приложений, где важен точный ввод, рекомендуются горизонтальный и вертикальный режимы ввода,
поскольку они позволяют вносить небольшие изменения в зависимости от того, где нажимается диск.
Эти режимы также лучше подходят для элементов ввода, где большие скачки значений могут быть
небезопасными, например, для элемента, который управляет громкостью звука.

Значение циферблата устанавливается с помощью свойства value.
Диапазон задается свойствами from и to.
Чтобы включить или отключить перенос, используйте свойство wrap.

Dial поддерживает три режима ввода: Dial.Circular, Dial.Horizontal и Dial.Vertical.
Режим кругового ввода работает в системе абсолютного ввода, где положение курсора на циферблате
напрямую отражает его значение.
В горизонтальном и вертикальном режимах ввода используется относительная система ввода,
где изменения в позиции курсора «добавляются» к значению циферблата.
Изображение на слайде иллюстрирует направления, в которых различные режимы ввода отслеживают движение.

## Tumbler — выбор прокруткой

Tumbler — это прокручиваемое колесо объектов, которые можно выбрать.

Tumbler позволяет пользователю выбрать опцию из вращающегося «колеса» значений.
Это полезно, когда есть слишком много опций для использования, например, RadioButton, и слишком
мало опций, чтобы требовать использования редактируемого SpinBox.
Оно удобно тем, что не требует использования клавиатуры и закольцовано на каждом конце, когда имеется
большое количество элементов.

API аналогичен представлениям ListView и PathView; можно указать модель и делегат,
а свойства count и currentItem предоставляют доступ только для чтения.
Чтобы установить currentItem по индексу, используйте positionViewAtIndex().

Однако, в отличие от представлений, таких как PathView и ListView, у тумблера всегда есть текущий элемент
(когда модель не пуста).
Это означает, что когда count равен 0, currentIndex будет равен -1.
Во всех остальных случаях он будет больше или равен 0.
По умолчанию Tumbler оборачивается, когда достигает верха и низа, если не все элементы модели
размещаются на тумблере; то есть, когда count больше чем visibleItemCount.
Если вы хотите перегрузить эту функциональность и явно указать, зацикливается ли Tumbler или нет,
используйте свойство wrap.

## SpinBox — выбор целого числа

SpinBox позволяет пользователю выбирать целое значение, нажимая кнопки индикатора вверх или вниз
или нажимая вверх или вниз на клавиатуре.
При желании SpinBox также можно сделать редактируемым, чтобы пользователь мог ввести текстовое
значение в поле ввода.
По умолчанию SpinBox предоставляет дискретные значения в диапазоне [0-99] с шагом stepSize равным 1.

## Button — кнопка с текстом

Кнопка представляет собой кнопку управления, которая может быть нажата пользователем.
Кнопки обычно используются для выполнения действия или для ответа на вопрос.

Кнопка наследует свой API от AbstractButton.
Например, вы можете установить текст, отобразить значок и реагировать на щелчки с помощью
API AbstractButton.

Кнопка издает сигнал clicked(), когда онf активируется пользователем.
Подключитесь к этому сигналу, чтобы обработать действие нажатия.

## DelayButton — кнопка с подтверждением

DelayButton — это кнопка, которая включает задержку перед началом действия и выбросом сигнала activated().
Эта задержка предотвращает случайные нажатия.
Рекомендации:

*	Используйте для сенсорных пользовательских интерфейсов.
*	Используйте для действий, которые должны быть вызваны с осторожностью.

Текущий прогресс выражается в виде десятичного значения от 0,0 до 1,0.
Время, которое требуется для активации activated(), измеряется в миллисекундах и может быть
установлено с помощью свойства delay.

Ход выполнения указывается индикатором выполнения на кнопке.

## RoundButton — круглая кнопка

RoundButton — это интерактивный элемент управления, который запускает действие, открывает
или закрывает всплывающее окно.
Кнопка с квадратным значком изображения или однобуквенным текстом на изображении имеет круглую форму.
Круглая кнопка RoundButton занимает меньше места, чем обычная кнопка.
RoundButton идентичен Button, за исключением того, что у него есть свойство radius, которое
позволяет скруглять углы без необходимости настраивать фон.
Рекомендации:

*	Делайте метки короткими и четкими.
*	Если текст локализован, учтите влияние более длинного текста на макет.

## Switch — переключатель

Switch представляет собой физический переключатель, который позволяет пользователям выбирать
между включенным или выключенным состоянием.
Используйте переключатель для бинарных операций, которые вступают в силу сразу после его включения.
Например, переключатель для включения или выключения WIFI.
Рекомендации:

*	Делайте метки короткими и четкими.
*	Если текст локализован, учтите влияние более длинного текста на макет.

Для больших наборов опций, таких как список, рассмотрите возможность использования SwitchDelegate.
Switch наследует свой API от AbstractButton.
Например, состояние переключателя может быть установлено с помощью свойства checked.

## RadioButton и ButtonGroup — выбор одного из группы

RadioButton используется для выбора только одного параметра из набора параметров.
Выбор одной опции автоматически отменяет выбор ранее выбранной.
Если есть только две взаимоисключающие опции, объедините их в один флажок или переключатель.

RadioButton наследует свой API от AbstractButton.
Например, вы можете установить текст и реагировать на клики, используя AbstractButton API.
Состояние переключателя можно установить с помощью свойства checked.

Радио кнопки по умолчанию являются автоматическими.
Только одна кнопка может быть отмечена в любое время среди переключателей, которые принадлежат
одному и тому же родительскому элементу; проверка другой кнопки автоматически снимает флажок ранее проверенной.
Для управления переключателями, которые не имеют общего родителя, может использоваться ButtonGroup.

ButtonGroup — это невизуальная, взаимоисключающая группа кнопок.
Он используется с такими элементами управления, как RadioButton, где одновременно может быть
выбран только один из параметров.
Самый простой способ использовать ButtonGroup — назначить список кнопок.
Например, список дочерних элементов контейнера или макета, который управляет группой
взаимоисключающих кнопок.

## CheckBox и GroupBox — выбор нескольких из группы

GroupBox используется для компоновки логической группы элементов управления
в пределах визуального фрейма.
GroupBox не предоставляет свой собственный макет, но требует, чтобы вы разместили его содержимое,
например, путем создания RowLayout или ColumnLayout.
Элементы, объявленные как дочерние элементы GroupBox, автоматически добавляются в contentItem GroupBox.
Элементы, созданные динамически, должны быть явно связаны с contentItem.
Если в GroupBox используется только один элемент, его размер будет изменен в соответствии с неявным
размером его элемента.
Это делает его особенно подходящим для использования вместе с элементами модуля layouts.

## StackView — стек страниц

StackView можно использовать с набором взаимосвязанных информационных страниц.
Например, приложение для работы с электронной почтой с отдельными представлениями
для отображения последних сообщений электронной почты, просмотра определенного сообщения
электронной почты и просмотра вложений.
Представление списка электронной почты помещается в стек по мере того, как пользователи открывают
электронную почту, и удаляется из стека, когда они решают вернуться.

StackView поддерживает три основные операции навигации: push(), pop() и replace().
Они соответствуют классическим операциям стека, где «push» добавляет элемент в верхнюю часть стека,
«pop» удаляет верхний элемент из стека, а «replace» подобен pop, за которым следует push, который
заменяет самый верхний элемент на новый.
Самый верхний элемент в стеке соответствует тому, который в данный момент виден на экране.
Логически «push» перемещается вперед или вглубь пользовательского интерфейса приложения,
«pop» перемещается назад, а «replace» заменяет currentItem.

depth — свойство содержит количество элементов, помещенных в стек в данный момент.

Использовать StackView в приложении просто: нужно добавить его в Window как дочерний элемент.
Стек обычно привязывается к краям окна, за исключением верхней или нижней части, где он может
быть привязан к строке состояния или к другому подобному компоненту пользовательского интерфейса.
Затем можно использовать стек, вызывая его методы навигации.
Первый элемент, который будет отображаться в StackView, это тот, который был назначен initialItem,
или самый верхний элемент, если initialItem не установлен.

## StackView: Нахождение элементов

Элемент, на который приложение не имеет ссылки, можно найти, вызвав find().
Метод нуждается в функции обратного вызова, которая вызывается для каждого элемента
в стеке (начиная сверху), пока не будет найдено совпадение.
Если обратный вызов возвращает true, find() останавливается и возвращает соответствующий элемент,
в противном случае возвращается значение null.
Приведенный на слайде код ищет в стеке элемент с именем «order_id» и раскручивает стек к этот элемент.

Вы также можете получить элемент в стеке, используя get(index).

## StackView: владение элементами [1]

StackView становится владельцем только тех элементов, которые он создает сам.
Это означает, что любой элемент, помещенный в StackView, никогда не будет уничтожен StackView;
StackView уничтожает только те элементы, которые StackView создает из компонентов или URL-адресов.
К примеру, сообщения будут напечатаны только тогда, когда StackView уничтожен,
а не когда элементы извлекаются из стека.

## StackView: владение элементами [2]

Однако оба элемента, созданные из URL-адреса и компонента, будут уничтожены StackView,
когда они извлечены из него.

## StackView: размеры

StackView не наследует неявный размер от элементов, которые помещаются в него.
Это означает, что, например, использование его в качестве contentItem диалога не будет
работать должным образом.

Есть несколько способов обеспечить размер StackView в этой ситуации:

*	Установите implicitWidth и implicitHeight на самом StackView.
*	Установите implicitWidth и implicitHeight для прямоугольника.
*	Установите contentWidth и contentHeight в диалоге.
*	Установите диалогу размер.

## SwipeView — пролистываемые вкладки

SwipeView предоставляет навигационную модель на основе прокрутки.

SwipeView заполняется набором страниц.
В один момент времени видна ровно одна страница.
Пользователь может перемещаться между страницами, листая страницы в стороны.
Обратите внимание, что сам SwipeView полностью не визуален.
Рекомендуется комбинировать его с PageIndicator, чтобы дать пользователю визуальную подсказку
о наличии нескольких страниц.

## SwipeView: динамическая подгрузка 

Как правило, не рекомендуется добавлять чрезмерное количество страниц в SwipeView.
Однако, когда количество страниц увеличивается или отдельные страницы становятся относительно
сложными, может быть желательно освободить ресурсы, выгружая страницы, которые находятся
вне досягаемости пользователя.
В примере показано, как использовать Loader для одновременного создания максимум трех страниц.

SwipeView берет на себя управление геометрией элементов, добавляемых в представление.
Использование привязок к элементам не поддерживается, и любое назначение ширины или высоты
будет переопределено представлением.
Обратите внимание, что это относится только к корню элемента.
Указание ширины и высоты или использование якорей для дочерних элементов работает, как ожидается.

## TabButton и TabBar — навигация с вкладками

TabBar предоставляет модель навигации на основе вкладок.
TabBar заполняется элементами управления TabButton и может использоваться вместе с любым макетом
или контейнером, который предоставляет свойство currentIndex, например StackLayout или SwipeView.

TabBar обычно заполняется статическим набором кнопок вкладок, которые определены как дочерние
элементы панели вкладок.
Также можно динамически добавлять, вставлять, перемещать и удалять элементы во время выполнения.
Доступ к элементам можно получить с помощью itemAt() или contentChildren.

## ToolButton и ToolBar — панель инструментов

ToolButton функционально похож на Button, но имеет внешний вид, который больше подходит для панели инструментов.

## ScrollBar — индикация прокрутки

ScrollBar — это интерактивная панель, которую можно использовать для прокрутки до определенной позиции.
Полоса прокрутки может быть вертикальной или горизонтальной и может быть прикреплена к любому
Flickable, например ListView и GridView.

Прикрепленная полоса прокрутки переопределяет себя в целевой Flickable.
Вертикально прикрепленный ScrollBar изменяет размеры до высоты Flickable и позиционирует себя
по обе стороны от него в зависимости от направления макета.
Горизонтально прикрепленная полоса прокрутки изменяет размеры по ширине Flickable и позиционирует
себя внизу.
Автоматическое управление геометрией можно отключить, указав другого родителя для присоединенного
ScrollBar.
Это может быть полезно, например, если ScrollBar должен быть размещен вне обрезки Flickable.
Это демонстрируется примером:

## ScrollBar: управление клавишами

Обратите внимание, что ScrollBar не фильтрует ключевые события Flickable,
к которому он прикреплен.
В примере показано, как реализовать прокрутку с помощью клавиш вверх и вниз.

## ScrollBar: привязка активного состояния

Горизонтальные и вертикальные полосы прокрутки по умолчанию не разделяют активное состояние друг с другом.
Чтобы обе полосы были видны при прокрутке в любом направлении, установите двустороннюю привязку
между активными состояниями, как показано в примере.

## ScrollView — представление с прокруткой

ScrollView обеспечивает прокрутку для пользовательского контента.
Его можно использовать либо для замены Flickable, либо для украшения существующего.
Пример демонстрирует простейшее использование ScrollView.

ScrollView не обрезает содержимое автоматически.
Если он не используется как полноэкранный элемент, вам следует установить для свойства clip значение true.

## ScrollView: размеры

Пример иллюстрирует использование существующего Flickable, то есть ListView.

Как и в случае с Flickable, при использовании ScrollView необходимо учитывать несколько моментов:

*	Если в ScrollView используется только один элемент, размер содержимого автоматически
	рассчитывается на основе неявного размера его элемента.
	Однако, если используется более одного элемента (или неявный размер не указан), для свойств
	contentWidth и contentHeight должен быть задан объединенный размер содержащихся в нем элементов.
*	Если размер содержимого меньше или равен размеру ScrollView, он не будет перелистываться.

## ItemDelegate — элемент списка

ItemDelegate представляет стандартный вид элемента.
Его можно использовать в качестве делегата в различных представлениях и элементах управления,
таких как ListView и ComboBox.

ItemDelegate наследует свой API от AbstractButton.
Например, вы можете установить текст, отобразить значок и реагировать на щелчки с помощью API AbstractButton.

## Menu — выбор действий

Меню имеет два основных варианта использования:

*	Контекстные меню; например, меню, которое отображается после щелчка правой кнопкой мыши.
*	Всплывающие меню; например, меню, которое отображается после нажатия кнопки.

Как правило, пункты меню статически объявляются как дочерние элементы меню,
но Menu также предоставляет API для добавления, вставки, перемещения и удаления элементов
динамически.
Доступ к элементам меню можно получить с помощью itemAt() или contentChildren.

Хотя элементы MenuItem чаще всего используются с Menu, он может содержать элементы
любого типа.

При использовании всплывающего меню проще всего указать его положение, указав нужные координаты
x и y с помощью соответствующих свойств, и вызвать open(), чтобы открыть меню.

## Структура меню

MenuItem — это элемент в элементе управления Menu. Каждый пункт в меню:

*	отображает текст пользователю;
*	позволяет проверять / снимать отметку;
*	подсвечивается (например, при навигации по клавиатуре);
*	выполняет некоторые действия по активации.

MenuItem наследует свой API от AbstractButton.
Например, вы можете установить текст и значок, используя AbstractButton API.

Также можно создавать подменю и объявлять объекты Action внутри Menu.

Подменю каскадно по умолчанию на десктопных платформах, на которых имеется курсор мыши.
Некаскадные меню отображаются по одному меню за раз, и по центру родительского меню.

Как правило, пункты меню статически объявляются как дочерние элементы меню, но Menu также
предоставляет API для добавления, вставки, перемещения и удаления элементов динамически.
Доступ к элементам в меню можно получить с помощью itemAt() или contentChildren.
Хотя чаще всего используются с Menu элементы MenuItem, оно может содержать элементы любого типа.

## MenuBar — панель меню

MenuBar состоит из выпадающих меню и обычно располагается на верхнем краю окна.

Как правило, меню статически объявляются как дочерние элементы строки меню,
но MenuBar также предоставляет API для динамического добавления, вставки, удаления и выбора меню.
Доступ к меню в строке меню можно получить с помощью menuAt().

## Dialog — диалог

Диалоги в QQC2 задаются при помощи компонента Dialog.
Кнопки диалога указываются в свойстве standardButtons.
Кроме Ok и Cancel есть достаточно большой список стандартных кнопок, в том числе Open, Save и т.д.

Модальное диалоговое окно блокирует ввод другого содержимого под диалоговым окном.
Когда модальное диалоговое окно открыто, пользователь должен закончить взаимодействие с диалоговым
окном и закрыть его, прежде чем он сможет получить доступ к любому другому содержимому в том же окне.

Немодальный диалог — это диалог, который работает независимо от другого содержимого вокруг диалога.
Когда немодальное диалоговое окно открыто, пользователь может взаимодействовать как с диалогом,
так и с другим содержимым в одном и том же окне.

## Стилизация приложения

Qt Quick Controls 2 поставляется с несколькими вариантами стилей.

Стиль по умолчанию — это простой и легкий универсальный стиль, который обеспечивает максимальную
производительность для Qt Quick Controls 2.

Стиль Fusion — это стиль, не зависящий от платформы, который предлагает внешний вид
Qt Quick Controls 2, ориентированный на рабочий стол.

Стиль Imagine основан на изображениях.
Стиль поставляется с набором изображений по умолчанию, который можно легко изменить,
предоставив каталог с изображениями, используя определенное соглашение об именах.

Стиль Material предлагает привлекательный дизайн, основанный на Руководстве по дизайну
материалов Google, но требует больше системных ресурсов, чем стиль по умолчанию.

Универсальный стиль предлагает привлекательный дизайн на основе Microsoft Universal Design
Guidelines, но требует больше системных ресурсов, чем стиль по умолчанию.

Чтобы запустить приложение с определенным стилем, либо сконфигурируйте стиль, используя QQuickStyle
в C ++, передайте аргумент командной строки или установите переменную среды.
Кроме того, предпочтительный стиль и специфичные для стиля атрибуты могут быть указаны в файле конфигурации.

## Настройка стиля

Чтобы запустить приложение с определенным стилем, либо настройте стиль с помощью QQuickStyle
в C ++, передайте аргумент командной строки или установите переменную среды.
В качестве альтернативы, предпочтительный стиль и специфичные для стиля атрибуты могут быть указаны в файле конфигурации.

У этих подходов есть приоритет: использование QQuickStyle, аргумент командной строки,
переменная среды, файл конфигурации.
То есть использование QQuickStyle для установки стиля всегда будет иметь приоритет перед
использованием, например, аргумента командной строки.

QQuickStyle предоставляет C++ API для настройки определенного стиля.
В примере запускается приложение Qt Quick Control со стилем Material.

Передача аргумента командной строки -style — это удобный способ проверки различных стилей.
В примере запускается приложение Qt Quick Control со стилем Material.

Установка переменной окружения QT_QUICK_CONTROLS_STYLE может использоваться
для установки общесистемного предпочтения стиля.
В примере запускается приложение Qt Quick Control со стилем Universal.

Qt Quick Controls 2 поддерживает специальный файл конфигурации :/qtquickcontrols2.conf,
который встроен в ресурсы приложения.

Файл конфигурации может указывать предпочтительный стиль и определенные атрибуты,
специфичные для стиля.
В следующем примере указывается, что предпочтительным стилем является стиль Material.
Кроме того, когда приложение запускается в стиле Material, его тема — светлая, а акцент
и основные цвета — бирюзовый и сине-серый соответственно.
Однако, если вместо этого приложение запускается со стилем Universal, цвет акцента будет красным,
и соответствующая тема будет выбрана на основе цветов системной темы.

## Файл конфигурации: секция Controls

Следующие значения могут быть указаны в разделе Controls файла конфигурации:

*	Style Определяет стиль для запуска приложения.
	Значением может быть имя одного из встроенных стилей или пользовательский стиль.
*	FallbackStyle Определяет стиль, используемый для элементов управления, которые не реализованы.
	Стиль должен быть одним из встроенных стилей.
	По умолчанию используется стиль Default.

## Файл конфигурации: секция Imagine

Значения, которые можно использовать для настройки стиля Imagine в разделе Imagine файла конфигурации:

*	Path указывает путь к каталогу, который содержит ресурсы стиля Imagine.
	Если не указано иное, используются встроенные ресурсы.

Из-за технических ограничений путь не должен называться imagine, если он относится к файлу qtquickcontrols2.conf.

## Файл конфигурации: секции Material и Universal

Значения, которые можно использовать для настройки стиля Material:

*	Theme Указывает тему Material по умолчанию.
	Значение может быть одной из доступных тем, например "Dark".
*	Variant Определяет вариант Material.
	Material Design имеет два варианта: обычный вариант, разработанный для сенсорных устройств,
	и вариант Dense для десктопов.
	Этот вариант использует меньшие размеры для элементов управления и их шрифтов.
*	Значение может быть "Normal" или "Dense".
*	Accent Задает цвет акцента.
	Значение может быть любого цвета, но рекомендуется использовать один из предопределенных
	цветов, например "Teal".
*	Primary Задает основной цвет.
	Значение может быть любого цвета, но рекомендуется использовать один из предопределенных
	цветов, например "BlueGrey".
*	Foreground Задает основной цвет элементов переднего плана.
	Значением может быть любой цвет или один из предопределенных цветов, например "Brown".
*	Background Задает цвет фона по умолчанию.
	Значением может быть любой цвет или один из предопределенных цветов, например "Grey".

Для универсального стиля можно настроить те же параметры, что и для Material, кроме Primary.

## Файл конфигурации: Настройка шрифта

Шрифт по умолчанию можно указать в подгруппе Font в разделе каждого стиля в файле конфигурации.
Подгруппа Font может быть определена двумя альтернативными способами.

Поддерживаемые атрибуты шрифта:

*	Family Семейство шрифтов.
*	PointSize Размер точки.
*	PixelSize Размер пикселя.
*	StyleHint Подсказка.
	Доступные значения: SansSerif, Helvetica, Serif, Times, TypeWriter, Courier, OldEnglish, Decorative, Monospace, Fantasy, Cursive.
*	Weight Вес.
	Qt использует весовую шкалу от 0 до 99.
	Вес 0 будет тонким, а 99 будет очень черным.
	Доступные предопределенные веса: Thin (0), ExtraLight (12), Light (25), Normal (50), Medium (57),
	DemiBold (63), Bold (75), ExtraBold (81), Black (87).
*	Style Стиль. Доступные значения: StyleNormal, StyleItalic, StyleOblique.

## Файл конфигурации: настройка цветов

Палитра по умолчанию может быть указана в подгруппе Palette в разделе каждого стиля в файле конфигурации.
Подгруппа Palette может быть определена двумя альтернативными способами.

## Файл конфигурации: использование в проекте

Чтобы Qt Quick Controls мог найти файл конфигурации, он должен быть встроен в ресурсы приложения
с помощью Системы ресурсов Qt.

Qt Quick Controls использует селектор файлов для загрузки файла конфигурации.
Можно предоставить разные файлы конфигурации для разных платформ и локалей.
Наконец, файл .qrc должен быть указан в файле .pro приложения, чтобы система сборки знала об этом.
