# Компоновки

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Компоновки

Qt Quick Layouts — это элементы, которые используются для упорядочивания элементов
в пользовательском интерфейсе.
Поскольку Qt Quick Layouts также изменяют размер своих элементов, они хорошо подходят
для пользовательских интерфейсов с изменяемым размером.

Основные типы:

*	ColumnLayout — вертикальный столбец;
*	RowLayout — горизонтальная строка;
*	GridLayout — таблица;
*	StackLayout — отображение верхнего элемента в стеке.

Присоединённые свойства:

*	Layout.fillHeight, Layout.fillWidth : bool — растягивать по направлениям;
*	Layout.margins, Layout.leftMargin, Layout.rightMargin, Layout.topMargin, Layout.bottomMargin : real — отступы;
*	Layout.rowSpan, Layout.columnSpan : int — объединения ячеек в GridLayout;
*	Layout.alignment : Qt.Alignment — отступы внутри ячейки.

Эти свойства можно определять в каждом визуальном элементе, помещённом в компоновщик.

## Пример компоновки

Тип RowLayout идентичен GridLayout, но имеет только одну строку.

Тип ColumnLayout идентичен GridLayout, но имеет только один столбец.

Они доступны для удобства разработчиков, так как предлагают более чистый API.

## Пример компоновки таблицей

Тип QML GridLayout предоставляет способ динамического расположения элементов в сетке.

Если изменить размер GridLayout, все элементы в макете будут переупорядочены.
Все видимые дочерние элементы элемента GridLayout будут принадлежать макету.

По умолчанию элементы будут расположены в соответствии со свойством flow.
Значение свойства flow по умолчанию — GridLayout.LeftToRight.

Если свойство columns указано, оно будет рассматриваться как максимальное количество столбцов,
которое может иметь макет, прежде чем автоматическое позиционирование вернется к началу
следующей строки.

Свойство rows работает аналогичным образом, но элементы автоматически позиционируются по вертикали.

Вы можете указать, какую ячейку должен занимать элемент, задав свойства Layout.row и Layout.column.
Вы также можете указать диапазон строк или столбцов, задав свойства Layout.rowSpan или Layout.columnSpan.

## Пример компоновки стеком

StackLayout предоставляет стек элементов, в котором одновременно виден только один элемент.

Текущий видимый элемент можно изменить, установив свойство currentIndex.
Индекс соответствует порядку дочерних элементов StackLayout.

В отличие от большинства других макетов, свойства Layout.fillWidth и Layout.fillHeight дочерних
элементов по умолчанию имеют значение true.
Как следствие, дочерние элементы по умолчанию масштабируются в соответствии с размером StackLayout,
если их Layout.maximumWidth или Layout.maximumHeight не препятствуют этому.
