# Отладка QML

Copyright&nbsp;©&nbsp;2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Отладка через консоль

console.log, console.debug, console.info, console.warn и console.error можно использовать для вывода отладочной информации на консоль.
Вывод формируется с помощью методов qDebug, qWarning и qCritical в C++.

console.assert проверяет истинность выражения. Если выражение неверно, выводится необязательное сообщение на консоль и выводится трассировка стека.

console.time и console.timeEnd регистрируют время (в миллисекундах), прошедшее между вызовами. Оба принимают строковый аргумент, идентифицирующий измерение

console.trace выводит трассировку стека выполнения JavaScript в точке вызова. Информация трассировки стека содержит имя функции, имя файла, номер строки и номер столбца. Трассировка стека ограничена последними 10 кадрами стека.

console.count выводит текущее количество выполнений определённого фрагмента кода вместе с сообщением.

console.profile включает профилировщики QML и JavaScript. Вложенные вызовы не поддерживаются, и на консоль будет выведено предупреждение.
console.profileEnd выключает профилировщики QML и JavaScript. Вызов этой функции без предварительного вызова console.profile выведет предупреждение на консоль. Клиент профилировщика должен быть подключён перед этим вызовом для получения и сохранения данных профилирования.

console.exception выводит сообщение об ошибке вместе со стеком трассировки выполнения JavaScript в точке вызова.

## Инфраструктура отладки

Переменную окружения QML_IMPORT_TRACE можно настроить для включения отладочного вывода из механизмов загрузки импорта QML.

При компиляции приложения необходимо явно включить инфраструктуру отладки. Можно передать компилятору определение QT_QML_DEBUG.
Включение инфраструктуры отладки может нарушить целостность приложения и системы, поэтому включать её следует только в контролируемой среде.

Для отладки приложение запускается со следующими аргументами:

```
-qmljsdebugger=port:<port_from>[,port_to][,host:<ip address>][,block]
```

Где port_from (обязательный параметр) указывает либо порт отладки, либо начальный порт диапазона портов, если указан port_to, ip address (необязательный параметр) указывает IP-адрес хоста, на котором запущено приложение, а block (необязательный параметр) запрещает запуск приложения до тех пор, пока клиент отладки не подключится к серверу. Это позволяет начать отладку с самого начала.

Когда приложение запущено, IDE или инструмент, реализующий двоичный протокол, могут подключиться к открытому порту.
Qt предоставляет инструмент командной строки qmlprofiler для сбора данных профилирования в файл.
