# Базовые компоненты Item и Rectangle

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Item — базовый визуальный тип

Хотя Item не имеет внешнего вида, он определяет свойства, которые являются общими для всех
визуальных элементов, такие как позиция на экране (x и y координаты), размеры (ширина и высота),
идентификатор объекта и др.

*	parent : Item — родительский элемент.
*	children : list<Item> — список потомков.
*	data : list<Object> — потомки и ресурсы.
*	x, y : int — позиция элемента.
*	z : int — позиционирование соседей элемента.
*	width, height : int — размер элементов.
*	visible : bool — отображен ли элемент.
*	anchors — относительное позиционирование.
*	clip : bool — включена ли обрезка.
*	opacity : real — прозрачность (от 0 до 1).

## Простой пример QML-кода

На слайде приведён простой пример создания объекта строго заданных размеров.

## Rectangle — закрашенный прямоугольник с рамкой

Rectangle — компонент, отображающий прямоугольную область на экране.
Так как класс Rectangle является унаследованным от класса Item, то он обладает и всеми его свойствами, описанными ранее.

Rectangle обладает собственными свойствами, позволяющими заполнять объект сплошным цветом
или градиентом, а также настраивать границу и радиус закругления углов.

*	color : color — цвет для заполнения.
*	radius : real — радиус скругления углов.
*	border — свойства рамки.
*	width : int — ширина рамки.
*	color : color — цвет рамки.
*	gradient : Gradient — градиент для заполнения.
*	antialiasing : bool — использовать ли сглаживание.

## Пример прямоугольника

На слайде приведён пример прямоугольника с фиксированным верхним левым углом, шириной и высотой,
заданных относительно родительского элемента, красным цветом, скруглёнными углами и заданными
свойствами границы.

## Пример с градиентом

Свойство color определяет цвет прямоугольника, который отрисовывается.
В качестве параметра здесь используется QML-тип “color”, который может быть представлен в виде
строки с именем цвета (“red”, “green”, “black”) или же в виде строки с шестнадцатеричным кодом. 
Свойство gradient принимает в качестве аргумента объект Gradient как представлено на слайде.
Gradient служит контейнером для объектов GradientStop, определяющих цвет и его позицию в градиенте.
Если у объекта определены оба свойства, то приоритет отдается градиенту.
