# Локализация с QLocale

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Локализация

Локализация - это процесс адаптации к местным соглашениям, например, представление даты и времени
с использованием локально предпочтительных форматов.
Для локализованных чисел, дат, времени и строк валюты используйте класс QLocale.

Локализация изображений не рекомендуется.
Выбирайте четкие значки, которые подходят для всех населенных пунктов, а не полагайтесь
на локальные каламбуры или растянутые метафоры.
Исключение составляют изображения стрелок, указывающих влево и вправо, которые, возможно,
придется изменить для арабского и иврита

## QLocale

Класс QLocale конвертирует числа и их строковые представления на разных языках.
QLocale инициализируется парой язык / страна в своем конструкторе и предлагает функции
преобразования числа в строку и строки в число, аналогичные функциям в QString.

## QLocale: локаль по умолчанию

QLocale поддерживает концепцию локали по умолчанию, которая определяется из настроек локали системы
при запуске приложения.
Язык по умолчанию можно изменить, вызвав статический метод setDefault().
Установка локали по умолчанию имеет следующие эффекты:

*	Если объект QLocale создается с помощью конструктора по умолчанию, он будет использовать
	настройки локали по умолчанию.
*	QString::toInt(), QString::toDouble(), и т.д., интерпретируют строку в соответствии
	с локалью по умолчанию.
	Если это не удается, он возвращается к локали «C».
*	QString::arg() использует локаль по умолчанию для форматирования числа, когда его указатель
	позиции в строке формата содержит «L», например, "%L1".

## QLocale: пример

В примере показано, как использовать QLocale напрямую.

## QLocale: языки и страны

Если в конструкторе указана пара язык / страна, может произойти одно из трех:

*	Если в базе данных найдена пара язык / страна, она используется.
*	Если язык найден, но страны нет, или если страна AnyCountry, язык используется с наиболее
	подходящей доступной страной (например, Германия для немецкого языка),
*	Если ни язык, ни страна не найдены, QLocale использует локаль по умолчанию.

Используйте language() и country(), чтобы определить действительные значения языка и страны.

## QLocale: создание

Альтернативный метод создания объекта QLocale - указание имени локали.

Конструктор преобразует имя локали в пару язык/страна; он не использует системную базу данных
локали.

Для текущей локали ввода с клавиатуры взгляните на QInputMethod::locale().
