# MultiPointTouchArea

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Обработчик нескольких точек касания

MultiPointTouchArea-это невидимый элемент, который используется для отслеживания нескольких точек касания.
Свойство Item::enabled используется для включения и отключения сенсорной обработки.
При отключении сенсорная область становится прозрачной для мыши и сенсорных событий.

По умолчанию мышь будет обрабатываться так же, как одна точка касания, и элементы под сенсорной
областью не будут получать события мыши, потому что сенсорная область обрабатывает их.
Но если свойству mouseEnabled присвоено значение false, оно становится прозрачным для событий мыши,
так что другой чувствительный к мыши элемент (например, MouseArea) может использоваться
для обработки взаимодействия мыши отдельно.

mouseEnabled определяет, будет ли MultiPointTouchArea обрабатывать события мыши тоже.
Если оно true (по умолчанию), сенсорная область будет обрабатывать мышь так же, как и одну точку
касания; если это false, сенсорная область будет игнорировать события мыши и позволит им
"проходить", чтобы они могли обрабатываться другими элементами внизу.

## MultiPointTouchArea: применение

MultiPointTouchArea можно использовать двумя способами:

*	настройка touchPoints для предоставления объектам точек касания свойств, к которым можно привязаться;
*	использование обработчиков onTouchUpdated или onPressed, onUpdated и onReleased.

В то время как MultiPointTouchArea может принимать исключительное право собственности
на определенные точки касания, также возможно иметь несколько активных MultiPointTouchArea
одновременно, каждый из которых работает на собственном наборе точек касания.

## MultiPointTouchArea: свойства

maximumTouchPoints и minimumTouchPoints содержат диапазон точек касания, обрабатываемых сенсорной областью.
Они позволяют, например, иметь вложенные MultiPointTouchAreas, одну для обработки двух касаний
пальцев, а другую для обработки трех касаний пальцев.
По умолчанию обрабатываются все точки касания в области касания.

Если mouseEnabled имеет значение true, мышь действует как точка касания, поэтому она также
подвержена этим ограничениям: например, если maximumTouchPoints равно двум, вы можете использовать
мышь как одну точку касания и палец как другую точку касания, в общей сложности две точки касания.

touchPoints содержит набор пользовательских объектов точек касания, к которым можно привязаться.
Если mouseEnabled имеет значение true (по умолчанию) и левая кнопка мыши нажата, когда мышь
находится над сенсорной областью, текущая позиция мыши будет одной из этих точек касания.
По умолчанию это свойство содержит пустой список.

## MultiPointTouchArea: пример

В следующем примере у нас есть два небольших прямоугольника,
которые следуют за нашими точками касания.

## MultiPointTouchArea: сигналы [1]

canceled испускается, когда новые события касания были отменены, потому что другой элемент
украл обработку события касания.
Этот сигнал предназначен для расширенного использования: он полезен, когда имеется более одной
MultiPointTouchArea, которая обрабатывает ввод, или когда внутри Flickable есть MultiPointTouchArea.
В последнем случае, если вы выполняете некоторую логику в обработчике сигнала onPressed,
а затем начинаете перетаскивание, Flickable может украсть обработку касания из MultiPointTouchArea.
В этих случаях для сброса логики, когда MultiPointTouchArea утратил сенсорную обработку
для Flickable, сигнал canceled должен быть обработан в дополнение к released.
touchPoints - это список отмененных точек.

pressed испускается, когда добавляются новые точки касания.
touchPoints — это список этих новых точек.
Если для MinimumTouchPoints установлено значение больше единицы, этот сигнал не будет излучаться
до тех пор, пока не будет достигнуто минимальное количество требуемых точек касания.

released испускается при удалении существующих точек касания.
touchPoints — это список удаленных точек.

## MultiPointTouchArea: сигналы [2]

gestureStarted испускается при достижении глобального порога перетаскивания.
Этот сигнал обычно используется, когда MultiPointTouchArea был вложен в Flickable или другую
MultiPointTouchArea.
Когда порог достигнут и сигнал обработан, вы можете определить, должна ли область касания
захватывать текущие точки касания.
По умолчанию они не будут захвачены; чтобы захватить их, вызовите  gesture.grab().
Если жест не захвачен, то, например, вложенный Flickable также будет иметь возможность захватить его.
Объект жеста также включает в себя информацию о текущем наборе touchPoints и dragThreshold.

touchUpdated испускается при изменении точек касания, обрабатываемых MultiPointTouchArea.
Это включает в себя добавление новых точек касания, удаление или отмену предыдущих точек касания,
а также обновление текущих данных точки касания. touchPoints — это список всех текущих точек касания.

updated испускается при обновлении существующих точек касания.
touchPoints — это список обновленных точек.
