# Moc и макросы

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Метаобъектная система Qt

Система мета-объектов позволяет функционировать механизму сигналов и слотов, системе свойств
и является источником информации о типах данных во время исполнения. 
Классы, производные от QObject являются источником информации для системы мета-объектов.
Наличие макроса Q_OBJECT включает поддержку данной системы для объектов.

## Инструмент moc

Мета-объектный компилятор moc предоставляет каждому подклассу QObject код для реализации мета-объектных возможностей.
Макрос в C++ — это действие или набор действий, которые можно выполнять сколько угодно раз.

Основным макросом метаобъектной системы Qt является Q_OBJECT.
Инструмент moc читает файл исходных кодов C++. 
Если он находит один или более объявлений классов, содержащих макрос Q_OBJECT, он производит
другой файл исходных кодов C++, который содержит мета-объектный код для каждого из этих классов. 
Полученный файл исходных кодов или подключается с помощью #include в исходном файле класса или,
что применяется чаще, компилируется и линкуется вместе с реализацией класса.

## Возможности метаобъектной системы

Помимо предоставления механизма сигналов и слотов для взаимодействия между объектами (основная причина введения этой системы), метаобъектный код предоставляет следующие дополнительные возможности:

*	QObject::metaObject() возвращает связанный метаобъект для класса.
*	QMetaObject::className() возвращает имя класса в виде строки во время выполнения, не требуя поддержки встроенной информации о типах во время выполнения (RTTI) через компилятор C++.
*	Функция QObject::inherits() возвращает, является ли объект экземпляром класса, наследующего указанный класс в дереве наследования QObject.
*	QObject::tr() и QObject::trUtf8() преобразуют строки для интернационализации.
*	QObject::setProperty() и QObject::property() динамически устанавливают и получают свойства по имени.
*	QMetaObject::newInstance() создаёт новый экземпляр класса.
