# JS-модели

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Типы моделей

Модель отвечает за доступ к данным.

Модель может быть реализована как в самом QML, так и на C++.
Выбор тут больше всего зависит от того, где находится источник данных.
Если в качестве источника данных используется код на C++, то там удобнее сделать и модель.
Если же данные поступают напрямую в QML, то лучше и модель реализовать на QML. 
В QML в качестве моделей используются компоненты ListModel, XmlListModel,
а также JavaScript-модели.
Причем модель, загружаемую из xml-файла, редактировать нельзя.

JavaScript-модели - это простые модели на основе массивов или целых чисел.

## Javascript-модели. Список строк

Помимо специально разработанных для создания моделей компонентов, в качестве модели
могут использоваться и другие объекты. Так моделями могут являться JavaScript-массивы и целые числа.

Рассмотрим в качестве модели JavaScript-массив.

Для каждого элемента массива будет создан делегат и данные самого элемент массива
будут доступны в делегате через свойство modelData. 

Если в массиве находятся объекты, то modelData тоже будет объектом и будет содержать
все свойства исходного объекта. 
 
## Javascript-модели. Массивы

В примере на слайде JavaScript-массив dataModel используется в качестве модели
для SilicaListView.
Внутри массива объявлены два JavaScript-объекта.
Один имеет свойство color, второй имеет два свойства color и text.
Доступ к свойствам осуществляется в делегате с помощью объекта modelData.
У одного из объектов модели не определено свойство text, в таком случае вместо него
отображается строка “empty text”.

Все Javascript-модели являются пассивными.
При изменении элементов и их добавлении/удалении представление не будет знать, что они поменялись.
Так происходит потому, что у свойств JavaScript-объектов нет сигналов, которые вызываются
при изменении свойства, в отличие от QML-объектов.

Обратите внимание, что к полям модели мы обращаемся через modelData.
 
## Javascript-модели. Целые числа

В качестве модели также можно использовать целое число.
Это число является количеством элементов модели.
Так можно напрямую передать свойству model целое число, как это сделано в примере на слайде.

В делегате будет доступно свойство modelData, которое содержит число.
Индекс будет доступен через model.index.
Никакой другой информации такая модель содержать не может.
