# Интернационализация в Qt

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Интернационализация с Qt

Интернационализация и локализация приложения - это процессы адаптации приложения к различным языкам,
региональным различиям и техническим требованиям целевого рынка.
Интернационализация подразумевает разработку программного приложения таким образом,
чтобы оно могло быть адаптировано к различным языкам и регионам без технических изменений.
Локализация означает адаптацию интернационализированного программного обеспечения для конкретного
региона или языка путем добавления компонентов, специфичных для данной локали (таких как форматы
даты, времени и чисел) и перевода текста.

## Классы Qt и API

Эти классы поддерживают интернационализацию приложений Qt.

*	QLocale - Конвертирует числа в их строковые представления и наоборот на разных языках.
*	QTextCodec - Преобразования между текстовыми кодировками.
*	QTranslator - Поддержка интернационализации для вывода текста.

## Встроенная поддержка

В некоторых случаях интернационализация проста, например, чтобы сделать приложение в США
доступным для австралийских или британских пользователей, может потребоваться не намного больше
действий, чем несколько исправлений правописания.
Но для того, чтобы приложение в США могло использоваться японскими пользователями,
или корейское приложение было адаптировано для немецких пользователей, потребуется, чтобы
программное обеспечение работало не только на разных языках, но и использовало разные методы ввода,
кодировки символов, а также соглашения об интерфейсе.

Qt старается сделать интернационализацию максимально безболезненной для разработчиков.
Все элементы управления вводом и методы рисования текста в Qt предлагают встроенную поддержку
для всех поддерживаемых языков.
Встроенный механизм шрифтов способен правильно и привлекательно отображать текст, содержащий
символы из разных письменных систем одновременно.

## Языки и письменные системы

Qt поддерживает большинство языков, используемых сегодня, в частности:

*	все восточноазиатские языки (китайский, японский и корейский);
*	все западные языки (с использованием латинского алфавита);
*	арабский;
*	кириллические языки (русский, украинский и др.);
*	греческий;
*	иврит;
*	...

Приведенный выше список поддерживается и будет работать на всех платформах, если
в системе есть шрифты для визуализации установленных систем записи.

## Дополнительные особенности

Многие из этих письменных систем имеют дополнительные особенности.

*	Специальное поведение разрыва строки.
	Некоторые из азиатских языков написаны без пробелов между словами.
	Разрыв строки может происходить либо после каждого символа (за исключением), как в китайском,
	японском и корейском, либо после логических границ слов, как в тайском.
*	Двунаправленная запись.
	Арабский и иврит пишутся справа налево, за исключением цифр и встроенного английского текста,
	который пишется слева направо.
*	Недопустимые или диакритические знаки (акценты или умлауты в европейских языках).
	Некоторые языки, такие как вьетнамский, широко используют эти знаки, а некоторые символы могут
	иметь более одной отметки одновременно, чтобы уточнить произношение.
*	Лигатуры.
	В особых случаях некоторые пары символов заменяются комбинированным глифом,
	образующим лигатуру.
*	Qt пытается позаботиться обо всех перечисленных выше специальных функциях.
	Обычно вам не нужно беспокоиться об этих функциях, если вы используете элементы управления
	вводом Qt (например, QLineEdit, QTextEdit и производные классы или элемент Quick TextInput)
	и элементы управления отображением Qt (например, QLabel и элемент Text Qt Quick).

## Особенности поддержки

Поддержка этих систем письма прозрачна для программиста и полностью заключена в текстовый движок Qt.
Это означает, что вам не нужно иметь никаких знаний о системе письма, используемой на определенном
языке, за исключением следующих небольших деталей:

*	QPainter::drawText(int x, int y, const QString &str) всегда будет рисовать строку с ее левым
	краем в позиции, указанной параметрами x, y.
	Это обычно дает вам выровненные по левому краю строки.
	Строки приложения на арабском и иврите обычно выровнены по правому краю, поэтому для этих
	языков используйте версию drawText(), которая принимает на вход QRect, поскольку она будет выровнена
	в соответствии с языком.
*	Когда вы пишете свои собственные элементы управления вводом текста, используйте QTextLayout.
	В некоторых языках (например, арабском или языках индийского субконтинента) ширина и форма
	глифа изменяются в зависимости от окружающих символов, которые принимает во внимание
	QTextLayout.
	Написание элементов управления вводом обычно требует определенных знаний сценариев, в которых
	он будет использоваться.
	Обычно самый простой способ - это создать подкласс QLineEdit или QTextEdit.
