#  Модули для курсов разработки приложений на&nbsp;Qt

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

*	Особенности разработки под&nbsp;ОС Аврора
	*	[Операционные системы и&nbsp;подходы к&nbsp;разработке](./os_and_development_approaches)
		*	Лекция:
			[cлайды](./os_and_development_approaches/lecture.fodp),
			[конспект](./os_and_development_approaches/lecture.md)
		*	[Тесты](./os_and_development_approaches/tests.md)
	*	[ОС Аврора](./os_aurora)
		*	Лекция:
			[cлайды](./os_aurora/lecture.fodp),
			[конспект](./os_aurora/lecture.md)
		*	[Тесты](./os_aurora/tests.md)
	*	[Кроссплатформенный фреймворк Qt](./qt_framework_and_qt_quick_technology)
		*	Лекция:
			[cлайды](./qt_framework_and_qt_quick_technology/lecture.fodp),
			[конспект](./qt_framework_and_qt_quick_technology/lecture.md)
		*	[Тесты](./qt_framework_and_qt_quick_technology/tests.md)
	*	[Qt Creator](./qt_creator)
		*	Лекция:
			[cлайды](./qt_creator/lecture.fodp),
			[конспект](./qt_creator/lecture.md)
		*	[Тесты](./qt_creator/tests.md)
	*	[Аврора SDK](./aurora_sdk)
		*	Лекция:
			[cлайды](./aurora_sdk/lecture.fodp),
			[конспект](./aurora_sdk/lecture.md)
		*	[Тесты](./aurora_sdk/tests.md)
	*	[Эмулятор](./emulator)
		*	Лекция:
			[cлайды](./emulator/lecture.fodp),
			[конспект](./emulator/lecture.md)
		*	[Тесты](./emulator/tests.md)
	*	[Структура проекта](./project_structure)
		*	Лекция:
			[cлайды](./project_structure/lecture.fodp),
			[конспект](./project_structure/lecture.md)
		*	[Тесты](./project_structure/tests.md)
	*	[Этапы запуска проекта](./project_launch)
		*	Лекция:
			[cлайды](./project_launch/lecture.fodp),
			[конспект](./project_launch/lecture.md)
		*	[Тесты](./project_launch/tests.md)
	*	[QML Live](./qml_live)
		*	Лекция:
			[cлайды](./qml_live/lecture.fodp),
			[конспект](./qml_live/lecture.md)
		*	[Тесты](./qml_live/tests.md)
*	Qt Quick и основы QML
	*	[Базовые понятия и типы](./qml_base_types)
		*	Лекция:
			[cлайды](./qml_base_types/lecture.fodp),
			[конспект](./qml_base_types/lecture.md)
		*	[Тесты](./qml_base_types/tests.md)
	*	[Базовые компоненты Item и Rectangle](./qml_item)
		*	Лекция:
			[cлайды](./qml_item/lecture.fodp),
			[конспект](./qml_item/lecture.md)
		*	[Тесты](./qml_item/tests.md)
	*	[Абсолютное и относительное позиционирование](./qml_base_positioning)
		*	Лекция:
			[cлайды](./qml_base_positioning/lecture.fodp),
			[конспект](./qml_base_positioning/lecture.md)
		*	[Задания](./qml_base_positioning/tasks.md)
		*	[Тесты](./qml_base_positioning/tests.md)
	*	[Контейнеры](./qml_containers)
		*	Лекция:
			[cлайды](./qml_containers/lecture.fodp),
			[конспект](./qml_containers/lecture.md)
		*	[Тесты](./qml_containers/tests.md)
	*	[Компоновки](./qml_layouts)
		*	Лекция:
			[cлайды](./qml_layouts/lecture.fodp),
			[конспект](./qml_layouts/lecture.md)
		*	[Тесты](./qml_layouts/tests.md)
	*	[Дочерние объекты](./qml_children)
		*	Лекция:
			[cлайды](./qml_children/lecture.fodp),
			[конспект](./qml_children/lecture.md)
		*	[Тесты](./qml_children/tests.md)
	*	[Компонент Text](./qml_text)
		*	Лекция:
			[cлайды](./qml_text/lecture.fodp),
			[конспект](./qml_text/lecture.md)
		*	[Задания](./qml_text/tasks.md)
		*	[Тесты](./qml_text/tests.md)
	*	[Компонент Image](./qml_image)
		*	Лекция:
			[cлайды](./qml_image/lecture.fodp),
			[конспект](./qml_image/lecture.md)
		*	[Тесты](./qml_image/tests.md)
	*	[Трансформации](./qml_transform)
		*	Лекция:
			[cлайды](./qml_transform/lecture.fodp),
			[конспект](./qml_transform/lecture.md)
		*	[Тесты](./qml_transform/tests.md)
*	JavaScript в QML
	*	[Свойства](./qml_js_properties)
		*	Лекция:
			[cлайды](./qml_js_properties/lecture.fodp),
			[конспект](./qml_js_properties/lecture.md)
		*	[Тесты](./qml_js_properties/tests.md)
	*	[Функции и методы](./qml_js_functions)
		*	Лекция:
			[cлайды](./qml_js_functions/lecture.fodp),
			[конспект](./qml_js_functions/lecture.md)
		*	[Тесты](./qml_js_functions/tests.md)
	*	[Сигналы и слоты](./qml_js_signals_slots)
		*	Лекция:
			[cлайды](./qml_js_signals_slots/lecture.fodp),
			[конспект](./qml_js_signals_slots/lecture.md)
		*	[Тесты](./qml_js_signals_slots/tests.md)
	*	[Компоненты](./qml_js_components)
		*	Лекция:
			[cлайды](./qml_js_components/lecture.fodp),
			[конспект](./qml_js_components/lecture.md)
		*	[Тесты](./qml_js_components/tests.md)
	*	[Объекты](./qml_js_objects)
		*	Лекция:
			[cлайды](./qml_js_objects/lecture.fodp),
			[конспект](./qml_js_objects/lecture.md)
		*	[Тесты](./qml_js_objects/tests.md)
	*	[Массивы](./qml_js_arrays)
		*	Лекция:
			[cлайды](./qml_js_arrays/lecture.fodp),
			[конспект](./qml_js_arrays/lecture.md)
		*	[Тесты](./qml_js_arrays/tests.md)
	*	[Строки](./qml_js_strings)
		*	Лекция:
			[cлайды](./qml_js_strings/lecture.fodp),
			[конспект](./qml_js_strings/lecture.md)
		*	[Тесты](./qml_js_strings/tests.md)
	*	[JavaScript-модули](./qml_js_modules)
		*	Лекция:
			[cлайды](./qml_js_modules/lecture.fodp),
			[конспект](./qml_js_modules/lecture.md)
		*	[Тесты](./qml_js_modules/tests.md)
	*	[Отладка QML](./qml_js_debug)
		*	Лекция:
			[cлайды](./qml_js_debug/lecture.fodp),
			[конспект](./qml_js_debug/lecture.md)
		*	[Тесты](./qml_js_debug/tests.md)
*	Интерактивные элементы
	*	[MouseArea](./mousearea)
		*	Лекция:
			[cлайды](./mousearea/lecture.fodp),
			[конспект](./mousearea/lecture.md)
		*	[Тесты](./mousearea/tests.md)
	*	[Canvas](./canvas)
		*	Лекция:
			[cлайды](./canvas/lecture.fodp),
			[конспект](./canvas/lecture.md)
		*	[Тесты](./canvas/tests.md)
*	Анимации, состояния и переходы
	*	[Анимации](./animations)
		*	Лекция:
			[cлайды](./animations/lecture.fodp),
			[конспект](./animations/lecture.md)
		*	[Примеры](./animations/examples.md)
		*	[Задания](./animations/tasks.md)
		*	[Тесты](./animations/tests.md)
	*	[Состояния и переходы](./states_transitions)
		*	Лекция:
			[cлайды](./states_transitions/lecture.fodp),
			[конспект](./states_transitions/lecture.md)
		*	[Примеры](./states_transitions/examples.md)
		*	[Задания](./states_transitions/tasks.md)
		*	[Тесты](./states_transitions/tests.md)
*	Модели и представления
	*	[Repeater и делегат](./repeater)
		*	Лекция:
			[cлайды](./repeater/lecture.fodp),
			[конспект](./repeater/lecture.md)
		*	[Тесты](./repeater/tests.md)
	*	[ListView](./listview)
		*	Лекция:
			[cлайды](./listview/lecture.fodp),
			[конспект](./listview/lecture.md)
		*	[Тесты](./listview/tests.md)
	*	[GridView](./gridview)
		*	Лекция:
			[cлайды](./gridview/lecture.fodp),
			[конспект](./gridview/lecture.md)
		*	[Тесты](./gridview/tests.md)
	*	[PathView](./pathview)
		*	Лекция:
			[cлайды](./pathview/lecture.fodp),
			[конспект](./pathview/lecture.md)
		*	[Тесты](./pathview/tests.md)
	*	[JS-модели](./js_models)
		*	Лекция:
			[cлайды](./js_models/lecture.fodp),
			[конспект](./js_models/lecture.md)
		*	[Задания](./js_models/tasks.md)
		*	[Тесты](./js_models/tests.md)
	*	[ListModel](./listmodel)
		*	Лекция:
			[cлайды](./listmodel/lecture.fodp),
			[конспект](./listmodel/lecture.md)
		*	[Примеры](./listmodel/examples.md)
		*	[Задания](./listmodel/tasks.md)
		*	[Тесты](./listmodel/tests.md)
	*	[XmlListModel](./xmllistmodel)
		*	Лекция:
			[cлайды](./xmllistmodel/lecture.fodp),
			[конспект](./xmllistmodel/lecture.md)
		*	[Задания](./xmllistmodel/tasks.md)
		*	[Тесты](./xmllistmodel/tests.md)
	*	[ObjectModel](./objectmodel)
		*	Лекция:
			[cлайды](./objectmodel/lecture.fodp),
			[конспект](./objectmodel/lecture.md)
		*	[Задания](./objectmodel/tasks.md)
		*	[Тесты](./objectmodel/tests.md)
*	Дополнительные главы Qt Quick
	*	[WorkerScript](./workerscript)
		*	Лекция:
			[cлайды](./workerscript/lecture.fodp),
			[конспект](./workerscript/lecture.md)
		*	[Примеры](./workerscript/examples.md)
		*	[Задания](./workerscript/tasks.md)
		*	[Тесты](./workerscript/tests.md)
	*	[PinchArea](./pincharea)
		*	Лекция:
			[cлайды](./pincharea/lecture.fodp),
			[конспект](./pincharea/lecture.md)
		*	[Примеры](./pincharea/examples.md)
		*	[Тесты](./pincharea/tests.md)
	*	[MultiPointTouchArea](./multipointtoucharea)
		*	Лекция:
			[cлайды](./multipointtoucharea/lecture.fodp),
			[конспект](./multipointtoucharea/lecture.md)
		*	[Тесты](./multipointtoucharea/tests.md)
	*	[Drag&Drop](./drag_and_drop)
		*	Лекция:
			[cлайды](./drag_and_drop/lecture.fodp),
			[конспект](./drag_and_drop/lecture.md)
		*	[Тесты](./drag_and_drop/tests.md)
*	Silica и Aurora Controls
	*	[Базовые компоненты: метки и кнопки](./silica_base)
		*	Лекция:
			[cлайды](./silica_base/lecture.fodp),
			[конспект](./silica_base/lecture.md)
		*	[Примеры](./silica_base/examples.md)
		*	[Задания](./silica_base/tasks.md)
		*	[Тесты](./silica_base/tests.md)
	*	[Навигация](./silica_navigation)
		*	Лекция:
			[cлайды](./silica_navigation/lecture.fodp),
			[конспект](./silica_navigation/lecture.md)
		*	[Примеры](./silica_navigation/examples.md)
		*	[Тесты](./silica_navigation/tests.md)
	*	[Обложки и экран заставки](./silica_cover)
		*	Лекция:
			[cлайды](./silica_cover/lecture.fodp),
			[конспект](./silica_cover/lecture.md)
		*	[Примеры](./silica_cover/examples.md)
		*	[Тесты](./silica_cover/tests.md)
	*	[Поля ввода](./silica_fields)
		*	Лекция:
			[cлайды](./silica_fields/lecture.fodp),
			[конспект](./silica_fields/lecture.md)
		*	[Примеры](./silica_fields/examples.md)
		*	[Тесты](./silica_fields/tests.md)
	*	[Контейнеры](./silica_containters)
		*	Лекция:
			[cлайды](./silica_containters/lecture.fodp),
			[конспект](./silica_containters/lecture.md)
		*	[Примеры](./silica_containters/examples.md)
		*	[Тесты](./silica_containters/tests.md)
	*	[Меню](./silica_menu)
		*	Лекция:
			[cлайды](./silica_menu/lecture.fodp),
			[конспект](./silica_menu/lecture.md)
		*	[Примеры](./silica_menu/examples.md)
		*	[Тесты](./silica_menu/tests.md)
	*	[Aurora Controls](./aurora_controls)
		*	Лекция:
			[cлайды](./aurora_controls/lecture.fodp),
			[конспект](./aurora_controls/lecture.md)
		*	[Примеры](./aurora_controls/examples.md)
		*	[Тесты](./aurora_controls/tests.md)
	*	[Диалоги](./silica_dialogs)
		*	Лекция:
			[cлайды](./silica_dialogs/lecture.fodp),
			[конспект](./silica_dialogs/lecture.md)
		*	[Примеры](./silica_dialogs/examples.md)
		*	[Задания](./silica_dialogs/tasks.md)
		*	[Тесты](./silica_dialogs/tests.md)
	*	[Theme](./silica_theme)
		*	Лекция:
			[cлайды](./silica_theme/lecture.fodp),
			[конспект](./silica_theme/lecture.md)
		*	[Примеры](./silica_theme/examples.md)
		*	[Тесты](./silica_theme/tests.md)
	*	[Масштабирование и вырезы](./silica_insets)
		*	Лекция:
			[cлайды](./silica_insets/lecture.fodp),
			[конспект](./silica_insets/lecture.md)
		*	[Примеры](./silica_insets/examples.md)
		*	[Тесты](./silica_insets/tests.md)
	*	[Clipboard](./silica_clipboard)
		*	Лекция:
			[cлайды](./silica_clipboard/lecture.fodp),
			[конспект](./silica_clipboard/lecture.md)
		*	[Тесты](./silica_clipboard/tests.md)
	*	[Обзор Silica-компонентов](./silica_components)
		*	Лекция:
			[cлайды](./silica_components/lecture.fodp),
			[конспект](./silica_components/lecture.md)
		*	[Примеры](./silica_components/examples.md)
		*	[Тесты](./silica_components/tests.md)
*	UX ОС Аврора
	*	[Системный UI](./ui_system)
		*	Лекция:
			[cлайды](./ui_system/lecture.fodp),
			[конспект](./ui_system/lecture.md)
		*	[Тесты](./ui_system/tests.md)
	*	[Жизненный цикл графических приложений](./ui_lifecycle)
		*	Лекция:
			[cлайды](./ui_lifecycle/lecture.fodp),
			[конспект](./ui_lifecycle/lecture.md)
		*	[Тесты](./ui_lifecycle/tests.md)
	*	[UI Kit и общие рекомендации](./ui_kit)
		*	Лекция:
			[cлайды](./ui_kit/lecture.fodp),
			[конспект](./ui_kit/lecture.md)
		*	[Тесты](./ui_kit/tests.md)
*	[Qt&nbsp;Quick Controls&nbsp;2](./qt_quick_controls_2)
	*	Лекция:
		[cлайды](./qt_quick_controls_2/lecture.fodp),
		[конспект](./qt_quick_controls_2/lecture.md)
	*	[Задания](./qt_quick_controls_2/tasks.md)
	*	[Тесты](./qt_quick_controls_2/tests.md)
*	Основы разработки на Qt/C++
	*	[Объектная модель Qt](./qt_object_model)
		*	Лекция:
			[cлайды](./qt_object_model/lecture.fodp),
			[конспект](./qt_object_model/lecture.md)
		*	[Тесты](./qt_object_model/tests.md)
	*	[Moc и макросы](./moc_macro)
		*	Лекция:
			[cлайды](./moc_macro/lecture.fodp),
			[конспект](./moc_macro/lecture.md)
		*	[Тесты](./moc_macro/tests.md)
	*	[Qt Application и цикл событий](./qt_application)
		*	Лекция:
			[cлайды](./qt_application/lecture.fodp),
			[конспект](./qt_application/lecture.md)
		*	[Тесты](./qt_application/tests.md)
	*	[Аргументы командной строки](./command_line_arguments)
		*	Лекция:
			[cлайды](./command_line_arguments/lecture.fodp),
			[конспект](./command_line_arguments/lecture.md)
		*	[Тесты](./command_line_arguments/tests.md)
	*	[Ручной запуск с UI или без него](./start_ui)
		*	Лекция:
			[cлайды](./start_ui/lecture.fodp),
			[конспект](./start_ui/lecture.md)
		*	[Тесты](./start_ui/tests.md)
	*	[Libauroraapp](./libauroraapp)
		*	Лекция:
			[cлайды](./libauroraapp/lecture.fodp),
			[конспект](./libauroraapp/lecture.md)
		*	[Тесты](./libauroraapp/tests.md)
	*	[QObject, сигналы и слоты](./cpp_signals_and_slots)
		*	Лекция:
			[cлайды](./cpp_signals_and_slots/lecture.fodp),
			[конспект](./cpp_signals_and_slots/lecture.md)
		*	[Тесты](./cpp_signals_and_slots/tests.md)
	*	[Система сборки CMake](./cmake_base)
		*	Лекция:
			[cлайды](./cmake_base/lecture.fodp),
			[конспект](./cmake_base/lecture.md)
		*	[Тесты](./cmake_base/tests.md)
	*	[Подключение ресурсов и библиотек](./cmake_resources)
		*	Лекция:
			[cлайды](./cmake_resources/lecture.fodp),
			[конспект](./cmake_resources/lecture.md)
		*	[Тесты](./cmake_resources/tests.md)
*	[Жизненный цикл приложения в&nbsp;ОС&nbsp;Аврора](./aurora_app_lifecycle)
	*	Лекция:
		[cлайды](./aurora_app_lifecycle/lecture.fodp),
		[конспект](./aurora_app_lifecycle/lecture.md)
	*	[Примеры](./aurora_app_lifecycle/examples.md)
	*	[Задания](./aurora_app_lifecycle/tasks.md)
	*	[Тесты](./aurora_app_lifecycle/tests.md)
*	[Локальные файлы](./local_files)
	*	Лекция:
		[cлайды](./local_files/lecture.fodp),
		[конспект](./local_files/lecture.md)
	*	[Тесты](./local_files/tests.md)
*	Мультимедиа
	*	[Воспроизведение аудио](./play_audio)
		*	Лекция:
			[cлайды](./play_audio/lecture.fodp),
			[конспект](./play_audio/lecture.md)
		*	[Примеры](./play_audio/examples.md)
		*	[Задания](./play_audio/tasks.md)
		*	[Тесты](./play_audio/tests.md)
	*	[Воспроизведение видео](./play_video)
		*	Лекция:
			[cлайды](./play_video/lecture.fodp),
			[конспект](./play_video/lecture.md)
		*	[Примеры](./play_video/examples.md)
		*	[Задания](./play_video/tasks.md)
		*	[Тесты](./play_video/tests.md)
	*	[Работа со списками воспроизведения](./playlist)
		*	Лекция:
			[cлайды](./playlist/lecture.fodp),
			[конспект](./playlist/lecture.md)
		*	[Примеры](./playlist/examples.md)
		*	[Задания](./playlist/tasks.md)
		*	[Тесты](./playlist/tests.md)
	*	[Запись звука](./audio_capture)
		*	Лекция:
			[cлайды](./audio_capture/lecture.fodp),
			[конспект](./audio_capture/lecture.md)
		*	[Примеры](./audio_capture/examples.md)
		*	[Задания](./audio_capture/tasks.md)
		*	[Тесты](./audio_capture/tests.md)
	*	[Camera – настройка, получение информации о доступных камерах](./camera_setup)
		*	Лекция:
			[cлайды](./camera_setup/lecture.fodp),
			[конспект](./camera_setup/lecture.md)
		*	[Примеры](./camera_setup/examples.md)
		*	[Тесты](./camera_setup/tests.md)
	*	[Camera – захват изображений](./camera_image_capture)
		*	Лекция:
			[cлайды](./camera_image_capture/lecture.fodp),
			[конспект](./camera_image_capture/lecture.md)
		*	[Примеры](./camera_image_capture/examples.md)
		*	[Тесты](./camera_image_capture/tests.md)
	*	[QrFilter](./qrfilter)
		*	Лекция:
			[cлайды](./qrfilter/lecture.fodp),
			[конспект](./qrfilter/lecture.md)
		*	[Тесты](./qrfilter/tests.md)
	*	[Захват видео в StreamCamera](./video_capture_streamcamera)
		*	Лекция:
			[cлайды](./video_capture_streamcamera/lecture.fodp),
			[конспект](./video_capture_streamcamera/lecture.md)
		*	[Тесты](./video_capture_streamcamera/tests.md)
	*	[Захват видео в QtMultimedia](./video_capture_qt)
		*	Лекция:
			[cлайды](./video_capture_qt/lecture.fodp),
			[конспект](./video_capture_qt/lecture.md)
		*	[Тесты](./video_capture_qt/tests.md)
	*	[Qt VideoChat](./qt_videochat)
		*	Лекция:
			[cлайды](./qt_videochat/lecture.fodp),
			[конспект](./qt_videochat/lecture.md)
		*	[Тесты](./qt_videochat/tests.md)
	*	[Lottie](./lottie)
		*	Лекция:
			[cлайды](./lottie/lecture.fodp),
			[конспект](./lottie/lecture.md)
		*	[Тесты](./lottie/tests.md)
	*	[Thumbnailer](./thumbnailer)
		*	Лекция:
			[cлайды](./thumbnailer/lecture.fodp),
			[конспект](./thumbnailer/lecture.md)
		*	[Примеры](./thumbnailer/examples.md)
		*	[Задания](./thumbnailer/tasks.md)
		*	[Тесты](./thumbnailer/tests.md)
*	Работа с сетью
	*	[Протокол HTTP](./http)
		*	Лекция:
			[cлайды](./http/lecture.fodp),
			[конспект](./http/lecture.md)
		*	[Тесты](./http/tests.md)
	*	[XmlHttpRequest](./xmlhttprequest)
		*	Лекция:
			[cлайды](./xmlhttprequest/lecture.fodp),
			[конспект](./xmlhttprequest/lecture.md)
		*	[Примеры](./xmlhttprequest/examples.md)
		*	[Задания](./xmlhttprequest/tasks.md)
		*	[Тесты](./xmlhttprequest/tests.md)
	*	[Qt Network](./qt_network)
		*	Лекция:
			[cлайды](./qt_network/lecture.fodp),
			[конспект](./qt_network/lecture.md)
		*	[Тесты](./qt_network/tests.md)
	*	[Проверка доступности сети](./check_connection)
		*	Лекция:
			[cлайды](./check_connection/lecture.fodp),
			[конспект](./check_connection/lecture.md)
		*	[Тесты](./check_connection/tests.md)
	*	[Основы WebSocket](./websocket_base)
		*	Лекция:
			[cлайды](./websocket_base/lecture.fodp),
			[конспект](./websocket_base/lecture.md)
		*	[Тесты](./websocket_base/tests.md)
	*	[WebSocket Client](./websocket_client)
		*	Лекция:
			[cлайды](./websocket_client/lecture.fodp),
			[конспект](./websocket_client/lecture.md)
		*	[Тесты](./websocket_client/tests.md)
	*	[WebSocket Server](./websocket_server)
		*	Лекция:
			[cлайды](./websocket_server/lecture.fodp),
			[конспект](./websocket_server/lecture.md)
		*	[Тесты](./websocket_server/tests.md)
	*	[WebRTC](./webrtc)
		*	Лекция:
			[cлайды](./webrtc/lecture.fodp),
			[конспект](./webrtc/lecture.md)
		*	[Тесты](./webrtc/tests.md)
*	Датчики
*	Геолокация
*	Базы данных
*	Многопоточность
*	Системы сборки qmake и&nbsp;cmake
*	Информация об&nbsp;устройстве
*	NFC и&nbsp;токены
*	Другие API ОС&nbsp;Аврора
*	Локализация приложений
	*	[Интернационализация в Qt](./internationalization)
		*	Лекция:
			[cлайды](./internationalization/lecture.fodp),
			[конспект](./internationalization/lecture.md)
		*	[Тесты](./internationalization/tests.md)
	*	[Локализация с QLocale](./qlocale)
		*	Лекция:
			[cлайды](./qlocale/lecture.fodp),
			[конспект](./qlocale/lecture.md)
		*	[Тесты](./qlocale/tests.md)
	*	[Функции для переводов и QTranslator](./qtranslator)
		*	Лекция:
			[cлайды](./qtranslator/lecture.fodp),
			[конспект](./qtranslator/lecture.md)
		*	[Примеры](./qtranslator/examples.md)
		*	[Тесты](./qtranslator/tests.md)
		
	*	[Процесс перевода](./translation_process) +пример для CMakeLists.txt
		*	Лекция:
			[cлайды](./translation_process/lecture.fodp),
			[конспект](./translation_process/lecture.md)
		*	[Тесты](./translation_process/tests.md)
		
	*	[Перевод на основе идентификаторов текста](./translation_text_id)
		*	Лекция:
			[cлайды](./translation_text_id/lecture.fodp),
			[конспект](./translation_text_id/lecture.md)
		*	[Тесты](./translation_text_id/tests.md)
	*	[Qt Linguist](./qt_linguist)
		*	Лекция:
			[cлайды](./qt_linguist/lecture.fodp),
			[конспект](./qt_linguist/lecture.md)
		*	[Тесты](./qt_linguist/tests.md)
	*	[Рекомендации по стилю переводов](./translation_style)
		*	Лекция:
			[cлайды](./translation_style/lecture.fodp),
			[конспект](./translation_style/lecture.md)
		*	[Задания](./translation_style/tasks.md)
		*	[Тесты](./translation_style/tests.md)
*	Тестирование приложений
