# Проверка доступности сети

Copyright&nbsp;©&nbsp;2016–2025 ООО&nbsp;«Открытая мобильная платформа».
Этот документ предоставляется в&nbsp;соответствии
с&nbsp;[Публичной лицензией Creative Commons с&nbsp;указанием авторства версии&nbsp;4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Доступность адреса

Разработчику приложений для ОС Аврора доступны несколько способов проверить сетевое соединение, используя методы API Qt Network. При этом для приложения должно быть указано разрешение Internet в desktop-файле.

Метод QNetworkConfigurationManager::isOnline() проверяет доступность заданного адреса. 
Метод возвращает true, если указанный адрес доступен с мобильного устройства, в противном случае возвращает false.

## Соединение с хостом

Метод QNetworkAccessManager::connectToHost(const QString &hostName, quint16 port = 80) инициирует соединение с хостом, заданным именем hostName и портом port. Данный метод полезен для установки соединения по протоколу TCP с хостом до того, как будет выполнен HTTP-запрос, с целью уменьшения задержки сети.

Метод не имеет возможности сообщать об ошибках.

## Поиск хоста

Метод QHostInfo::lookupHost(const QString &name, QObject *receiver, const char *member) определяет IP-адреса, связанные с именем хоста name, и возвращает идентификатор ID для поиска. При завершении поиска слот или сигнал member объекта receiver вызывается с аргументом типа QHostInfo, который можно использовать для получения результата поиска.

Поиск выполняется одним вызовом функции.

Если устройство подключено к Аврора Центр, рекомендуется использовать адрес его сервера для проверки подключения.

В качестве значения параметра name можно передать IP-адрес. В этом случае метод QHostInfo будет искать доменное имя для IP (т.е. QHostInfo выполнит обратный поиск). В случае успеха результирующий QHostInfo будет содержать как разрешённое доменное имя, так и IP-адреса для имени хоста.

В случае запуска нескольких запросов с помощью lookupHost() порядок отправки сигналов может быть произвольным.
